<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Edit language
* @package TenderSystem
* @subpackage language
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

if(!$cfg['languageeditor']['enable']) {
	// Not Enabled
	xml_generator("languageeditor","error","e44","",$cfg);
} elseif(!$_SESSION['ts_id']) {
	// No Session
	xml_generator("languageeditor","error","e17","",$cfg);
}
// field request errors and type 
$fields_request = array (
	'reflang'	=> array("",	REQUEST_LANG,	FORMAT_NONE,	"e27"),
	'lang'		=> array("",	REQUEST_LANG,	FORMAT_NONE,	"e28"),
	'repair'	=> array(),
	'upload'	=> array(),
	'export'	=> array(),
	'remove'	=> array(),
	'import'	=> array()		
);
if(!get_request($fields_request,$params,$error,$cfg)) {
	// display error
	xml_generator("languageeditor","error",$error,"",$cfg);
}
$file = $_FILES['file'];
if(function_exists('gzcompress')) {
	$zlib = TRUE;
}
if($params['upload']) {
	// field request errors and type 
	$fields_request = array (
		'excelupload'	=> array("e26",	REQUEST_LANG,	FORMAT_NONE,	"e28")
	);
	if(get_request($fields_request,$info,$error,$cfg)) {
		$file = $_FILES['filename'];
		// upload the file
		$upload_dest = file_upload($file,"language",$cfg);
		if(!file_exists("language/".$params['lang']."/spreadsheet/")) {
			if(!mkdir("language/".$params['lang']."/spreadsheet/",0775)) {
				// display error
				xml_generator("languageeditor","error","e30","",$cfg);
			}
		}
		if(copy($upload_dest,"language/".$params['lang']."/spreadsheet/".$excelupload)) {
			$params['updated'] = "1";
		} else {
			$params['failure'] = "1";
		}
		$mainpage = TRUE;
	} else {
		// display error
		xml_generator("languageeditor","error",$error,"",$cfg);
	}
} else {
	if($params['export']) {
		$exportpage = TRUE;
	} elseif($params['import']) {
		$importpage = TRUE;
	} elseif($params['remove']) {
		$removepage = TRUE;
	} elseif($params['repair']) {
		$repairpage = TRUE;
	} else {
		$mainpage = TRUE;
	}
}

if($mainpage && $params['reflang'] && $params['lang']) {
	read_language($params,$cfg);
	$params['module'] = "languageeditor";
	$params['function'] = "edit";
	// display message
	send_message($params,$cfg);
} elseif($exportpage && $params['lang']) {
	if($cfg['api']['connection'] == "module") {
		if($zlib) {
			// display message
			xml_generator("languageeditor","export","",$params,$cfg);
		} else {
			// display message (no zlib)
			xml_generator("languageeditor","error","e40","",$cfg);
		}
	} else {
		// display message
		xml_generator("languageeditor","error","e16","",$cfg);
	}
} elseif($removepage && $params['lang']) {
	if($cfg['api']['connection'] == "module") {
		unset($params['remove']);
		// display message
		xml_generator("languageeditor","remove","",$params,$cfg);
	} else {
		// display message
		xml_generator("languageeditor","error","e16","",$cfg);
	}
} elseif($importpage && $file) {
	// must be on module
	if($cfg['api']['connection'] == "module") {
		if($zlib) {
			// must be a zip file
			if(strpos($file['type'],"zip") || strpos($file['name'],"zip")) {
				$upload_dest = file_upload($file,"languageeditor",$cfg);
				require(getcwd()."/modules/external/class/dunzip/dUnzip2.inc.php");
				$new_dunzip = new dUnzip2($upload_dest);
				$params['language'][0]['file'] = $upload_dest;
				$params['language'][0]['file_count'] = count($new_dunzip->getList());
				$info = unserialize($new_dunzip->getZipInfo("zipfile_comment"));
				if(is_array($info)) {
					$params['language'][0] = array_merge($params['language'][0],$info);
				}
				$new_dunzip->close();
				if(file_exists("modules/generic/language/".$params['language'][0]['lang'])) {
					$params['exists'] = "1";
				}
				xml_generator("languageeditor","import","",$params,$cfg);
			} else {
				// display message
				xml_generator("languageeditor","error","e20","",$cfg);
			}
		} else {
			// display message (no zlib)
			xml_generator("languageeditor","error","e40","",$cfg);
		}
	} else {
		// display message (not on module)
		xml_generator("languageeditor","error","e16","",$cfg);
	}
} elseif($repairpage && $params['reflang'] && $params['lang']) {
	include("modules/languageeditor/_loader.php");
	$cfg['module']['version'] = $loader['module']['version'];
	repair_language($params,$cfg);
	xml_generator("languageeditor","repair","",$params,$cfg);
} elseif($exportpage && $params['lang']) {
	if($cfg['api']['connection'] == "module") {
		if($zlib) {
			// display message
			xml_generator("languageeditor","export","",$params,$cfg);
		} else {
			// display message (no zlib)
			xml_generator("languageeditor","error","e40","",$cfg);
		}
	} else {
		// display message
		xml_generator("languageeditor","error","e16","",$cfg);
	}
} else {
	// missing ref language or main language	
	xml_generator("languageeditor","error","e15","",$cfg);
}
?>