<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Edit API language files
* @package TenderSystem
* @subpackage language
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

if(!$cfg['languageeditor']['enable']) {
	// Not Enabled
	xml_generator("languageeditor","error","e44","",$cfg);
} elseif(!$_SESSION['ts_id']) {
	// No Session
	xml_generator("languageeditor","error","e17","",$cfg);
}
// field request errors and type 
$fields_request = array (
	'update'	=> array()	
);
get_request($fields_request,$action,$error,$cfg);
if($action['update']) {
	// field request errors and type 
	$fields_request = array (
		'reflang'			=> array("e25",	REQUEST_LANG,	FORMAT_NONE,	"e27"),
		'lang'				=> array("e26",	REQUEST_LANG,	FORMAT_NONE,	"e28"),
		'languagemodule'	=> array("e31"),
		'values'			=> array("e32")
	);
	if(get_request($fields_request,$info,$error,$cfg)) {		
		$params['module'] = "languageeditor";
		$params['function'] = "editappmodule";
		$params['languagemodule'] = $info['languagemodule'];
		$params['lang'] = $info['lang'];
		$params['reflang'] = $info['reflang'];
		$params['values'] = $info['values'];
		read_language($params,$cfg);
		// display message
		send_message($params,$cfg);
	} else {
		// display error
		xml_generator("languageeditor","error",$error,"",$cfg);
	}
} else {
	// field request errors and type 
	$fields_request = array (
		'reflang'			=> array("e25",	REQUEST_LANG,	FORMAT_NONE,	"e27"),
		'lang'				=> array("e26",	REQUEST_LANG,	FORMAT_NONE,	"e28"),
		'languagemodule'	=> array("e31")
	);
	if(get_request($fields_request,$info,$error,$cfg)) {
		$params['module'] = "languageeditor";
		$params['function'] = "editappmodule";
		$params['languagemodule'] = "modules/".$info['languagemodule'];
		$params['lang'] = sanitise($info['lang']);
		$params['reflang'] = sanitise($info['reflang']);
		// display message
		send_message($params,$cfg);
	} else {
		// display error
		xml_generator("languageeditor","error",$error,"",$cfg);
	}
}
?>