<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Edit calendar language fies
* @package TenderSystem
* @subpackage language
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

if(!$cfg['languageeditor']['enable']) {
	// Not Enabled
	xml_generator("languageeditor","error","e44","",$cfg);
} elseif(!$_SESSION['ts_id']) {
	// No Session
	xml_generator("languageeditor","error","e17","",$cfg);
}
// field request errors and type 
$fields_request = array (
	'update'	=> array()		
);
get_request($fields_request,$action,$error,$cfg);
// set the variables
$update = sanitise($_POST['update']);
if($action['update']) {
	// field request errors and type 
	$fields_request = array (
		'reflang'			=> array("e25",	REQUEST_LANG,	FORMAT_NONE,	"e27"),
		'lang'				=> array("e26",	REQUEST_LANG,	FORMAT_NONE,	"e28"),
		'values'			=> array("e32")
	);
	if(get_request($fields_request,$info,$error,$cfg)) {
		if(!file_exists("modules/external/language/".$info['lang']) && !mkdir("modules/external/language/".$info['lang'],0755)) {
			$params['error'][] = "e11";
		}
		if(!$params['error']) {
			$file_contents = '<?xml version="1.0" encoding="UTF-8"?>'."\n";
			$file_contents.= '<l lang="'.$params['lang'].'">'."\n";
			$caljs = file_get_contents("modules/external/javascript/calendar/templates/calendar.js");
			if($caljs) {
				foreach($info['values'] as $key => $value) {
					$find[] = '#'.strtolower($key).'#';
					$replace[] = $value;
					$file_contents.= "\t<".strtolower($key).">".$value."</".strtolower($key).">\n";
				}
				$caljs = str_replace($find,$replace,$caljs);
				$fp = fopen("modules/external/language/".$info['lang']."/calendar.js","w+");
				// check if file open okay
				if (!$fp) {
					$params['error'][] = "e12";
				} else {
					// write new data back into file
					if(!fwrite($fp,$caljs,strlen($caljs))) {
						$params['error'][] = "e12";
					}
					// close file
					fclose($fp); 
					$params['updated'] = "1";
				}
				
				$file_contents.= '</'.$params['file'][0].'>';
				// open file for writing
				$fp = fopen("modules/external/language/".$info['lang']."/calendar.xml".$params['file'],"w+");
				// check if file open okay
				if (!$fp) {
					$params['error'][] = "e13";
				} else {
					// write new data back into file
					if(!fwrite($fp,$file_contents,strlen($file_contents))) {
						$params['error'][] = "e13";
					}
					// close file
					fclose($fp);
				} 
			} else {
				// could not read template file
				$params['error'][] = "e38";
			}
		}
		$params['module'] = "languageeditor";
		$params['function'] = "edit";
		$params['lang'] = $info['lang'];
		$params['reflang'] = $info['reflang'];
		read_language($params,$cfg);
		// display message
		send_message($params,$cfg);
	} else {
		// display error
		xml_generator("languageeditor","error",$error,"",$cfg);
	}
} else {
	// field request errors and type 
	$fields_request = array (
		'reflang'			=> array("e25",	REQUEST_LANG,	FORMAT_NONE,	"e27"),
		'lang'				=> array("e26",	REQUEST_LANG,	FORMAT_NONE,	"e28")
	);
	if(get_request($fields_request,$info,$error,$cfg)) {
		$xml_content = file_get_contents("modules/external/language/".$info['reflang']."/calendar.xml");
		// create parser
		$xml_parser = xml_parser_create();
		// parse xml into $xml_array
		$good_parse = xml_parse_into_struct($xml_parser, $xml_content, $xml_array, $index);
		// free parser
		xml_parser_free($xml_parser);
		if(!$good_parse) {
			$errors[] = "e14";
		}
		if(!file_exists("modules/external/language/".$info['lang']."/calendar.xml")) {
			$new = TRUE;
		}
		if(!$new) {
			$xml_content = file_get_contents("modules/external/language/".$info['lang']."/calendar.xml");
			// create parser
			$xml_parser = xml_parser_create();
			// parse xml into $xml_array
			$good_parse = xml_parse_into_struct($xml_parser, $xml_content, $xml_array1, $index1);
			// free parser
			xml_parser_free($xml_parser);
		}
		if(!$errors) {
			// get information from xml_array
			foreach($xml_array as $value) {
				unset($phrase);
				// category id
				if($value['level'] == "2") {
					$phrase['name'] = $value['tag'];
					$phrase['refvalue'] = $value['value'];
					if($new) {
						$phrase['value'] = "|".$value['value']."|";
					} else{
						foreach($xml_array1 as $value1) {
							if($value['level'] == $value1['level'] && $value['tag'] == $value1['tag']) {
								$phrase['value'] = $value1['value'];
								break;
							}
						}
					}
					$params['phrase'][] = $phrase;
				}
			}
		}
		$params['reflang'] = $info['reflang'];
		$params['lang'] = $info['lang'];
		// display message
		xml_generator("languageeditor","editcalendar",$errors,$params,$cfg);
	} else {
		// display error
		xml_generator("languageeditor","error",$error,"",$cfg);
	}
}
?>