<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Edit GUI language files
* @package TenderSystem
* @subpackage language
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

if(!$cfg['languageeditor']['enable']) {
	// Not Enabled
	xml_generator("languageeditor","error","e44","",$cfg);
} elseif(!$_SESSION['ts_id']) {
	// No Session
	xml_generator("languageeditor","error","e17","",$cfg);
}
// field request errors and type 
$fields_request = array (
	'update'	=> array()	
);
get_request($fields_request,$action,$error,$cfg);
if($action['update']) {
	// field request errors and type 
	$fields_request = array (
		'reflang'			=> array("e25",	REQUEST_LANG,	FORMAT_NONE,	"e27"),
		'lang'				=> array("e26",	REQUEST_LANG,	FORMAT_NONE,	"e28"),
		'languagemodule'	=> array("e31"),
		'mainvalues'		=> array(),
		'errorvalues'		=> array()
	);
	if(get_request($fields_request,$info,$error,$cfg)) {
		// write main language file
		if($info['mainvalues']) {
			// xml header
			$file_contents = '<?xml version="1.0" encoding="UTF-8"?>'."\n";
			$file_contents.= '<l lang="'.$info['lang'].'">'."\n";
			// main contents
			foreach($info['mainvalues'] as $key => $value) {
				foreach($value as $value1) {
					$file_contents.= "\t<".strtolower($key).">".$value1."</".strtolower($key).">\n";
				}
			}
			$file_contents.= '</l>';
			// open file for writing
			$fp = fopen($info['languagemodule']."/language/".$info['lang']."/default.xml","w+");
			// check if file open okay
			if (!$fp) {
				$errors[] = "e6";
			} else {
				// write new data back into file
				if(!fwrite($fp,$file_contents,strlen($file_contents))) {
					$errors[] = "e6";
				}
				// close file
				fclose($fp); 
				$params['updated'] = "1";
			}
		}
		unset($file_contents);
		// write error language file
		if($info['errorvalues']) {
			// xml header
			$file_contents = '<?xml version="1.0" encoding="UTF-8"?>'."\n";
			$file_contents.= '<e lang="'.$info['lang'].'">'."\n";
			// main contents
			foreach($info['errorvalues'] as $key => $value) {
				$file_contents.= "\t<error id=\"".strtolower($key)."\">".$value."</error>\n";
			}
			$file_contents.= '</e>';
			// open file for writing
			$fp = fopen($info['languagemodule']."/language/".$info['lang']."/error.xml","w+");
			// check if file open okay
			if (!$fp) {
				$errors[] = "e8";
			} else {
				// write new data back into file
				if(!fwrite($fp,$file_contents,strlen($file_contents))) {
					$errors[] = "e8";
				}
				// close file
				fclose($fp); 
				$params['updated'] = "1";
			}
		}
		$params['module'] = "languageeditor";
		$params['function'] = "edit";
		$params['lang'] = $info['lang'];
		$params['reflang'] = $info['reflang'];
		read_language($params,$cfg);
		// display message
		send_message($params,$cfg);
	} else {
		// display error
		xml_generator("languageeditor","error",$error,"",$cfg);
	}
} else {
	// field request errors and type 
	$fields_request = array (
		'reflang'			=> array("e25",	REQUEST_LANG,	FORMAT_NONE,	"e27"),
		'lang'				=> array("e26",	REQUEST_LANG,	FORMAT_NONE,	"e28"),
		'languagemodule'	=> array("e31")
	);
	if(get_request($fields_request,$info,$error,$cfg)) {
		$params['languagemodule'] = "modules/".$info['languagemodule'];
		$params['lang'] = $info['lang'];
		$params['reflang'] = $info['reflang'];
		if(!file_exists($params['languagemodule']."/language/".$params['reflang'])) {
			mkdir($params['languagemodule']."/language/".$params['reflang'],0775);
		}
		// get language file
		$xml_content = file_get_contents($params['languagemodule']."/language/".$params['reflang']."/default.xml");
		// create parser
		$xml_parser = xml_parser_create();
		// parse xml into $xml_array
		$good_parse = xml_parse_into_struct($xml_parser, $xml_content, $xml_array, $index);
		// free parser
		xml_parser_free($xml_parser);
		if(!$good_parse) {
			// Can't Parse Xml
			$errors[] = "e5";
			// display message
			xml_generator("languageeditor","editguixml",$errors,$params,$cfg);
		} else {
			// check if first time editing
			if(!file_exists($params['languagemodule']."/language/".$params['lang']."/default.xml")) {
				if(!copy($params['languagemodule']."/language/".$params['reflang']."/default.xml",$params['languagemodule']."/language/".$params['lang']."/default.xml")) {
					// Can't create default.xml
					$errors[] = "e6";
				} else {
					$new = TRUE;
				}
			}
			if(!$errors) {
				if(!$new) {
					$xml_content = file_get_contents($params['languagemodule']."/language/".$params['lang']."/default.xml");
					// create parser
					$xml_parser = xml_parser_create();
					// parse xml into $xml_array
					$good_parse = xml_parse_into_struct($xml_parser, $xml_content, $xml_array1, $index1);
					// free parser
					xml_parser_free($xml_parser);
				}
				// get information from xml_array
				foreach($xml_array as $value) {
					// category id
					if($value['level'] == "2") {
						$phrase['name'] = $value['tag'];
						$phrase['refvalue'] = $value['value'];
						if($new) {
							// xml tags that should not be changed
							$noalter = array();
							if(in_array($value['tag'],$noalter)) {
								$phrase['value'] = $value['value'];
							} else {
								$phrase['translated'] = "no";
								// use reference language value so long
								$phrase['value'] = $value['value'];
							}
						} else{
							// find the matching value
							$i = 1;
							foreach($xml_array1 as $value1) {
								// make sure the same value is not used twice
								if($value['level'] == $value1['level'] && $value['tag'] == $value1['tag']) {
									if($i > $count[$value['tag']]) {
										$phrase['translated'] = $value1['attributes']['TRANSLATED'];
										$phrase['value'] = $value1['value'];
										$count[$value['tag']]++;
										break;
									} else {
										$i++;	
									}
								}
							}
							// check if found value
							if(!$phrase['value']) {
								$phrase['translated'] = "no";
								// use reference language value so long
								$phrase['value'] = $value['value'];
							}
						}
						$params['main'][0]['phrase'][] = $phrase;
						unset($phrase);
					}
				}
				// get error file
				$xml_content = file_get_contents($params['languagemodule']."/language/".$params['reflang']."/error.xml");
				// create parser
				$xml_parser = xml_parser_create();
				// parse xml into $xml_array
				$good_parse = xml_parse_into_struct($xml_parser, $xml_content, $xml_array, $index);
				// free parser
				xml_parser_free($xml_parser);
				if(!$good_parse) {
					// Can't parse error.xml
					$errors[] = "e7";
					// display message
					xml_generator("languageeditor","editguixml",$errors,$params,$cfg);
				} else {
					if(!file_exists($params['languagemodule']."/language/".$params['lang']."/error.xml")) {
						if(!copy($params['languagemodule']."/language/".$params['reflang']."/error.xml",$params['languagemodule']."/language/".$params['lang']."/error.xml")) {
							// Can't create error.xml
							$errors[] = "e8";
						} else {
							$new = TRUE;
						}
					}
					if(!$errors) {
						if(!$new) {
							$xml_content = file_get_contents($params['languagemodule']."/language/".$params['lang']."/error.xml");
							// create parser
							$xml_parser = xml_parser_create();
							// parse xml into $xml_array
							$good_parse = xml_parse_into_struct($xml_parser, $xml_content, $xml_array1, $index1);
							// free parser
							xml_parser_free($xml_parser);
						}
						// get information from xml_array
						foreach($xml_array as $value) {
							if($value['level'] == "2" && $value['tag'] == "ERROR") {
								$phrase['name'] = $value['attributes']['ID'];
								$phrase['refvalue'] = $value['value'];
								if($new) {
									$phrase['translated'] = "no";
									$phrase['value'] = $value['value'];
								} else {
									foreach($xml_array1 as $value1) {
										if($value['level'] == $value1['level'] && $value['attributes']['ID'] == $value1['attributes']['ID']) {
											$phrase['translated'] = $value1['attributes']['TRANSLATED'];
											$phrase['value'] = $value1['value'];
										}
										// check if found value
										if(!$phrase['value']) {
											$phrase['translated'] = "no";
											// use reference language value so long
											$phrase['value'] = $value['value'];
										}
									}
								}
								$params['errorfile'][0]['phrase'][] = $phrase;
								unset($phrase);
							}
						}
					}
				}
				// display message
				xml_generator("languageeditor","editguimodule",$errors,$params,$cfg);
			}
		}
	} else {
		// display error
		xml_generator("languageeditor","error",$error,"",$cfg);
	}
}
?>