<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Edit country language files
* @package TenderSystem
* @subpackage language
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

if(!$cfg['languageeditor']['enable']) {
	// Not Enabled
	xml_generator("languageeditor","error","e44","",$cfg);
} elseif(!$_SESSION['ts_id']) {
	// No Session
	xml_generator("languageeditor","error","e17","",$cfg);
}
// field request errors and type 
$fields_request = array (
	'update'	=> array()	
);
get_request($fields_request,$action,$error,$cfg);
if($action['update']) {
	// field request errors and type 
	$fields_request = array (
		'reflang'			=> array("e25",	REQUEST_LANG,	FORMAT_NONE,	"e27"),
		'lang'				=> array("e26",	REQUEST_LANG,	FORMAT_NONE,	"e28"),
		'refvalues'			=> array("e32"),
		'values'			=> array("e32")
	);
	if(get_request($fields_request,$info,$error,$cfg)) {
		$values = sanitise($_POST['values']);
		$file_contents = '<?xml version="1.0" encoding="utf-8"?>'."\n";
		$file_contents.= '<l lang="'.$info['lang'].'">'."\n";
		foreach($info['values'] as $key => $value) {
			$file_contents.= "\t<langcode>\n";
			$file_contents.= "\t\t<name>".$value."</name>\n";
			$file_contents.= "\t\t<isocode>".$info['refvalues'][$key]."</isocode>\n";
			$file_contents.= "\t</langcode>\n";
		}
		$file_contents.= '</l>';
		// open file for writing
		$fp = fopen("modules/generic/language/".$info['lang']."/language.xml","w+");
		// check if file open okay
		if (!$fp) {
			// can't create language.xml
			$params['error'][] = "e42";
		} else {
			// write new data back into file
			if(!fwrite($fp,$file_contents,strlen($file_contents))) {
				// can't create language.xml
				$params['error'][] = "e42";
			}
			// close file
			fclose($fp); 
			$params['updated'] = "1";
		}
		$params['module'] = "languageeditor";
		$params['function'] = "edit";
		$params['lang'] = $info['lang'];
		$params['reflang'] = $info['reflang'];
		read_language($params,$cfg);
		// display message
		send_message($params,$cfg);
	} else {
		// display error
		xml_generator("languageeditor","error",$error,"",$cfg);
	}
} else {
	// field request errors and type 
	$fields_request = array (
		'reflang'			=> array("e25",	REQUEST_LANG,	FORMAT_NONE,	"e27"),
		'lang'				=> array("e26",	REQUEST_LANG,	FORMAT_NONE,	"e28")
	);
	if(get_request($fields_request,$info,$error,$cfg)) {
		$xml_content = file_get_contents("modules/generic/language/".$info['reflang']."/language.xml");
		// create parser
		$xml_parser = xml_parser_create();
		// parse xml into $xml_array
		$good_parse = xml_parse_into_struct($xml_parser, $xml_content, $xml_array, $index);
		// free parser
		xml_parser_free($xml_parser);
		if(!$good_parse) {
			// Can't Parse Country.xml
			$errors = "e41";
		}
		$params['file'] = "modules/generic/language/".$info['lang']."/language.xml";
		if(!file_exists($params['file'])) {
			$new = TRUE;
		} else {
			$xml_content = file_get_contents($params['file']);
			// create parser
			$xml_parser = xml_parser_create();
			// parse xml into $xml_array
			$good_parse = xml_parse_into_struct($xml_parser, $xml_content, $xml_array1, $index1);
			// free parser
			xml_parser_free($xml_parser);
		}
		if(!$errors) {
			// get information from xml_array
			foreach($xml_array as $value) {
				if($value['tag'] == "LANGCODE" && $value['type'] == "open") {
					unset($langcode);
				}
				// country name
				if($value['tag'] == "NAME") {
					$langcode['name'] = $value['value'];
				}
				if($value['tag'] == "ISOCODE") {
					$langcode['isocode'] = $value['value'];
				}
				if($value['tag'] == "NAME" && $new) {
						$langcode['value'] = "|".$value['value']."|";
				}
				if($value['tag'] == "LANGCODE" && $value['type'] == "close") {
					if(!$new) {
						foreach($xml_array1 as $value1) {
							if($value1['tag'] == "NAME") {
								$the_value = $value1['value'];
							}
							if($value1['tag'] == "ISOCODE" && $langcode['isocode'] == $value1['value']) {
								$langcode['value'] = $the_value;
								$params['phrase'][] = $langcode;
								break;
							}
						}
					} else {
						$params['phrase'][] = $langcode;
					}
				}
			}
			$params['lang'] = $info['lang'];
			$params['reflang'] = $info['reflang'];
			xml_generator("languageeditor","editlanguages","",$params,$cfg);
		}
	} else {
		// display error
		xml_generator("languageeditor","error",$error,"",$cfg);
	}
}
?>