<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Export language pack
* @package TenderSystem
* @subpackage language
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// set the variables
if(!$cfg['languageeditor']['enable']) {
	// Not Enabled
	xml_generator("languageeditor","error","e44","",$cfg);
} elseif(!$_SESSION['ts_id']) {
	// No Session
	xml_generator("languageeditor","error","e17","",$cfg);
} else {
	// field request errors and type 
	$fields_request = array (
		'lang'			=> array("e26",	REQUEST_LANG,	FORMAT_NONE,	"e28"),
		'translator'	=> array(),
		'license'		=> array(),
		'copyright'		=> array()
	);
	if(get_request($fields_request,$info,$error,$cfg)) {
		if($cfg['api']['connection'] == "module") {
			$language['lang'] = $lang = $info['lang'];
			$language['translator'] =  $info['translator'];
			$language['copyright'] =  $info['copyright'];
			$language['license'] =  $info['license'];
			$language['date'] = date("Y-m-d");
			$language['version'] = $cfg['version'];
			include(getcwd()."/modules/languageeditor/_loader.php");
			$language['languageeditor'] = $loader['module']['version'];			
			$files = array_merge(examinedir("application/include/modules"),examinedir("modules"));
			foreach($files as $value) {
				if(strpos($value,"/language/".$lang)) {
					if (strpos($value,"CVS") === FALSE && strpos($value,".svn") === FALSE ) {
						$file['name'][] = $value;
					}
				}
			}
			$coded_array = serialize($language);
			require(getcwd()."/modules/external/class/dunzip/dZip.inc.php");
			$filename = tempnam("","file.zip");
			$new_dzip = new dZip($filename,TRUE);
			foreach($file['name'] as $value) {
				$new_dzip->addFile($value,$value);
			}
			$new_dzip->save($coded_array);
			$filecontent = file_get_contents($filename);
			$filesize = strlen($filecontent);
			unlink($filename);
			if ($filecontent) {
				// set the header and display
				$header_name = "Content-Disposition: attachment; filename=\"".$lang."-".str_replace(".","_",$cfg['version']."-".$language['languageeditor'])."_ts.zip"."\"";
				header($header_name);
				header("Content-Type: application/octet-stream");
				header("Content-Length: ".$filesize);
				header("Pragma: no-cache");
				header("Expires: 0");
				echo $filecontent;
			}
		} else {
			// display message
			xml_generator("languageeditor","error","e16","",$cfg);
		}
	} else {
		// display error
		xml_generator("languageeditor","error",$error,"",$cfg);
	}
}
?>