<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Online language translator
* @package TenderSystem
* @subpackage language
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type 
$fields_request = array (
	'action'	=> array()	
);
get_request($fields_request,$action,$error,$cfg);
if(!$cfg['languageeditor']['enable']) {
	// Not Enabled
	xml_generator("languageeditor","error","e44","",$cfg);
} elseif(!$cfg['languageeditor']['online']['translation']['enable']) {
	// Not Enabled
	xml_generator("languageeditor","error","e45","",$cfg);
} elseif(!$_SESSION['ts_id']) {
	// No Session
	xml_generator("loader","error","e17","",$cfg);
} elseif ($action['action']) {
	if($cfg['api']['connection'] == "module") {
		// field request errors and type 
		$fields_request = array (
			'missing'		=> array(),
			'translate'		=> array("e24"),
			'translator'	=> array("e37")
		);
		$info['reflang'] = "en";
		if(get_request($fields_request,$info,$error,$cfg)) {
			// go through api langauge files
			$files = examinedir("application/include/modules");
			foreach($files as $value) {
				if(strpos($value,"language/".$info['reflang']."/") && strpos($value,".php")) {
					$start = time();
					if(translate_php($value,$info['reflang'],$info['translate'],$info['translator'],$info['missing'])) {
						$params['created']++;	
					}
					$module = str_replace(array("application/include/modules/","/language/".$info['reflang']),"",dirname($value));
					$params['modules'][$module]['name'] = $module;
					$params['modules'][$module]['time']+= time() - $start;
					// allow to follow progress
					// trigger_error(sprintf('Done Translating with %s', $value), E_USER_WARNING);
				}
				
			}
			// go through gui langauge files
			$files = examinedir("modules");
			foreach($files as $value) {
				if(strpos($value,"language/".$info['reflang']."/default.xml")) {
					$start = time();
					// default files
					if(translate_default($value,$info['reflang'],$info['translate'],$info['translator'],$info['missing'])) {
						$params['created']++;	
					}
					$module = str_replace(array("modules/","/language/".$info['reflang']),"",dirname($value));
					$params['modules'][$module]['name'] = $module;
					$params['modules'][$module]['time']+= time() - $start;
					// allow to follow progress
					// trigger_error(sprintf('Done Translating with %s', $value), E_USER_WARNING);
				} elseif(strpos($value,"language/".$info['reflang']."/error.xml")) {			
					$start = time();
					// error files
					if(translate_error($value,$info['reflang'],$info['translate'],$info['translator'],$info['missing'])) {
						$params['created']++;	
					}
					$module = str_replace(array("modules/","/language/".$info['reflang']),"",dirname($value));
					$params['modules'][$module]['name'] = $module;
					$params['modules'][$module]['time']+= time() - $start;
					// allow to follow progress
					// trigger_error(sprintf('Done Translating with %s', $value), E_USER_WARNING);
				} elseif(strpos($value,"generic/language/".$info['reflang']."/country.xml")) {	
					$start = time();
					// country file
					if(translate_country($value,$info['reflang'],$info['translate'],$info['translator'],$info['missing'])) {
						$params['created']++;	
					}
					$module = str_replace(array("modules/","/language/".$info['reflang']),"",dirname($value));
					$params['modules'][$module]['name'] = $module;
					$params['modules'][$module]['time']+= time() - $start;
					// allow to follow progress
					// trigger_error(sprintf('Done Translating with %s', $value), E_USER_WARNING);
				} elseif(strpos($value,"generic/language/".$info['reflang']."/language.xml")) {			
					$start = time();
					// country file
					if(translate_language($value,$info['reflang'],$info['translate'],$info['translator'],$info['missing'])) {
						$params['created']++;	
					}
					$module = str_replace(array("modules/","/language/".$info['reflang']),"",dirname($value));
					$params['modules'][$module]['name'] = $module;
					$params['modules'][$module]['time']+= time() - $start;
					// allow to follow progress
					// trigger_error(sprintf('Done Translating with %s', $value), E_USER_WARNING);
				} elseif(strpos($value,"generic/language/".$info['reflang']."/calender.xml")) {
					$start = time();
					// default files
					if(translate_default($value,$info['reflang'],$info['translate'],$info['translator'],$info['missing'])) {
						$params['created']++;	
					}
					$module = str_replace(array("modules/","/language/".$info['reflang']),"",dirname($value));
					$params['modules'][$module]['name'] = $module;
					$params['modules'][$module]['time']+= time() - $start;
					// allow to follow progress
					// trigger_error(sprintf('Done Translating with %s', $value), E_USER_WARNING);
				}
			}			
			// error
			xml_generator("languageeditor","online_translation",$errors,$params,$cfg);
		} else {
			// error 
			xml_generator("languageeditor","error",$error,$params,$cfg);
		}
	} else {
		// display error message
		xml_generator("languageeditor","error","e16",$params,$cfg);
	}
} else {
	if($cfg['api']['connection'] == "module") {
		// look for available languages
		//$params['language'] = get_languages();
		$params['language'][0] = "en";
		$params['google'] = google_language();
		// display message
		xml_generator("languageeditor","online_translation","",$params,$cfg);
	} else {
		// display error message
		xml_generator("languageeditor","error","e16",$params,$cfg);
	}
}
?>