<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Remove language pack
* @package TenderSystem
* @subpackage language
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

if(!$cfg['languageeditor']['enable']) {
	// Not Enabled
	xml_generator("languageeditor","error","e44","",$cfg);
} elseif(!$_SESSION['ts_id']) {
	// No Session
	xml_generator("languageeditor","error","e17","",$cfg);
} else {
	// field request errors and type 
	$fields_request = array (
		'lang'			=> array("e26",	REQUEST_LANG,	FORMAT_NONE,	"e28")
	);
	if(get_request($fields_request,$info,$error,$cfg)) {
		if($cfg['api']['connection'] == "module") {
			$files = array_merge(examinedir("application/include/modules",TRUE),examinedir("modules",TRUE));
			foreach($files as $value) {
				if(strpos($value,"/language/".$info['lang']) && is_dir($value)) {
					$remove['name'] = $value;
					if(remove($value)) {
						$remove['status'] = "1";
					} else {
						$remove['status'] = "0";
					}
					$params['remove'][] = $remove;
					
				}
			}
			// display message
			xml_generator("languageeditor","remove","",$params,$cfg);
		} else {
			// display message
			xml_generator("languageeditor","error","e16","",$cfg);
		}
	} else {
		// display error
		xml_generator("languageeditor","error",$error,"",$cfg);
	}
}
?>