<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../generic/templates/languages.xsl"/>
<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/create"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/create"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'languageeditor'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report" >
					<input type="hidden" name="module" value="languageeditor"/>
					<input type="hidden" name="function" value="create"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF" id="sitediv">
						<xsl:if test="created='1'">
						<xsl:variable name="createdlang" select="lang"/>
							<tr>
								<td class="t1" colspan="2">
									<xsl:value-of select="$lng/createdlanguage"/>
									<br/><br/>
								</td>
							</tr>
							<tr>
								<td class="e" colspan="2">
									<a href="./main.php?module=languageeditor&amp;function=edit&amp;lang={lang}&amp;reflang={reflang}">
									<xsl:value-of select="$lng/clicklanguage"/>
									</a>
									<br/><br/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="isocodes">
							<tr>
								<td class="t1">
									<xsl:value-of select="$lng/lang"/>
								</td>
								<td class="t2">
									<xsl:call-template name="languages">
										<xsl:with-param name="selectname" select="'select'"/>
										<xsl:with-param name="onchange" select="'select_change()'"/>
									</xsl:call-template>
								</td>
							</tr>
							<tr>
								<td class="t1">
								</td>
								<td class="t2">
									<input type="radio" name="quick" onchange="change('es')"/>
									<xsl:call-template name="language_value"><xsl:with-param name="iso" select="'es'"/></xsl:call-template>
									<input type="radio" name="quick" onchange="change('ar')"/>
									<xsl:call-template name="language_value"><xsl:with-param name="iso" select="'ar'"/></xsl:call-template>
									<input type="radio" name="quick" onchange="change('bn')"/>
									<xsl:call-template name="language_value"><xsl:with-param name="iso" select="'bn'"/></xsl:call-template>
									<input type="radio" name="quick" onchange="change('hi')"/>
									<xsl:call-template name="language_value"><xsl:with-param name="iso" select="'hi'"/></xsl:call-template>
									<input type="radio" name="quick" onchange="change('pt')"/>
									<xsl:call-template name="language_value"><xsl:with-param name="iso" select="'pt'"/></xsl:call-template>
								</td>
							</tr>
							<tr>
								<td class="t1">
								</td>
								<td class="t2">
									<input type="radio" name="quick" onchange="change('ru')"/>
									<xsl:call-template name="language_value"><xsl:with-param name="iso" select="'ru'"/></xsl:call-template>
									<input type="radio" name="quick" onchange="change('ja')"/>
									<xsl:call-template name="language_value"><xsl:with-param name="iso" select="'ja'"/></xsl:call-template>
									<input type="radio" name="quick" onchange="change('de')"/>
									<xsl:call-template name="language_value"><xsl:with-param name="iso" select="'de'"/></xsl:call-template>
									<input type="radio" name="quick" onchange="change('ms')"/>
									<xsl:call-template name="language_value"><xsl:with-param name="iso" select="'ms'"/></xsl:call-template>
									<input type="radio" name="quick" onchange="change('fr')"/>
									<xsl:call-template name="language_value"><xsl:with-param name="iso" select="'fr'"/></xsl:call-template>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/isocode"/>
							</td>
							<td class="t2">
								<input type="text" name="name" size="12" class="t2"/>
							</td>
						</tr>
						<tr>
							<td class="t1"></td>
							<td class="t1" align="left">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submit"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
		</div>
	</div>
	<script type="text/javascript">
		function change(name) {
			document.report.name.value = name;
		}

		function select_change() {
			document.report.name.value = document.report.select.value;
		}
	</script>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
