<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../generic/templates/languages.xsl"/>
<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/edit"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/edit"/><xsl:value-of select="' '"/>
			<xsl:call-template name="language_value">
				<xsl:with-param name="iso" select="lang"/>
			</xsl:call-template>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'languageeditor'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report" >
					<input type="hidden" name="module" value="languageeditor"/>
					<input type="hidden" name="function" value="edit"/>
					<input type="hidden" name="lang" value="{lang}"/>
					<input type="hidden" name="reflang" value="{reflang}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF" id="sitediv">
						<xsl:if test="updated='1'">
							<tr>
								<td class="t1" colspan="4">
									<xsl:value-of select="$lng/updated"/>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td class="h t1" colspan="4">
								<xsl:value-of select="$lng/modulelanguage"/>
							</td>
						</tr>
						<xsl:for-each select="guimodule[position() mod 4 = 1]">
							<tr>
								<xsl:for-each select=".|following-sibling::guimodule[position() &lt; 4]">
									<xsl:variable name="xmlfile" select="."/>
									<td>
										<xsl:choose>
											<xsl:when test="position()=1">
												<xsl:attribute name="class">h2b t2</xsl:attribute>
											</xsl:when>
											<xsl:otherwise>
												<xsl:attribute name="class">h2c t2</xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=languageeditor&amp;function=editguimodule&amp;lang=',../lang,'&amp;languagemodule=',.,'&amp;reflang=',../reflang)"/>
											</xsl:attribute>
											<xsl:value-of select="."/>
											<xsl:for-each select="../inactiveguimodule">
												<xsl:if test="$xmlfile=.">
													(<xsl:value-of select="$lng/inactive"/>)
												</xsl:if>
											</xsl:for-each>
										</a>
									</td>
									<xsl:if test="position() = last() and last() != 4">
										<td class="h2c">
											<xsl:attribute name="colspan"><xsl:value-of select="5 - position()"/></xsl:attribute>
										</td>
									</xsl:if>
								</xsl:for-each>
							</tr>
						</xsl:for-each>
						<tr><td><br/></td></tr>
						<tr>
							<td class="h t1" colspan="4">
								<xsl:value-of select="$lng/appmodulelanguage"/>
							</td>
						</tr>
						<xsl:for-each select="appmodule[position() mod 4 = 1]">
							<tr>
								<xsl:for-each select=".|following-sibling::appmodule[position() &lt; 4]">
									<xsl:variable name="xmlfile" select="."/>
									<td>
										<xsl:choose>
											<xsl:when test="position()=1">
												<xsl:attribute name="class">h2b t2</xsl:attribute>
											</xsl:when>
											<xsl:otherwise>
												<xsl:attribute name="class">h2c t2</xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=languageeditor&amp;function=editappmodule&amp;lang=',../lang,'&amp;languagemodule=',.,'&amp;reflang=',../reflang)"/>
											</xsl:attribute>
											<xsl:value-of select="."/>
											<xsl:for-each select="../inactiveappmodule">
												<xsl:if test="$xmlfile=.">
													(<xsl:value-of select="$lng/inactive"/>)
												</xsl:if>
											</xsl:for-each>
										</a>
									</td>
									<xsl:if test="position() = last() and last() != 4">
										<td class="h2c">
											<xsl:attribute name="colspan"><xsl:value-of select="5 - position()"/></xsl:attribute>
										</td>
									</xsl:if>
								</xsl:for-each>
							</tr>
						</xsl:for-each>
						<tr><td><br/></td></tr>
						<tr>
							<td class="h t1" colspan="4">
								<xsl:value-of select="$lng/other"/>
							</td>
						</tr>
						<tr>
							<td class="h2b t1">
								<a>
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=languageeditor&amp;function=editcalendar&amp;lang=',lang,'&amp;reflang=',reflang)"/>
									</xsl:attribute>
									<xsl:value-of select="$lng/calendar"/>
									<xsl:if test="nocalendar='1'">
										(<xsl:value-of select="$lng/inactive"/>)
									</xsl:if>
								</a>
							</td>
							<td class="h2c t1">
								<a>
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=languageeditor&amp;function=editcountries&amp;lang=',lang,'&amp;reflang=',reflang)"/>
									</xsl:attribute>
									<xsl:value-of select="$lng/countries"/>
									<xsl:if test="nocountry='1'">
										(<xsl:value-of select="$lng/inactive"/>)
									</xsl:if>
								</a>
							</td>
							<td class="h2c t1">
								<a>
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=languageeditor&amp;function=editlanguages&amp;lang=',lang,'&amp;reflang=',reflang)"/>
									</xsl:attribute>
									<xsl:value-of select="$lng/languages"/>
									<xsl:if test="nolanguage='1'">
										(<xsl:value-of select="$lng/inactive"/>)
									</xsl:if>
								</a>
							</td>
							<td class="h2c t1">
								<a>
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=languageeditor&amp;function=massreplace&amp;lang=',lang,'&amp;reflang=',reflang)"/>
									</xsl:attribute>
									<xsl:value-of select="$lng/massreplace"/>
								</a>
							</td>
						</tr>
					</table>
				</form>
			</div>
		</div>
		<div id="right">
			<div id="right_header">
				<xsl:value-of select="$lng/editlanguagemodules"/>
			</div>
			<div id="right_content">
				<xsl:for-each select="$lng/editinst">
					<xsl:value-of select="."/><br/>
				</xsl:for-each>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function enableupload(myModule,myFunction) {
			document.report.upload.disabled = 0;
		}
	</script>
</body>
</html>

</xsl:template>



</xsl:stylesheet>
