<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/editmodulexml"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/editmodulexml"/><xsl:value-of select="' '"/><xsl:value-of select="languagemodule"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'languageeditor'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report" >
					<input type="hidden" name="module" value="languageeditor"/>
					<input type="hidden" name="function" value="editappmodule"/>
					<input type="hidden" name="lang" value="{lang}"/>
					<input type="hidden" name="reflang" value="{reflang}"/>
					<input type="hidden" name="languagemodule" value="{languagemodule}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF" id="sitediv">
						<xsl:if test="appmodulefile">
							<xsl:for-each select="appmodulefile">
								<tr>
									<td class="h t1" colspan="3">
										<xsl:value-of select="name"/>
									</td>
								</tr>
								<tr>
									<td class="h1b t1">
										<xsl:value-of select="$lng/name"/>
									</td>
									<td class="h1c t1">
										<xsl:value-of select="$lng/reference"/>
									</td>
									<td class="h1c t1">
										<xsl:value-of select="$lng/value"/>
									</td>
								</tr>
								<xsl:variable name="file" select="name"/>
								<xsl:for-each select="lang">
									<tr>
										<td class="h2b t1">
											<xsl:value-of select="name"/>
										</td>
										<td class="h2c t2">
											<textarea class="readonly t2" readonly="" cols="30">
												<xsl:value-of select="refvalue"/>
											</textarea>
										</td>
										<td class="h2c t2">
											<textarea class="t2" cols="30">
												<xsl:attribute name="name">values[<xsl:value-of select="$file"/>][<xsl:value-of select="name"/>]</xsl:attribute>
												<xsl:choose>
													<xsl:when test="value!=''">
														<xsl:value-of select="value"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="'|'"/><xsl:value-of select="refvalue"/><xsl:value-of select="'|'"/>
													</xsl:otherwise>
												</xsl:choose>
											</textarea>
										</td>
									</tr>
								</xsl:for-each>
								<xsl:for-each select="lang_array">
									<tr>
										<td class="h1 t1" colspan="3">
											<xsl:value-of select="name"/>
										</td>
									</tr>
									<xsl:variable name="name" select="name"/>
									<xsl:for-each select="lang">
										<tr>
											<td class="h2b t1">
												<xsl:value-of select="name"/>
											</td>
											<td class="h2c t2">
												<textarea class="readonly t2" readonly="" cols="30">
													<xsl:value-of select="refvalue"/>
												</textarea>
											</td>
											<td class="h2c t2">
												<textarea class="t2" cols="30">
													<xsl:attribute name="name">values[<xsl:value-of select="$file"/>][<xsl:value-of select="$name"/>][<xsl:value-of select="name"/>]</xsl:attribute>
													<xsl:choose>
														<xsl:when test="value!=''">
															<xsl:value-of select="value"/>
														</xsl:when>
														<xsl:when test="refvalue!=''">
															<xsl:value-of select="'|'"/><xsl:value-of select="refvalue"/><xsl:value-of select="'|'"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="refvalue"/>
														</xsl:otherwise>
													</xsl:choose>
												</textarea>
											</td>
										</tr>
									</xsl:for-each>
								</xsl:for-each>
								<tr>
									<td><br/></td>
								</tr>
							</xsl:for-each>
						</xsl:if>
						<tr>
							<td align="right" colspan="3">
								<input type="submit" name="update" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submit"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		<xsl:if test="created='1'">
			parent.left.location.reload();
		</xsl:if>
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
