<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../generic/templates/languages.xsl"/>
<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/importlanguage"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'languageeditor'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="languageeditor"/>
					<input type="hidden" name="function" value="import"/>
					<input type="hidden" name="file" value="{language/file}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
						</tr>
					<xsl:if test="updated">
						<tr>
							<td align="left" class="t1" colspan="4">
								<xsl:value-of select="$lng/sucessextracted"/><xsl:value-of select="' : '"/><xsl:value-of select="extracted"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/files"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="language">
						<tr>
							<td align="left" class="h t1" colspan="4">
								<xsl:value-of select="$lng/languageinfo"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/lang"/>
							</td>
							<td align="left" class="t2">
								<xsl:variable name="code" select="language/lang"/>
								<xsl:call-template name="language_value">
									<xsl:with-param name="iso" select="$code"/>
								</xsl:call-template>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/translator"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="language/translator"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/license"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="language/license"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/copyright"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="language/copyright"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/file_count"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="language/file_count"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/date"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="language/date"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/exportversion"/>
							</td>
							<td align="left" class="e">
								<xsl:choose>
									<xsl:when test="language/version">
										<xsl:if test="language/version=footer/version">
											<xsl:attribute name="class">t2</xsl:attribute>
										</xsl:if>
										<xsl:value-of select="language/version"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/unknown"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/languageeditorversion"/>
							</td>
							<td align="left" class="t2">
								<xsl:choose>
									<xsl:when test="language/languageeditor">
										<xsl:value-of select="language/languageeditor"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/unknown"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
					<xsl:if test="exists">
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/notice"/>
							</td>
							<td align="left" class="e" colspan="3">
								<xsl:value-of select="$lng/alreadyexists"/>
							</td>
						</tr>
					</xsl:if>
						<tr>
							<td align="right" class="t1" colspan="4">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/import"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
