<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/massreplace"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'languageeditor'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="languageeditor"/>
					<input type="hidden" name="function" value="massreplace"/>
					<input type="hidden" name="lang" value="{lang}"/>
					<input type="hidden" name="reflang" value="{reflang}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
						</tr>
					<xsl:if test="updated='1'">
						<tr>
							<td align="left" class="t1" colspan="4">
								<xsl:value-of select="$lng/updatedtags"/><xsl:value-of select="updatedtags"/>
							</td>
						</tr>
					</xsl:if>
						<tr>
							<td align="left" class="h t1" colspan="4">
								<xsl:value-of select="$lng/tagreplace"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/tag"/>
							</td>
							<td align="left" class="t2">
								<input name="tag" class="t2"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/content"/>
							</td>
							<td align="left" class="t2">
								<input name="content" class="t2"/>
							</td>
						</tr>
						<tr>
							<td align="right" class="t2" colspan="4">
								<input type="submit" name="tagreplace" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submit"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
						<tr>
							<td align="left" class="h t1" colspan="4">
								<xsl:value-of select="$lng/phrasereplace"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/phrase"/>
							</td>
							<td align="left" class="t2">
								<input name="phrase" class="t2"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/newphrase"/>
							</td>
							<td align="left" class="t2">
								<input name="newphrase" class="t2"/>
							</td>
						</tr>
						<tr>
							<td align="right" class="t2" colspan="4">
								<input type="submit" name="phrasereplace" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submit"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
						<tr>
							<td><br/></td>
						</tr>
						<tr>
							<td align="left" class="h t1" colspan="4">
								<xsl:value-of select="$lng/taginfo"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="h1b t1" colspan="2">
								<xsl:value-of select="$lng/tag"/>
							</td>
							<td align="left" class="h1c t1">
								<xsl:value-of select="$lng/behave"/>
							</td>
							<td align="left" class="h1c t1">
								<xsl:value-of select="$lng/mostapp"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/content"/>
							</td>
						</tr>
					<xsl:for-each select="tag">
						<tr>
							<td align="left" class="h2b t1" colspan="2">
								<xsl:value-of select="name"/>
							</td>
							<td align="left" class="h2c t1">
								<xsl:value-of select="behave"/><xsl:value-of select="'%'"/>
							</td>
							<td align="left" class="h2c t1">
								<xsl:value-of select="most"/>
							</td>
						</tr>
					</xsl:for-each>
						<tr>
							<td><br/></td>
						</tr>
						<tr>
							<td align="left" class="h t1" colspan="4">
								<xsl:value-of select="$lng/contentinfo"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="h1b t1" colspan="2">
								<xsl:value-of select="$lng/content"/>
							</td>
							<td align="left" class="h1c t1">
								<xsl:value-of select="$lng/behave"/>
							</td>
							<td align="left" class="h1c t1">
								<xsl:value-of select="$lng/mostapp"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/tag"/>
							</td>
						</tr>
					<xsl:for-each select="content">
						<tr>
							<td align="left" class="h2b t1" colspan="2">
								<xsl:value-of select="name"/>
							</td>
							<td align="left" class="h2c t1">
								<xsl:value-of select="behave"/><xsl:value-of select="'%'"/>
							</td>
							<td align="left" class="h2c t1">
								<xsl:value-of select="most"/>
							</td>
						</tr>
					</xsl:for-each>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
