<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../generic/templates/languages.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/create"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/onlinetranslate"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'languageeditor'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report" >
					<input type="hidden" name="module" value="languageeditor"/>
					<input type="hidden" name="function" value="online_translation"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF" id="sitediv">
				<xsl:if test="created &gt; '0'">
					<tr>
						<td class="h t1">
							<xsl:value-of select="$lng/modulename"/>
						</td>
						<td class="ha t1">
							<xsl:value-of select="$lng/translationtime"/>
						</td>
					</tr>
					<xsl:for-each select="modules">
					<tr>
						<td class="t2">
							<xsl:value-of select="name"/>
						</td>
						<td class="t2" align="right">
							<xsl:value-of select="time"/>
						</td>
					</tr>
					</xsl:for-each>
				</xsl:if>
					<xsl:if test="language">
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/warning"/>
							</td>
							<td class="e t2" colspan="3">
								<xsl:value-of select="$lng/translationlong"/>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/translator"/>
							</td>
							<td class="t2">
								<select name="translator" class="t2" onchange="select_change()">
									<option value="google_translate"><xsl:value-of select="$lng/google"/></option>
									<!--<option value="babelfish_translate"><xsl:value-of select="$lng/babelfish"/></option>-->
								</select>
							</td>
							<td class="t1" align="center"><xsl:value-of select="$lng/missing"/></td>
							<td class="t2">
								<input name="missing" type="checkbox" class="t2"/>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/lang"/>
							</td>
							<td class="t2">
								<select name="current" class="t2" disabled="yes">
									<xsl:for-each select="language">
										<xsl:variable name="code" select="."/>
										<option value="{$code}">
											<xsl:call-template name="language_value">
												<xsl:with-param name="iso" select="$code"/>
											</xsl:call-template>
										</option>
									</xsl:for-each>
								</select>
							</td>
							<td class="t1" align="center"><xsl:value-of select="$lng/translateto"/></td>
							<td class="t2">
								<select name="translate" class="t2"/>
							</td>
						</tr>
						<tr>
							<td class="t1"></td>
							<td class="t1" align="right" colspan="4">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submit"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<script type="text/javascript">
		function select_change() {
			var translatorValue = document.report.translator.value;
		
			var currentIndex = document.report.current.selectedIndex;
			var currentValue = document.report.current.value;
			var translateSelect = document.report.translate;
			var translateOptions = translateSelect.options;
			var counter = 0;
			translateSelect.length = 0;
			
			if(translatorValue == "google_translate") {
			<xsl:for-each select="google">
				if (currentValue == "<xsl:value-of select="./current"/>") {
					translateOptions[counter++] = new Option("<xsl:call-template name="language_value"><xsl:with-param name="iso" select="./new"/></xsl:call-template>","<xsl:value-of select="./new"/>");
				}
			</xsl:for-each>
		    }
			if(translatorValue == "babelfish_translate") {
			<xsl:for-each select="babelfish">
				if (currentValue == "<xsl:value-of select="./current"/>") {
					translateOptions[counter++] = new Option("<xsl:call-template name="language_value"><xsl:with-param name="iso" select="./new"/></xsl:call-template>","<xsl:value-of select="./new"/>");
				}
			</xsl:for-each>
		    }
			if(counter == 0) {
				translateSelect.disabled = 1;
			} else {
				translateSelect.disabled = 0;
			}
		}
		
		select_change();
	</script>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
