<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../generic/templates/languages.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/repairlanguage"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'languageeditor'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="languageeditor"/>
					<input type="hidden" name="function" value="edit"/>
					<input type="hidden" name="lang" value="{lang}"/>
					<input type="hidden" name="reflang" value="{reflang}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="file">
						<tr>
							<td align="left" class="h t1" colspan="2">
								<xsl:value-of select="$lng/repaircheck"/>
							</td>
						</tr>
					<xsl:for-each select="file">
						<tr>
							<td align="left" class="t2">
								<xsl:value-of select="name"/>
							</td>
							<td align="left" class="t2">
							<xsl:choose>
								<xsl:when test="status='0'">
									<xsl:value-of select="$lng/good"/>
								</xsl:when>
								<xsl:when test="status='cantwrite'">
									<xsl:attribute name="class">e</xsl:attribute>
									<xsl:value-of select="$lng/nowriteaccess"/>
								</xsl:when>
								<xsl:when test="status='corrupted'">
									<xsl:attribute name="class">e</xsl:attribute>
									<xsl:value-of select="$lng/corrupted"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">t1</xsl:attribute>
									<xsl:value-of select="$lng/addedtags"/><xsl:value-of select="' '"/><xsl:value-of select="status"/>
								</xsl:otherwise>
							</xsl:choose>
							</td>
						</tr>
					</xsl:for-each>
						</xsl:if>
						<tr>
							<td align="right" colspan="3">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/edit"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
