<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../generic/templates/languages.xsl"/>
<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/languageeditor"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'languageeditor'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="languageeditor"/>
					<input type="hidden" name="function" value="edit"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
					<xsl:if test="not(notwritable)">
						<xsl:if test="user/classification!='-1'">
							<tr>
								<td align="left" class="t1">
									<a href="main.php?module=languageeditor&amp;function=create" target="main">
										<xsl:value-of select="$lng/create"/>
									</a>
								</td>
							</tr>
							<tr>
								<td align="left" class="t1">
									<a href="main.php?module=languageeditor&amp;function=online_translation" target="main">
										<xsl:value-of select="$lng/onlinetranslate"/>
									</a>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td><br/></td>
						</tr>
					<xsl:if test="language">
						<xsl:if test="user/classification!='-1'">
						<tr>
							<td align="left" class="h t1" colspan="2">
								<xsl:value-of select="$lng/edit"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/lang"/>
							</td>
							<td align="left" class="t2">
								<select name="lang" class="t2">
									<option value=""><xsl:value-of select="$lng/select"/></option>
									<xsl:for-each select="language">
										<option value="{.}">
											<xsl:call-template name="language_value">
												<xsl:with-param name="iso" select="."/>
											</xsl:call-template>
										</option>
									</xsl:for-each>
								</select>
								<input type="submit" name="export" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/export"/>
									</xsl:attribute>
								</input>
								<input type="submit" name="remove" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/remove"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/reflang"/>
							</td>
							<td align="left" class="t2">
								<select name="reflang" class="t2">
									<xsl:for-each select="language">
										<option value="{.}">
											<xsl:if test=".='en'"><xsl:attribute name="selected"/></xsl:if>
											<xsl:call-template name="language_value">
												<xsl:with-param name="iso" select="."/>
											</xsl:call-template>
										</option>
									</xsl:for-each>
								</select>
							</td>
						</tr>
						<tr>
							<td align="right" class="t1" colspan="2">
								<input type="submit" name="repair" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/repaircheck"/>
									</xsl:attribute>
								</input>
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/edit"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
						</xsl:if>
					</xsl:if>
						<tr>
							<td align="left" class="h t1" colspan="2">
								<xsl:value-of select="$lng/import"/>
							</td>
						</tr>
				<xsl:choose>
					<xsl:when test="connection='module'">
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/file"/>
							</td>
							<td align="left" class="t2">
								<input type="file" name="file" class="t2"/>
								<input type="submit" name="import" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/import"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</xsl:when>
					<xsl:when test="connection!='module'">
						<tr>
							<td align="left" class="t1" colspan="2">
								<xsl:value-of select="$lng/connectionmustbemodule"/>
							</td>
						</tr>
					</xsl:when>
				</xsl:choose>
					</xsl:if>
					<xsl:if test="notwritable">
						<tr>
							<td align="left" class="h t1" colspan="2">
								<xsl:value-of select="$lng/followingnotwritable"/>
							</td>
						</tr>
						<xsl:for-each select="notwritable">
							<tr>
								<td align="left" class="t2" colspan="2">
									<xsl:value-of select="."/>
								</td>
							</tr>
						</xsl:for-each>
					</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
