<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Check if version upgradable
* @package TenderSystem
* @subpackage loader
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// determine if it is an administrator with level 2 permission
if (($_SESSION['ts_classification'] == "3" && $_SESSION['ts_permission'] == "2") || $_SESSION['ts_classification'] == "-1") {
	if(!$cfg['loader']['enable']) {
		// Module Loader disabled
		xml_generator("loader","error","e16",$params,$cfg);
	} elseif(!$cfg['loader']['upgrade']['enable']) {
		// Upgrade disabled
		xml_generator("loader","error","e20",$params,$cfg);
	} else {
		$fields_request = array (
			'upgrade_type'		=> array("e21")
		);
		if(!get_request($fields_request,$info,$errors,$cfg)) {
			xml_generator("loader","error",$errors,$params,$cfg);
		}
		if($info['upgrade_type']=="module" || $info['upgrade_type']=="all") {
			// go through all modules default.xml file
			$directories = list_directories("modules");
			// loop through all the files (modules)
			foreach($directories as $value) {
				$loader = array();
				include($value."/_loader.php");
				if(!empty($loader)) {
					if($loader['upgrade_url']) {
						$url[] = $loader['upgrade_url'];
					}
				}
			}
		}
		if($info['upgrade_type']=="stable" || $info['upgrade_type']=="all") {
			$url[] = $cfg['loader']['upgrade']['stable'];
		}
		if($info['upgrade_type']=="development" || $info['upgrade_type']=="all") {
			$url[] = $cfg['loader']['upgrade']['development'];
		}
		if($info['upgrade_type']=="extra" || $info['upgrade_type']=="all") {
			$url[] = $cfg['loader']['upgrade']['extra'];
		}
		if($info['upgrade_type']=="rollback") {
			$url[] = "http://".$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME']."?module=loader&function=rollback";
		}
		$_SESSION['upgrade_type'] = $info['upgrade_type'];
		$loader = array();
		include(getcwd()."/modules/loader/_loader.php");
		// remove duplicates
		$url = array_unique($url);
		// go through all urls
		foreach($url as $value) {
			$xml = get_web_contents($value);
			$xml_info = get_xml_info_content($xml['web_contents']);
			if($xml_info) {
				foreach($xml_info['xml_index']['UPGRADE'] as $index) {
					$i = $index;
					$xml_tag = $xml_info['xml_array'][$i++];
					if($xml_tag['type'] == "open" && $xml_tag['level'] == "2") {
						// set location
						$module_info['location'] = $xml_tag['attributes']['LOCATION'];
						while($xml_tag['type'] != "close" || $xml_tag['level'] != "2" || $xml_tag['tag'] != "UPGRADE") {
							$xml_tag = $xml_info['xml_array'][$i++];
							if($xml_tag['type'] == "open" && $xml_tag['level'] == "3" && $xml_tag['tag'] == "MODULE") {
								// Module Information
								while($xml_tag['type'] != "close" || $xml_tag['level'] != "3" || $xml_tag['tag'] != "MODULE") {
									$xml_tag = $xml_info['xml_array'][$i++];
									if($xml_tag['type'] == "complete") {
										$module_info['module'][0][strtolower($xml_tag['tag'])] = $xml_tag['value'];
									}
								}
							}
							if($xml_tag['type'] == "open" && $xml_tag['level'] == "3" && $xml_tag['tag'] == "VERSION") {
								// TenderSystem Version Information
								while($xml_tag['type'] != "close" || $xml_tag['level'] != "3" || $xml_tag['tag'] != "VERSION") {
									$xml_tag = $xml_info['xml_array'][$i++];
									if($xml_tag['type'] == "complete") {
										$module_info['version'][0][strtolower($xml_tag['tag'])] = $xml_tag['value'];
									}
								}
							}
							if($xml_tag['type'] == "open" && $xml_tag['level'] == "3" && $xml_tag['tag'] == "LOADERVERSION") {
								// Loader Module Version Information
								while($xml_tag['type'] != "close" || $xml_tag['level'] != "3" || $xml_tag['tag'] != "LOADERVERSION") {
									$xml_tag = $xml_info['xml_array'][$i++];
									if($xml_tag['type'] == "complete") {
										$module_info['loaderversion'][0][strtolower($xml_tag['tag'])] = $xml_tag['value'];
									}
								}
							}
							if($xml_tag['type'] == "open" && $xml_tag['level'] == "3" && $xml_tag['tag'] == "NEED") {
								// Other Module Version Information
								while($xml_tag['type'] != "close" || $xml_tag['level'] != "3" || $xml_tag['tag'] != "NEED") {
									$xml_tag = $xml_info['xml_array'][$i++];
									if($xml_tag['type'] == "complete") {
										$module_info['need'][0][strtolower($xml_tag['tag'])] = $xml_tag['value'];
									}
								}
							}
							if($xml_tag['type'] == "open" && $xml_tag['level'] == "3" && $xml_tag['tag'] == "DOWNLOAD") {
								// Other Module Version Information
								while($xml_tag['type'] != "close" || $xml_tag['level'] != "3" || $xml_tag['tag'] != "DOWNLOAD") {
									$xml_tag = $xml_info['xml_array'][$i++];
									if($xml_tag['type'] == "complete") {
										$module_info['download'][0][strtolower($xml_tag['tag'])] = $xml_tag['value'];
									}
								}
							}
						}
						// check if upgrade
						$loader = array();
						$module_info['good'] = 1;
						if(file_exists($module_info['location']."/_loader.php")) {
							include($module_info['location']."/_loader.php");
						}
						if(empty($loader)) {
							$module_info['type'] = "new";	
						} elseif(version_compare($module_info['module'][0]['version'],$loader['module']['version'],">")) {
							$module_info['type'] = "upgrade";
						} else {
							$module_info['type'] = "downgrade";
							$module_info['good'] = 0;
						}
						$module_info['current'][0]['version'] = $loader['module']['version'];
						if(is_array($module_info['need'][0]) && $module_info['type'] != "downgrade") {
							// check if all requirements are met
							foreach($module_info['need'][0] as $module => $version) {
								$loader = array();
								if(file_exists("modules/".$module."/_loader.php")) {
									include("modules/".$module."/_loader.php");
								}
								if(empty($loader)) {
									continue;
								}
								if(version_compare($version,$loader['module']['version'],">")) {
									$module_info['type'] = "minrequire";
									$module_info['good'] = 0;
								}
							}
						}
						// check loader version
						$module_info['upgrade_url'] = htmlentities($value);
						$module_info['session_location'] = ++$session_location;
						$_SESSION['module_info'][$session_location] = $module_info;
						$params['module_info'][] = $module_info;
						unset($module_info);
					}
				}
			} else {
				$params['bad_link'] = $value;
			}
		}
		// send message to api
		xml_generator("loader","check_upgrade","",$params,$cfg);
	}
} else {
	// unauthorised
	$errors[] = "e15";
	// response
	xml_generator("generic","error",$errors,$params,$cfg);
}
?>