<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Export module
* @package TenderSystem
* @subpackage loader
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// determine if it is an administrator with level 2 permission
if (($_SESSION['ts_classification'] == "3" && $_SESSION['ts_permission'] == "2") || $_SESSION['ts_classification'] == "-1") {
	// field request errors and type 
	$fields_request = array (
		'action'	=> array(),
		'dir'		=> array()		
	);
	get_request($fields_request,$action,$error,$cfg);
	if(!$_SESSION['ts_id']) {
		// No Session
		xml_generator("loader","error","e1","",$cfg);
	} elseif(!$cfg['loader']['enable']) {
		// Module Loader disabled
		xml_generator("loader","error","e16",$params,$cfg);
	} elseif(!$cfg['loader']['export']['enable']) {
		// Export disabled
		xml_generator("loader","error","e17",$params,$cfg);
	} elseif($action['dir']) {
		if($cfg['api']['connection'] == "module") {
			$directory = $action['dir'];
			// go through all languages packs of module
			$file_path = $directory."/language";
			$params['modulelanguage'] = list_directories($file_path);
			$params['modulelanguage'] = str_replace($directory."/language/","",$params['modulelanguage']);
			$content = file_get_contents($directory."/language/".$_SESSION['ts_lang']."/default.xml");
			if($content) {
				$tmp['name'] = event_parser('<module_name>','</module_name>',$content);
				$tmp['description'] = wordwrap(event_parser('<module_description>','</module_description>',$content));
				if(file_exists($directory."/changes.txt")) {
					$tmp['changelog'] = wordwrap(file_get_contents($directory."/changes.txt"));
				}
			}
			include($directory."/_loader.php");
			foreach($loader['module'] as $key => $value) {
				$tmp[$key]	= $value;
			}
			$tmp['filename'] = $directory;
			$params['moduleinfo'][] = $tmp;
			$params['directory'] = $directory;
			xml_generator("loader","export","",$params,$cfg);
		} else {
			// must perform on module
			xml_generator("loader","error","e3","",$cfg);
		}
	} elseif($action['action']) {
		if($cfg['api']['connection'] == "module") {
			// field request errors and type 
			$fields_request = array (
				'directory'		=> array("e2"),
				'langinclude'	=> array()			
			);
			if(get_request($fields_request,$info,$error,$cfg)) {
				$directory = $info['directory'];
				$filename = tempnam("","file.zip");
				require(getcwd()."/modules/external/class/dunzip/dZip.inc.php");
				$info['moduleversion'] = do_export($filename,$directory,$info['langinclude'],$cfg);
				$filecontent = file_get_contents($filename);
				$filesize = strlen($filecontent);
				unlink($filename);
				if ($filecontent) {
					// set the header and display
					$header_name = "Content-Disposition: attachment; filename=\"".str_replace("modules/","",$directory)."_".str_replace(array("."," "),"_",$cfg['version']."-".$info['moduleversion']."")."_ts.zip"."\"";
					header($header_name);
					header("Content-Type: application/octet-stream");
					header("Content-Length: ".$filesize);
					header("Pragma: no-cache");
					header("Expires: 0");
					echo $filecontent;
				}		
			} else {
				// must perform on module
				xml_generator("loader","error",$error,"",$cfg);
			}
		} else {
			// must perform on module
			xml_generator("loader","error","e3","",$cfg);
		}
	} else {
		// missing module	
		xml_generator("loader","error","e2","",$cfg);
	}
} else {
	// unauthorised
	$errors[] = "e15";
	// response
	xml_generator("generic","error",$errors,$params,$cfg);
}
?>