<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Export data
* @package TenderSystem
* @subpackage loader
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// determine if it is an administrator with level 2 permission
if ($_SESSION['ts_classification'] == "3" && $_SESSION['ts_permission'] == "2") {
	// field request errors and type 
	$fields_request = array (
		'action'	=> array()	
	);
	get_request($fields_request,$action,$error,$cfg);
	if(!$_SESSION['ts_id']) {
		// No Session
		xml_generator("loader","error","e1","",$cfg);
	} elseif(!$cfg['loader']['enable']) {
		// Module Loader disabled
		xml_generator("loader","error","e16",$params,$cfg);
	} elseif($action['action']) {
		if($cfg['api']['connection'] == "module") {
			$files = examinedir("./modules");
			foreach($files as $value) {
				if(strpos($value,"/tables/") && strpos($value,".php")) {
					include($value);
				}
			}
			$tablename = array_keys($table);
			if($tablename) {
				$params['module'] = "loader";
				$params['function'] = "export_data";
				$params['tablename'] = $tablename;
				$cfg['api_request'] = TRUE;
				// send the message to app
				$xml = send_message($params,$cfg);
				$coded_data = base64_decode(event_parser('<coded_data>','</coded_data>',$xml));
				require(getcwd()."/modules/external/class/dunzip/dZip.inc.php");
				$filename = tempnam("","file.zip");
				$new_dzip = new dZip($filename,TRUE);
				$new_dzip->addFile(FALSE,"data",FALSE,$coded_data);
				$info['version'] = $cfg['version'];  
				$info['time'] = date("Y-m-d");
				$new_dzip->save(serialize($info));
				$filecontent = file_get_contents($filename);
				$filesize = strlen($filecontent);
				unlink($filename);
				if ($filecontent) {
					// set the header and display
					$header_name = "Content-Disposition: attachment; filename=\"datadump_".$info['time']."_ts.zip"."\"";
					header($header_name);
					header("Content-Type: application/octet-stream");
					header("Content-Length: ".$filesize);
					header("Pragma: no-cache");
					header("Expires: 0");
					echo $filecontent;
				}
			} else {
				// no tables to export
				xml_generator("loader","error","e8",$params,$cfg);
			}
		} else {
			// must perform on module
			xml_generator("loader","error","e3","",$cfg);
		}
	} else {
		if($cfg['api']['connection'] == "module") {
			xml_generator("loader","export_data","",$params,$cfg);
		} else {
			// must perform on module
			xml_generator("loader","error","e3","",$cfg);
		}
	}
} else {
	// unauthorised
	$errors[] = "e15";
	// response
	xml_generator("generic","error",$errors,$params,$cfg);
}
?>