<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Generic functions
* @package TenderSystem
* @subpackage loader
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
if (eregi("generic.php",$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

function get_sourceforge_links($body) {
   $pattern = "/(<a href=\\\")(.*)(use_mirror=)(.*)(\\\")([ ]*)(>)/";
   //End pattern building.
   preg_match_all ($pattern, $body, $matches);
   return (is_array($matches)) ? $matches:FALSE;
}

function get_redirect_link($body) {
   $pattern = "/(URL=)(.*)(\\\")([ ]*)(>)/";
   //End pattern building.
   preg_match_all ($pattern, $body, $matches);
   return (is_array($matches)) ? $matches:FALSE;
}

function do_export($filename,$directory,$lang_include,$cfg) {
	$new_dzip = new dZip($filename,TRUE);
	// get the api files
	if(is_dir("application/include/".$directory)) {
		$files = examinedir("application/include/".$directory);
		foreach($files as $value) {
			if (strpos($value,".svn") || strpos($value,"CVS")) {
				continue;
			} else {
				if(strpos($value,"/language/")) {
					foreach($lang_include as $lang_value) {
						if(strpos($value,"/".$lang_value."/")) {
							$new_dzip->addFile($value,$value);
						}
					}
				} else {
					$new_dzip->addFile($value,$value);
				}
			}
		}
	}
	// get the gui files
	$files = examinedir($directory);
	foreach($files as $value) {
		if (strpos($value,".svn") || strpos($value,"CVS")) {
			continue;
		} else {
			if(strpos($value,"/language/")) {
				foreach($lang_include as $lang_value) {
					if(strpos($value,"/".$lang_value."/")) {
						$new_dzip->addFile($value,$value);
					}
				}
			} else {
				$new_dzip->addFile($value,$value);
			}
		}
	}
	// set tendersystem version
	$info['version'] = $cfg['version'];
	// set what loader version
	$loader = array();
	include(getcwd()."/modules/loader/_loader.php");
	$info['loader'] = $loader['module']['version'];
	// set the requirements
	$loader = array();
	include($directory."/_loader.php");
	$info['requirements'] = $loader;
	$info['moduleversion'] = $loader['module']['version'];
	if(file_exists($directory."/changes.txt")) {
		$info['changelog'] = wordwrap(file_get_contents($directory."/changes.txt"));
	}
	// get current version of required modules
	foreach($loader['need'] as $key => $value) {
		$loader = array();
		include(getcwd()."/modules/".$key."/_loader.php");
		$info['module'][$key] = $loader['module']['version'];
	}
	$info['directory'] = $directory;
	$info['time'] = date("Y-m-d");
	$new_dzip->save(serialize($info));
	return $info['moduleversion'];
}

function do_upgrade($file,$directory,$cfg,$api_request=FALSE,$rollback=FALSE) {	
	// set module name
	$param['extractedname'] = $directory;
	// export to allow rollback
	if(!$rollback) {
		$filename = "rollback/".str_replace(array("/","\\","."),"_",$directory);
		$lang_include = array("en");
		do_export($filename.".zip",$directory,$lang_include,$cfg);
		// copy loader file to rollback aswell
		copy($directory."/_loader.php",$filename.".php");
		// check for config files
		$errors = array();
	}
	// backup config files
	if(file_exists($directory."/config.inc.php")) {
		// preserve old config
		if(!copy($directory."/config.inc.php",$directory."/config.old.php")) {
			// Cannot create copy of config file
			$errors[] = "e11";
		}	
	}
	if(file_exists("application/include/".$directory."/config.inc.php")) {
		// preserve old config
		if(!copy("application/include/".$directory."/config.inc.php","application/include/".$directory."/config.old.php")) {
			// Cannot create copy of config file
			$errors[] = "e12";
		}	
	}
	$new_dunzip = new dUnzip2($file);
	$params['extracted'] = count($new_dunzip->getList());
	if($params['extracted'] > 0) {
		$new_dunzip->unzipAll(getcwd());
		// write for config files
		if(file_exists($directory."/config.old.php")) {
			// set to old config
			insert_old_config($directory."/config.old.php",$directory."/config.inc.php");
			unlink($directory."/config.old.php");
		}
		if(file_exists("application/include/".$directory."/config.old.php")) {
			// set to old config
			insert_old_config("application/include/".$directory."/config.old.php","application/include/".$directory."/config.inc.php");
			unlink("application/include/".$directory."/config.old.php");
		}
		// clear menu cache
		clear_menu_cache($cfg);
		// get table information
		$table_files = list_files($directory."/tables");
		$table = array();
		if(is_array($table_files) && !empty($table_files)) {
			foreach($table_files as $value) {
				include($value);
			}
		}
		$params['table'] = $table;
	} else {
		// courrupted zip file
		$errors = "e14";
	}
	if(!empty($params['table']) && $cfg['installed']) {
		$params['module'] = "loader";
		$params['function'] = "import";
		$cfg['api_request'] = $api_request;
		// let api execute sql code
		send_message($params,$cfg);
	} else {
		if(!$api_request) {
			// display message
			xml_generator("loader","import",$errors,$params,$cfg);
		}
	}
	$params['error'] = $errors;
	return $params;
}
?>