<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Import module
* @package TenderSystem
* @subpackage loader
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// determine if it is an administrator with level 2 permission
if (($_SESSION['ts_classification'] == "3" && $_SESSION['ts_permission'] == "2") || $_SESSION['ts_classification'] == "-1") {
	// set the variables
	$lang = $_SESSION['ts_lang'];
	if(!$lang) {
		$lang = $cfg['language'];
	}
	// field request errors and type 
	$fields_request = array (
		'action'	=> array(),
		'import'	=> array()		
	);
	get_request($fields_request,$action,$error,$cfg);
	if(!$_SESSION['ts_id']) {
		// No Session
		xml_generator("loader","error","e1","",$cfg);
	} elseif(!$cfg['loader']['enable']) {
		// Module Loader disabled
		xml_generator("loader","error","e16",$params,$cfg);
	} elseif(!$cfg['loader']['import']['enable']) {
		// Module Loader disabled
		xml_generator("loader","error","e18",$params,$cfg);
	} elseif($action['import']) {
		// field request errors and type 
		$fields_request = array (
			'uploadfile'	=> array("e4"),
			'directory'		=> array("e9")		
		);
		if(get_request($fields_request,$info,$error,$cfg)) {
			if($cfg['api']['connection'] == "module") {
				require(getcwd()."/modules/external/class/dunzip/dUnzip2.inc.php");
				require(getcwd()."/modules/external/class/dunzip/dZip.inc.php");
				// upgrade
				do_upgrade($info['uploadfile'],$info['directory'],$cfg);
			} else {
				// display error
				xml_generator("loader","error","e3","",$cfg);
			}
		} else {
			// No Session
			xml_generator("loader","error",$error,"",$cfg);
		}
	} elseif($action['action']) {
		$file = $_FILES['file'];
		if(!$file['name']) {
			// missing file name
			xml_generator("loader","error","e4","",$cfg);
		} else {
			$upload_dest = upload_file($file,"loader",$cfg);
			// send to the app
			if (is_string($upload_dest)) {
				require(getcwd()."/modules/external/class/dunzip/dUnzip2.inc.php");
				$new_dunzip = new dUnzip2($upload_dest);
				$params['file_count'] = count($new_dunzip->getList());
				$info = unserialize($new_dunzip->getZipInfo("zipfile_comment"));
				$params['directory'] = $info['directory'];
				$params['langinclude'] = $info['langinclude'];
				$params['version'] = $info['version'];
				$params['loader'] = $info['loader'];
				$params['time'] = $info['time'];
				$params['moduleversion'] = $info['moduleversion'];
				$params['changelog'] = wordwrap($info['changelog']);
				// check tender system requirements
				$params['moduleinfo'][0]['name'] = "TenderSystem";
				$params['moduleinfo'][0]['required'] = $info['requirements']['version']['min'];
				$params['moduleinfo'][0]['exportedon'] = $info['version'];
				$params['moduleinfo'][0]['current'] = $cfg['version'];
				if(version_compare($params['moduleinfo'][0]['current'],$params['moduleinfo'][0]['required']) >= 0) {
					$params['moduleinfo'][0]['class'] = "t1";
				} else {
					$params['moduleinfo'][0]['class'] = "e";
				}
				// check Module loader requirements
				$content = file_get_contents("modules/loader/language/".$lang."/default.xml");
				$params['moduleinfo'][1]['name'] = event_parser('<module_name>','</module_name>',$content);
				$params['moduleinfo'][1]['required'] = $info['requirements']['loaderversion']['min'];
				$params['moduleinfo'][1]['exportedon'] = $info['loader'];
				include(getcwd()."/modules/loader/_loader.php");
				$params['moduleinfo'][1]['current'] = $loader['module']['version'];
				if(version_compare($params['moduleinfo'][1]['current'],$params['moduleinfo'][1]['required']) >= 0) {
					$params['moduleinfo'][1]['class'] = "t1";
				} else {
					$params['moduleinfo'][1]['class'] = "e";
				}
				// check other module requirements
				foreach($info['requirements']['need'] as $key => $value) {
					$content = file_get_contents("modules/".$key."/language/".$lang."/default.xml");
					$moduleinfo['name'] = event_parser('<module_name>','</module_name>',$content);
					$moduleinfo['required'] = $value;
					$moduleinfo['exportedon'] = $info['module'][$key];
					$loader = array();
					include("modules/".$key."/_loader.php");
					$moduleinfo['current'] = $loader['module']['version'];
					if(version_compare($moduleinfo['current'],$moduleinfo['required']) >= 0) {
						$moduleinfo['class'] = "t1";
					} else {
						$moduleinfo['class'] = "e";
					}
					$params['moduleinfo'][] = $moduleinfo;
					unset($moduleinfo);
				}		
				$params['uploadfile'] = $upload_dest;
				$new_dunzip->close();
				$params['cantdelete'] = "0";
				if(file_exists($params['directory'])) {
					$params['exists'] = "1";
					// check if all files are readable and writable
					// get the api files
					if(is_dir("application/include/".$params['directory'])) {
						$files = examinedir("application/include/".$params['directory']);
						foreach($files as $value) {
							if(!is_readable($value) || !is_writable($value)) {
								$params['cantdelete'] = "1";
								$params['file'][] = $value;
							}
						}
					}
					// get the gui files
					$files = examinedir($params['directory']);
					foreach($files as $value) {
						if(!is_readable($value) || !is_writable($value)) {
							$params['cantdelete'] = "1";
							$params['file'][] = $value;
						}
					}
				}
				xml_generator("loader","import","",$params,$cfg);
			} else {
				// display error
				xml_generator("loader","error",$upload_dest['error'],$params,$cfg);
			}
		}
	} else {
		// missing file name
		xml_generator("loader","error","e4","",$cfg);
	}
} else {
	// unauthorised
	$errors[] = "e15";
	// response
	xml_generator("generic","error",$errors,$params,$cfg);
}
?>