<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Remove module
* @package TenderSystem
* @subpackage loader
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// determine if it is an administrator with level 2 permission
if (($_SESSION['ts_classification'] == "3" && $_SESSION['ts_permission'] == "2") || $_SESSION['ts_classification'] == "-1") {
	// these modules should not be remove
	$core = array("modules/area","modules/user","modules/session",
				"modules/password","modules/organisation","modules/branch","modules/generic",
				"modules/category","modules/loader","modules/procure",
				"modules/settings","modules/utilities","modules/external");
	// field request errors and type 
	$fields_request = array (
		'dir'		=> array(),
		'action'	=> array()		
	);
	get_request($fields_request,$action,$error,$cfg);
	if(!$_SESSION['ts_id']) {
		// No Session
		xml_generator("loader","error","e1","",$cfg);
	} elseif(!$cfg['loader']['enable']) {
		// Module Loader disabled
		xml_generator("loader","error","e16",$params,$cfg);
	} elseif(!$cfg['loader']['remove']['enable']) {
		// Module Loader disabled
		xml_generator("loader","error","e19",$params,$cfg);
	} elseif($action['dir']) {
		if($cfg['api']['connection'] == "module") {
			$directory = $action['dir'];
			$content = file_get_contents($directory."/language/".$_SESSION['ts_lang']."/default.xml");
			if($content) {
				$tmp['name'] = event_parser('<module_name>','</module_name>',$content);
			}
			include($directory."/_loader.php");
			foreach($loader['module'] as $key1 => $value1) {
				$tmp[$key1]	= $value1;
			}
			$tmp['filename'] = $directory;
			$params['moduleinfo'][] = $tmp;
			$params['directory'] = $directory;
			if(in_array($params['directory'],$core)) {
				$params['core'] = "1";
			} else {
				$params['core'] = "0";
				$params['cantdelete'] = "0";
				// check if all files are readable and writable
				// get the api files
				if(is_dir("application/include/".$directory)) {
					$files = examinedir("application/include/".$directory);
					foreach($files as $value) {
						if(!is_readable($value) || !is_writable($value)) {
							$params['cantdelete'] = "1";
							$params['file'][] = $value;
						}
					}
				}
				// get the gui files
				$files = examinedir($directory);
				foreach($files as $value) {
					if(!is_readable($value) || !is_writable($value)) {
						$params['cantdelete'] = "1";
						$params['file'][] = $value;
					}
				}
			}
			xml_generator("loader","remove","",$params,$cfg);
		} else {
			// must perform on module
			xml_generator("loader","error","e3","",$cfg);
		}
	} elseif($action['action']) {
		if($cfg['api']['connection'] == "module") {
			// field request errors and type 
			$fields_request = array (
				'dontremove'	=> array(""),
				'directory'		=> array("e9")
			);
			if(get_request($fields_request,$info,$error,$cfg)) {
				$directory = $info['directory'];
				if(in_array($directory,$core)) {
					// cannot remove core modules
					xml_generator("loader","error","e10","",$cfg);
				} else {
					if(file_exists($directory."/tables") && !$info['dontremove']) {
						$table_files = list_files($directory."/tables");
						$table = array();
						foreach($tables_files as $value) {
							include($value);
						}
						$param['table'] = $table;
					}
					if(!remove($directory)) {
						$params['error'] = "e5";	
					} else {
						$params['removegui'] = TRUE;
					}
					if(is_dir("application/include/".$directory) && !remove("application/include/".$directory)) {
						$params['error'] = "e6";	
					} else {
						$params['removeapi'] = TRUE;	
					}
					if($params['table']) {
						$params['module'] = "loader";
						$params['function'] = "remove";
						// let api execute sql code
						send_message($params,$cfg);
					} else {
						// display message
						xml_generator("loader","remove",$params['error'],$params,$cfg);
					}
				}
			} else {
				// error
				xml_generator("loader","error",$error,"",$cfg);
			}
		} else {
			// must perform on module
			xml_generator("loader","error","e3","",$cfg);
		}
	} else {
		// missing module	
		xml_generator("loader","error","e2","",$cfg);
	}
} else {
	// unauthorised
	$errors[] = "e15";
	// response
	xml_generator("generic","error",$errors,$params,$cfg);
}
?>