<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Package rollback
* @package TenderSystem
* @subpackage loader
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// determine if it is an administrator with level 2 permission
if (($_SESSION['ts_classification'] == "3" && $_SESSION['ts_permission'] == "2") || $_SESSION['ts_classification'] == "-1") {
	if(!$cfg['loader']['enable']) {
		// Module Loader disabled
		xml_generator("loader","error","e16",$params,$cfg);
	} elseif(!$cfg['loader']['upgrade']['enable']) {
		// Upgrade disabled
		xml_generator("loader","error","e20",$params,$cfg);
	} else {
		$xml = '<?xml version="1.0" encoding="UTF-8"?>'."\n";
		$xml.= "<upgrades>";
		$file_list = list_files("rollback");
		foreach($file_list as $value) {
			$loader = array();
			if(strpos($value, ".php")) {
				include($value);
				if(!empty($loader)) {
					$xml.= "<upgrade location=\"".str_replace(array("rollback/modules_",".php"),array("modules/",""),$value)."\">";
					$xml.=xmlencode_array($loader,2);
					$xml.="<download>
						<type>file</type>
						<file>".str_replace(".php",".zip",$value)."</file>
						<md5_file></md5_file>
						<sha1_file></sha1_file>
					</download>";
					$xml.="</upgrade>";
				}
			}
		}
		$xml.= "</upgrades>\n";
		echo $xml;
		
		function xmlencode_array($array,$c=0) {
			$first = TRUE;
			$result = "";
			foreach ($array as $key => $value) {
				if(is_array($value) && $key!="download") {
					$result.= "<".$key.">";
					$result.= xmlencode_array($value,$c+1);
					$result.="</".$key.">";
				} else {
					$result.= "<".$key.">".$value."</".$key.">";
				}
			}
			return $result;
		}
	}
} else {
	// unauthorised
	$errors[] = "e15";
	// response
	xml_generator("generic","error",$errors,$params,$cfg);
}
?>