<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/checkupgrade"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'loader'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="loader"/>
					<input type="hidden" name="function" value="upgrade"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
						</tr>
						<xsl:if test="module_info">
							<tr>
								<td align="left" class="h t1" colspan="4">
									<xsl:value-of select="$lng/recommendedmodule"/>
								</td>
							</tr>
							<xsl:for-each select="module_info">
								<xsl:if test="good='1'">
								<tr>
									<td colspan="4"></td>
								</tr>
								<tr>
									<td align="left" class="h1 t1"  colspan="2">
										<xsl:value-of select="location"/>
									</td>
									<td align="left" class="h1a t1"  colspan="2">
										<xsl:choose>
											<xsl:when test="type='new'">
												<xsl:value-of select="$lng/newmodule"/>
											</xsl:when>
											<xsl:when test="type='upgrade'">
												<xsl:value-of select="$lng/upgrade"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$lng/unknown"/>
											</xsl:otherwise>
										</xsl:choose>
									</td>
								</tr>
								<tr>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/currentversion"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="current/version"/>
									</td>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/newversion"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="module/version"/>
									</td>
								</tr>
								<tr>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/modulestatus"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="module/status"/>
									</td>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/moduledate"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="module/date"/>
									</td>
								</tr>
								<tr>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/modulecopyright"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="module/copyright"/>
									</td>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/modulelicense"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="module/license"/>
									</td>
								</tr>
								<tr>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/upgradeurl"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="upgrade_url"/>
									</td>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/upload"/>
									</td>
									<td align="left" class="t2">
										<input type="radio" name="upload[{location}]" value="{session_location}"/>
									</td>
								</tr>
								</xsl:if>
							</xsl:for-each>
							<tr>
								<td align="right" class="t1" colspan="4">
									<input type="submit" name="action" class="t2">
										<xsl:attribute name="value">
											<xsl:value-of select="$lng/upgrade"/>
										</xsl:attribute>
									</input>
								</td>
							</tr>
							<tr><td align="left" colspan="4"></td></tr>
							<tr>
								<td align="left" class="h t1" colspan="4">
									<xsl:value-of select="$lng/notrecommendedmodule"/>
								</td>
							</tr>
							<xsl:for-each select="module_info">
								<xsl:if test="good='0'">
								<tr>
									<td colspan="4"></td>
								</tr>
								<tr>
									<td align="left" class="h1 t1"  colspan="2">
										<xsl:value-of select="location"/>
									</td>
									<td align="left" class="h1a e"  colspan="2">
										<xsl:choose>
											<xsl:when test="type='minrequire'">
												<xsl:value-of select="$lng/nominrequire"/>
											</xsl:when>
											<xsl:when test="type='downgrade'">
												<xsl:value-of select="$lng/downgrade"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$lng/unknown"/>
											</xsl:otherwise>
										</xsl:choose>
									</td>
								</tr>
								<tr>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/currentversion"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="current/version"/>
									</td>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/moduleversion"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="module/version"/>
									</td>
								</tr>
								<tr>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/modulestatus"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="module/status"/>
									</td>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/moduledate"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="module/date"/>
									</td>
								</tr>
								<tr>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/modulecopyright"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="module/copyright"/>
									</td>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/modulelicense"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="module/license"/>
									</td>
								</tr>
								<tr>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/upgradeurl"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="upgrade_url"/>
									</td>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/upload"/>
									</td>
									<td align="left" class="t2">
										<input type="radio" name="upload[{location}]" value="{session_location}"/>
									</td>
								</tr>
								</xsl:if>
							</xsl:for-each>
								<tr>
									<td align="right" class="t1" colspan="4">
										<input type="submit" name="action" class="t2">
											<xsl:attribute name="value">
												<xsl:value-of select="$lng/upgrade"/>
											</xsl:attribute>
										</input>
									</td>
								</tr>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
