<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../generic/templates/languages.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/exportmodule"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'loader'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="loader"/>
					<input type="hidden" name="function" value="export"/>
					<input type="hidden" name="directory" value="{directory}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td align="left" class="h t1" colspan="4">
								<xsl:value-of select="$lng/export"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/modulename"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="moduleinfo/name"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/moduleversion"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="moduleinfo/version"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/modulestatus"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="moduleinfo/status"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/moduledate"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="moduleinfo/date"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/modulecopyright"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="moduleinfo/copyright"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/modulelicense"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="moduleinfo/license"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/filename"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="moduleinfo/filename"/>
							</td>
							<xsl:if test="moduleinfo/url!=''">
								<td align="left" class="t1">
									<xsl:value-of select="$lng/url"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="moduleinfo/url"/>
								</td>
							</xsl:if>
						</tr>
						<xsl:for-each select="modulelanguage">
							<tr>
								<xsl:variable name="code" select="."/>
								<td align="left" class="t1" colspan="2">
									<xsl:call-template name="language_value"><xsl:with-param name="iso" select="$code"/></xsl:call-template>
								</td>
								<td align="left" class="t1" colspan="2">
									<input type="checkbox" name="langinclude[{$code}]" value="{$code}">
										<xsl:if test=".='en'">
											<xsl:attribute name="checked">checked</xsl:attribute>
											<xsl:attribute name="disabled">disabled</xsl:attribute>
											<xsl:attribute name="name"></xsl:attribute>
										</xsl:if>
									</input>
									<xsl:if test=".='en'">
										<input type="hidden" name="langinclude[{$code}]" value="{$code}"/>
									</xsl:if>
								</td>
							</tr>
						</xsl:for-each>
						<tr>
							<td align="right" class="t1" colspan="4">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/export"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					<xsl:if test="moduleinfo/description!=''">
						<tr>
							<td align="left" class="h1 t1" colspan="4">
								<xsl:value-of select="$lng/moduledescription"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t2" colspan="4">
								<pre class="t2">
									<xsl:value-of select="moduleinfo/description"/>
								</pre>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="moduleinfo/changelog and moduleinfo/changelog!=''">
						<tr>
							<td align="left" class="h1 t1" colspan="4">
								<xsl:value-of select="$lng/modulechangelog"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t2" colspan="4">
								<pre class="t2">
									<xsl:value-of select="moduleinfo/changelog"/>
								</pre>
							</td>
						</tr>
					</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
