<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/importmodule"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'loader'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="loader"/>
					<input type="hidden" name="function" value="import"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
						</tr>
						<xsl:if test="extracted">
							<tr>
								<td align="left" class="t1" colspan="2">
									<xsl:value-of select="$lng/extracted"/>:<xsl:value-of select="extracted"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="extractedname"/>
								</td>
							</tr>
							<tr>
								<td align="left" class="h t1" colspan="4">
									<xsl:value-of select="$lng/import"/>
								</td>
							</tr>
							<tr>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/file"/>
								</td>
								<td align="right" class="t2" colspan="3">
									<input type="file" name="file" class="t2"/>
									<input type="submit" name="action" class="t2">
										<xsl:attribute name="value">
											<xsl:value-of select="$lng/import"/>
										</xsl:attribute>
									</input>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="sql_success">
							<tr>
								<td align="left" class="t1" colspan="2">
									<xsl:value-of select="$lng/sqlsuccess"/>:<xsl:value-of select="sql_success"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="directory">
							<input type="hidden" name="uploadfile" value="{uploadfile}"/>
							<tr>
								<td align="left" class="h t1" colspan="2">
									<xsl:value-of select="$lng/moduleinfo"/>
								</td>
							</tr>
							<tr>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/directory"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="directory"/>
									<input type="hidden" name="directory" value="{directory}"/>
								</td>
							</tr>
							<tr>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/exportdate"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="time"/>
								</td>
							</tr>
							<tr>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/file_count"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="file_count"/>
								</td>
							</tr>
							<tr>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/moduleversion"/>
								</td>
								<td align="left" class="t2">
									<xsl:choose>
										<xsl:when test="moduleversion!=''">
											<xsl:value-of select="moduleversion"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$lng/unknown"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
							<xsl:if test="exists">
								<tr>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/notice"/>
									</td>
									<td align="left" class="e">
										<xsl:value-of select="$lng/alreadyexists"/>
									</td>
								</tr>
							</xsl:if>
							<tr>
								<td colspan="2">
									<table border="0" align="center" cellpadding="2" cellspacing="0" width="100%" bgcolor="FFFFFF">
										<tr>
											<td align="left" class="h1 t1">
												<xsl:value-of select="$lng/name"/>
											</td>
											<td align="left" class="h1a t1">
												<xsl:value-of select="$lng/required"/>
											</td>
											<td align="left" class="h1a t1">
												<xsl:value-of select="$lng/exportedon"/>
											</td>
											<td align="left" class="h1a t1">
												<xsl:value-of select="$lng/current"/>
											</td>
										</tr>
									<xsl:for-each select="moduleinfo">
										<tr>
											<td align="left" class="h2b t1">
												<xsl:choose>
													<xsl:when test="name!=''">
														<xsl:value-of select="name"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="directory"/>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="left" class="h2c t1">
												<xsl:choose>
													<xsl:when test="required!=''">
														<xsl:value-of select="required"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="$lng/unknown"/>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="left" class="h2c t1">
												<xsl:choose>
													<xsl:when test="exportedon!=''">
														<xsl:value-of select="exportedon"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="$lng/unknown"/>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="left" class="h2c {class}">
												<xsl:value-of select="current"/>
											</td>											
										</tr>
									</xsl:for-each>
									</table>
								</td>
							</tr>
							<xsl:if test="cantdelete!='1'">
							<tr>
								<td align="right" class="t1" colspan="4">
									<input type="submit" name="import" class="t2">
										<xsl:attribute name="value">
											<xsl:value-of select="$lng/import"/>
										</xsl:attribute>
									</input>
								</td>
							</tr>
							</xsl:if>
							<xsl:if test="cantdelete='1'">
								<tr><td><br/></td></tr>
								<tr>
									<td class="h1 t1" colspan="3"><xsl:value-of select="$lng/filename"/></td>
									<td class="h1a t1"><xsl:value-of select="$lng/readwriteaccess"/></td>
								</tr>
								<xsl:for-each select="file">
								<tr>
									<td class="h2b t2" colspan="3"><xsl:value-of select="."/></td>
									<td class="h2c t2" align="center">
										<img border="0" valign="top">
											<xsl:attribute name="src">./theme/<xsl:value-of select="$theme"/>/icon/no.gif</xsl:attribute>
											<xsl:attribute name="alt"><xsl:value-of select="readwriteaccess"/></xsl:attribute>
											<xsl:attribute name="title"><xsl:value-of select="readwriteaccess"/></xsl:attribute>
										</img>
									</td>
								</tr>
								</xsl:for-each>
								<tr><td><br/></td></tr>
							</xsl:if>
							<xsl:if test="changelog!=''">
								<tr>
									<td align="left" class="h1 t1" colspan="4">
										<xsl:value-of select="$lng/modulechangelog"/>
									</td>
								</tr>
								<tr>
									<td align="left" class="t2" colspan="4">
										<pre class="t2">
											<xsl:value-of select="changelog"/>
										</pre>
									</td>
								</tr>
							</xsl:if>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
