<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/removemodule"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'loader'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="loader"/>
					<input type="hidden" name="function" value="remove"/>
					<input type="hidden" name="directory" value="{directory}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td align="left" class="h t1" colspan="4">
								<xsl:value-of select="$lng/remove"/>
							</td>
						</tr>
					<xsl:if test="removegui">
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/removegui"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="sql_success">
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/sqlsuccess"/>:<xsl:value-of select="sql_success"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="removeapi">
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/removeapi"/>
							</td>
						</tr>
					</xsl:if>
				<xsl:if test="directory">
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/modulename"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="moduleinfo/name"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/moduleversion"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="moduleinfo/version"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/modulestatus"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="moduleinfo/status"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/moduledate"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="moduleinfo/date"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/modulecopyright"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="moduleinfo/copyright"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/modulelicense"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="moduleinfo/license"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/filename"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="moduleinfo/filename"/>
							</td>
						<xsl:if test="moduleinfo/url!=''">
							<td align="left" class="t1">
								<xsl:value-of select="$lng/url"/>
							</td>
							<td align="left" class="t2">
								<a href="{moduleinfo/url}" target="blank">
									<xsl:value-of select="moduleinfo/url"/>
								</a>
							</td>
						</xsl:if>
						</tr>
					<xsl:if test="core!='1' and cantdelete!='1'">
						<tr>
							<td align="right" class="t1" colspan="4">
								<xsl:value-of select="$lng/dontremovetables"/>
								<input type="checkbox" name="dontremove"/>
							</td>
						</tr>
						<tr>
							<td align="right" class="t1" colspan="4">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/remove"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="core='1'">
						<tr>
							<td align="right" class="e" colspan="4">
								<xsl:value-of select="$lng/cantcore"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="cantdelete='1'">
						<tr><td><br/></td></tr>
						<tr>
							<td class="h1 t1" colspan="3"><xsl:value-of select="$lng/filename"/></td>
							<td class="h1a t1"><xsl:value-of select="$lng/readwriteaccess"/></td>
						</tr>
						<xsl:for-each select="file">
						<tr>
							<td class="h2b t2" colspan="3"><xsl:value-of select="."/></td>
							<td class="h2c t2" align="center">
								<img border="0" valign="top">
									<xsl:attribute name="src">./theme/<xsl:value-of select="$theme"/>/icon/no.gif</xsl:attribute>
									<xsl:attribute name="alt"><xsl:value-of select="readwriteaccess"/></xsl:attribute>
									<xsl:attribute name="title"><xsl:value-of select="readwriteaccess"/></xsl:attribute>
								</img>
							</td>
						</tr>
					</xsl:for-each>
					</xsl:if>
				</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
