<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/loadersettings"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'loader'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="loader"/>
					<input type="hidden" name="function" value="settings"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="update='1'">
						<tr>
							<td colspan="4" class="t1">
								<xsl:value-of select="$lng/changedsuccess"/>
							</td>
						</tr>
						</xsl:if>
						<tr>
							<td align="left" class="h t1">
								<xsl:value-of select="$lng/setting"/>
							</td>
							<td align="left" class="ha t1">
								<xsl:value-of select="$lng/value"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/loaderenable"/>
							<xsl:with-param name="input_name" select="'loaderenable'"/>
							<xsl:with-param name="input_value" select="settings/loaderenable"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/loaderexportenable"/>
							<xsl:with-param name="input_name" select="'loaderexportenable'"/>
							<xsl:with-param name="input_value" select="settings/loaderexportenable"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/loaderimportenable"/>
							<xsl:with-param name="input_name" select="'loaderimportenable'"/>
							<xsl:with-param name="input_value" select="settings/loaderimportenable"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/loaderremoveenable"/>
							<xsl:with-param name="input_name" select="'loaderremoveenable'"/>
							<xsl:with-param name="input_value" select="settings/loaderremoveenable"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/loaderupgradeenable"/>
							<xsl:with-param name="input_name" select="'loaderupgradeenable'"/>
							<xsl:with-param name="input_value" select="settings/loaderupgradeenable"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/loaderupgradestable"/>
							</td>
							<td align="left" class="t2">
								<input name="loaderupgradestable" value="{settings/loaderupgradestable}" type="text" size="50" class="t2"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/loaderupgradedevelopment"/>
							</td>
							<td align="left" class="t2">
								<input name="loaderupgradedevelopment" value="{settings/loaderupgradedevelopment}" type="text" size="50" class="t2"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/loaderupgradeextra"/>
							</td>
							<td align="left" class="t2">
								<input name="loaderupgradeextra" value="{settings/loaderupgradeextra}" type="text" size="50" class="t2"/>
							</td>
						</tr>
						<tr>
							<td align="right" colspan="4">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submit"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/changesettings"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/instruction">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>
	
<xsl:template name="radio_true_false">
	<xsl:param name="setting_name" select="$lng/setting"/>
	<xsl:param name="input_name" select="''"/>
	<xsl:param name="input_value" select="''"/>
	<xsl:param name="true" select="$lng/true"/>
	<xsl:param name="false" select="$lng/false"/>
	<tr>
		<td align="left" class="t1">
			<xsl:value-of select="$setting_name"/>
		</td>
		<td align="left" class="t2">
			<input name="{$input_name}" value="TRUE" type="radio">
				<xsl:if test="$input_value='TRUE'">
					<xsl:attribute name="checked"/>
				</xsl:if>
			</input>
			<xsl:value-of select="$true"/>
			<input name="{$input_name}" value="FALSE" type="radio">
				<xsl:if test="$input_value='FALSE'">
					<xsl:attribute name="checked"/>
				</xsl:if>
			</input>
			<xsl:value-of select="$false"/>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>
