<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/uploaded"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'loader'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="loader"/>
					<input type="hidden" name="function" value="upgrade"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
						</tr>
						<xsl:if test="module">
						<xsl:if test="user/classification!='-1'">
							<tr>
								<td align="left" class="t1" colspan="4">
									<a href="main.php?module=languageeditor&amp;function=utilities">
										<xsl:value-of select="$lng/recommendchecklanguages"/>
									</a>
								</td>
							</tr>
						</xsl:if>
							<tr>
								<td align="left" class="h t1" colspan="4">
									<xsl:value-of select="$lng/uploadedmodules"/>
								</td>
							</tr>
							<xsl:for-each select="module">
								<tr>
									<td align="left" class="h2b t1"  colspan="2">
										<xsl:value-of select="location"/>
									</td>
									<td align="left" class="h2c t2"  colspan="2">
										<xsl:choose>
											<xsl:when test="status='md5error'">
												<xsl:attribute name="class">h2c e</xsl:attribute>
												<xsl:value-of select="$lng/md5error"/>
												<xsl:value-of select="' : '"/>
												<xsl:value-of select="filecheck"/>
												<xsl:value-of select="' != '"/>
												<xsl:value-of select="check"/>
											</xsl:when>
											<xsl:when test="status='sha1error'">
												<xsl:attribute name="class">h2c e</xsl:attribute>
												<xsl:value-of select="$lng/sha1error"/>
												<xsl:value-of select="' : '"/>
												<xsl:value-of select="filecheck"/>
												<xsl:value-of select="' != '"/>
												<xsl:value-of select="check"/>
											</xsl:when>
											<xsl:when test="status='nosourceforgelinks'">
												<xsl:attribute name="class">h2c e</xsl:attribute>
												<xsl:value-of select="$lng/upgradenosourceforgelinks"/>
											</xsl:when>
											<xsl:when test="status='errors'">
												<xsl:attribute name="class">h2c e</xsl:attribute>
												<xsl:value-of select="$lng/upgradeerrors"/>
											</xsl:when>
											<xsl:when test="status='success'">
												<xsl:value-of select="$lng/upgradesuccess"/>
												<xsl:value-of select="' : '"/>
												<xsl:value-of select="extracted"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:attribute name="class">h2c e</xsl:attribute>
												<xsl:value-of select="status"/>
											</xsl:otherwise>
										</xsl:choose>
									</td>
								</tr>
							</xsl:for-each>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
