<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/moduleloader"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'loader'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="loader"/>
					<input type="hidden" name="function" value="import"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
						</tr>
					<xsl:if test="install='1'">
						<xsl:if test="loaderimportenable='1'">
							<tr>
								<td align="left" class="h t1" colspan="4">
									<xsl:value-of select="$lng/import"/>
								</td>
							</tr>
							<tr>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/file"/>
								</td>
								<td align="right" class="t2" colspan="3">
									<input type="file" name="file" class="t2"/>
									<input type="submit" name="action" class="t2">
										<xsl:attribute name="value">
											<xsl:value-of select="$lng/import"/>
										</xsl:attribute>
									</input>
								</td>
							</tr>
						</xsl:if>
					<xsl:if test="loaderupgradeenable='1'">
							<tr>
								<td align="left" class="h t1" colspan="4">
									<xsl:value-of select="$lng/moduleloading"/>
								</td>
							</tr>
							<tr>
						<xsl:if test="loaderupgradestable!=''">
								<td align="left" class="t2" colspan="2">
									<a href="main.php?module=loader&amp;function=check_upgrade&amp;upgrade_type=stable">
										<xsl:value-of select="$lng/checkupgradestable"/>
									</a>
								</td>
						</xsl:if>
						<xsl:if test="loaderupgradeextra!=''">
								<td align="left" class="t2" colspan="2">
									<a href="main.php?module=loader&amp;function=check_upgrade&amp;upgrade_type=extra">
										<xsl:value-of select="$lng/checkupgradeextra"/>
									</a>
								</td>
						</xsl:if>
							</tr>
							<tr>
						<xsl:if test="loaderupgradedevelopment!=''">
								<td align="left" class="t2" colspan="2">
									<a href="main.php?module=loader&amp;function=check_upgrade&amp;upgrade_type=development">
										<xsl:value-of select="$lng/checkupgradedevelopment"/>
									</a>
								</td>
						</xsl:if>
								<td align="left" class="t2" colspan="2">
									<a href="main.php?module=loader&amp;function=check_upgrade&amp;upgrade_type=module">
										<xsl:value-of select="$lng/checkupgrademodule"/>
									</a>
								</td>
							</tr>
							<tr>
								<td align="left" class="t2" colspan="2">
									<a href="main.php?module=loader&amp;function=check_upgrade&amp;upgrade_type=rollback">
										<xsl:value-of select="$lng/checkrollback"/>
									</a>
								</td>
							</tr>
					</xsl:if>
							<tr>
								<td><br/></td>
							</tr>
					</xsl:if>
							<tr>
								<td align="left" class="h t1" colspan="4">
									<xsl:value-of select="$lng/export"/>
								</td>
							</tr>
							<tr>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/config"/>
								</td>
								<td align="left" class="t2">
									<a>
										<xsl:attribute name="href">./main.php?module=loader&amp;function=export_config</xsl:attribute>
										<img src="./theme/{$theme}/icon/export.gif" border="0" alt="{$lng/export}"/>
									</a>
								</td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/data"/>
								</td>
								<td align="left" class="t2">
									<a>
										<xsl:attribute name="href">./main.php?module=loader&amp;function=export_data</xsl:attribute>
										<img src="./theme/{$theme}/icon/export.gif" border="0" alt="{$lng/export}"/>
									</a>
								</td>
							</tr>
							<tr>
								<td><br/></td>
							</tr>
						<xsl:if test="module">
							<tr>
								<td align="left" class="h t1" colspan="4">
									<xsl:value-of select="$lng/installmodule"/>
								</td>
							</tr>
							<xsl:for-each select="module">
								<tr>
									<td colspan="4"></td>
								</tr>
								<tr>
									<td align="left" class="h1 t1" colspan="3">
										<img src="./{filename}/module.gif" border="0" alt=""/>
									</td>
									<td align="left" class="h1a t1">
										<xsl:value-of select="name"/>
									</td>
								</tr>
								<tr>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/directory"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="filename"/>
									</td>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/moduleversion"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="version"/>
									</td>
								</tr>
								<tr>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/modulestatus"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="status"/>
									</td>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/moduledate"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="date"/>
									</td>
								</tr>
								<tr>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/modulecopyright"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="copyright"/>
									</td>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/modulelicense"/>
									</td>
									<td align="left" class="t2">
										<xsl:value-of select="license"/>
									</td>
								</tr>
							<xsl:if test="../install='1' and (../loaderexportenable='1' or ../loaderremoveenable='1')">
								<tr>
								<xsl:if test="../loaderexportenable='1'">
									<td align="left" class="t1">
										<xsl:value-of select="$lng/export"/>
									</td>
									<td align="left" class="t2">
										<a>
											<xsl:attribute name="href">./main.php?module=loader&amp;function=export&amp;dir=<xsl:value-of select="filename"/></xsl:attribute>
										<img src="./theme/{$theme}/icon/export.gif" border="0" alt="{$lng/export}"/>
										</a>
									</td>
								</xsl:if>
								<xsl:if test="../loaderremoveenable='1'">
									<td align="left" class="t1">
										<xsl:value-of select="$lng/remove"/>
									</td>
									<td align="left" class="t2">
										<a>
											<xsl:attribute name="href">./main.php?module=loader&amp;function=remove&amp;dir=<xsl:value-of select="filename"/></xsl:attribute>
										<img src="./theme/{$theme}/icon/no.gif" border="0" alt="{$lng/remove}"/>
										</a>
									</td>
								</xsl:if>
								</tr>
							</xsl:if>
							<xsl:if test="url!='' or manual">
								<tr>
								<xsl:if test="url!=''">
									<td align="left" class="t1">
										<xsl:value-of select="$lng/url"/>
									</td>
									<td align="left" class="t2">
										<a href="{url}" target="blank">
											<xsl:value-of select="url"/>
										</a>
									</td>
								</xsl:if>
								<xsl:if test="manual">
									<td align="left" class="t1">
										<xsl:value-of select="$lng/manual"/>
									</td>
									<td align="left" class="t2">
										<a href="{manual}">
											<xsl:value-of select="$lng/view"/>
										</a>
									</td>
								</xsl:if>
								</tr>
							</xsl:if>
							</xsl:for-each>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
