<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Upgrade module
* @package TenderSystem
* @subpackage loader
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// determine if it is an administrator with level 2 permission
if (($_SESSION['ts_classification'] == "3" && $_SESSION['ts_permission'] == "2") || $_SESSION['ts_classification'] == "-1") {
	$errors = array();
	// field request errors and type 
	$fields_request = array (
		'action'	=> array(),
		'upload'	=> array()		
	);
	get_request($fields_request,$info,$errors,$cfg);
	if(!$_SESSION['ts_id']) {
		// No Session
		xml_generator("loader","error","e1","",$cfg);
	} elseif($cfg['api']['connection'] != "module") {
		// display error
		xml_generator("loader","error","e3","",$cfg);
    } elseif(!$cfg['loader']['enable']) {
		// Module Loader disabled
		xml_generator("loader","error","e16",$params,$cfg);
	} elseif(!$cfg['loader']['upgrade']['enable']) {
		// Upgrade disabled
		xml_generator("loader","error","e20",$params,$cfg);
	} elseif($info['action'] && $info['upload'] && $_SESSION['module_info']) {
		// check if rollback
		if($_SESSION['upgrade_type'] == "rollback") {
			$rollback = TRUE;	
		} else {
			$rollback = FALSE;
		}
		require(getcwd()."/modules/external/class/dunzip/dUnzip2.inc.php");
		require(getcwd()."/modules/external/class/dunzip/dZip.inc.php");
		// go through all urls
		foreach($info['upload'] as $session_location) {
			$upload_module = $_SESSION['module_info'][$session_location];
			$params['module'][$session_location]['location'] = $upload_module['location'];
			if($upload_module['download'][0]['type'] == "sourceforge") {
				$main_link = $upload_module['download'][0]['base'].$upload_module['download'][0]['file'];
				$got = get_web_contents($main_link."?download");
				$match = get_sourceforge_links($got['web_contents']);
				if($match) {
					// TRY ECACH LINK
					foreach($match[4] as $value) {
						$got = get_web_contents($main_link."?use_mirror=".$value);
						$start = strpos($got['web_contents'],"<head>");
						$end = strpos($got['web_contents'],"</head>");
						if($start && $end) {
							$head = substr($got['web_contents'],$start,$end-$start);
							// get download link
							$link = get_redirect_link($head);
							if($link[2][0]) {
								// get file contents
								$got = get_web_contents($link[2][0]);
								// write file
								$filename = tempnam("upload","loader").".zip";
								$fp = fopen($filename, "w+");
								fwrite($fp,$got['web_contents'],strlen($got['web_contents']));
								fclose($fp);
								// next upgrade
								break;
							} else {
								// Try next link
								continue;
							}
						} else {
							// Try next link
							continue;
						}
					}
					if(!$params['module'][$session_location]['status']) {
						$params['module'][$session_location]['status'] = "nosourceforgelinks";
					}
				} else {
					$params['module'][$session_location]['status'] = "nosourceforgelinks";
					continue;
				}
			} elseif($upload_module['download'][0]['type'] == "direct") {
				// get file contents
				$got = get_web_contents($upload_module['download'][0]['base'].$upload_module['download'][0]['file']);
				// write file
				$filename = tempnam("upload","loader").".zip";
				$fp = fopen($filename, "w+");
				fwrite($fp,$got['web_contents'],strlen($got['web_contents']));
				fclose($fp);
			} elseif($upload_module['download'][0]['type'] == "file") {
				// filename
				$filename = $upload_module['download'][0]['file'];
			} else {
				continue;	
			}
			// check md5
			if($upload_module['download'][0]['md5_file'] && $upload_module['download'][0]['md5_file'] != md5_file($filename)) {
				$params['module'][$session_location]['status'] = "md5error";
				$params['module'][$session_location]['filecheck'] = md5_file($filename);
				$params['module'][$session_location]['check'] = $upload_module['download'][0]['md5_file'];
				// next upgrade
				continue;
			}
			// check sha1
			if($upload_module['download'][0]['sha1_file'] && $upload_module['download'][0]['sha1_file'] != sha1_file($filename)) {
				$params['module'][$session_location]['status'] = "sha1error";
				$params['module'][$session_location]['filecheck'] = sha1_file($filename);
				$params['module'][$session_location]['check'] = $upload_module['download'][0]['sha1_file'];
				// next upgrade
				continue;
			}
			// upgrade
			$result = do_upgrade($filename,$upload_module['location'],$cfg,TRUE,$rollback);
			if(is_array($result['error']) && !empty($result['error'])) {
				$errors = array_merge($errors,$result['error']);
				$params['module'][$session_location]['status'] = "errors";
			} else {
				$params['module'][$session_location]['status'] = "success";
				$params['module'][$session_location]['extracted'] = $result['extracted'];
			}
			unlink($filename);
		}
		// unset
		$_SESSION['module_info'] = FALSE;
		// Invalid Action
		xml_generator("loader","upgrade",$errors,$params,$cfg);
	} else {
		// Invalid Action
		xml_generator("loader","error","e13","",$cfg);
	}
} else {
	// unauthorised
	$errors[] = "e15";
	// response
	xml_generator("generic","error",$errors,$params,$cfg);
}
?>