<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Utilities menu
* @package TenderSystem
* @subpackage loader
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// determine if it is an administrator with level 2 permission
if (($_SESSION['ts_classification'] == "3" && $_SESSION['ts_permission'] == "2") || $_SESSION['ts_classification'] == "-1") {
	if(!$cfg['loader']['enable']) {
		// Module Loader disabled
		$errors[] = "e16";
		// response
		xml_generator("loader","error",$errors,$params,$cfg);
	} else {
		// set the variables
		$lang = $_SESSION['ts_lang'];
		if(!$lang) {
			$lang = $cfg['language'];
		}
		// go through all modules default.xml file
		$directories = list_directories("modules");
		// loop through all the files (modules)
		foreach($directories as $value) {
			if(file_exists($value."/language/".$lang."/default.xml")) {
				$file['name'][] = $value."/language/".$lang."/default.xml";
			}
		}
		// possible extensions for manuals in order of preference
		$manual_extensions = array("html","htm","pdf","rtf","doc","swx","txt","zip","tar","gz","bz2","rar");
		// get info on each module
		foreach($file['name'] as $value) {
			$content = file_get_contents($value);
			if($content) {
				$tmp['name'] = event_parser('<module_name>','</module_name>',$content);
				$loader = array();
				include(str_replace("language/".$lang."/default.xml","_loader.php",$value));
				// if module versions should be checked
				if($cfg['loader']['check']['version']) {
					$check[str_replace(array("/language/".$lang."/default.xml","modules/"),"",$value)] = $loader;		
				}
				foreach($loader['module'] as $key1 => $value1) {
					$tmp[$key1]	= $value1;
				}
				$tmp['filename'] = str_replace("/language/".$lang."/default.xml","",$value);
				foreach($manual_extensions as $value) {
					if(file_exists($tmp['filename']."/language/".$lang."/manual.".$value)) {
						$tmp['manual'] = $tmp['filename']."/language/".$lang."/manual.".$value;
						break;
					}
				}
				if($tmp['version']) { 
					$params['module'][] = $tmp;
				}
				unset($tmp);
			}
		}
		// sort
		array_multisort($params['module']);
		if($cfg['loader']['check']['version']) {
			// check version
			foreach($check as $key => $value) {
				if($value['version']['min'] != $cfg['version']) {
					$tmp['name'] = $key;
					$tmp['bad'] = "version";
					$tmp['version1'] = $value['version']['min'];
					$tmp['version2'] = $cfg['version'];
					$params['checkmodule'][]= $tmp;
				}
				if($value['loaderversion']['min'] != $check['loader']['module']['version']) {
					$tmp['name'] = $key;
					$tmp['bad'] = "loaderversion";
					$tmp['version1'] = $value['loaderversion']['min'];
					$tmp['version2'] = $check['loader']['module']['version'];
					$params['checkmodule'][] = $tmp;
				}
				foreach($value['need'] as $key1 => $value1) {
					if($value1 != $check[$key1]['module']['version']) {
						$tmp['name'] = $key;
						$tmp['bad'] = $key1;
						$tmp['version1'] = $value1;
						$tmp['version2'] = $check[$key1]['module']['version'];
						$params['checkmodule'][] = $tmp;
					}	
				}
			}
			print_r($params['checkmodule']); die();
		}
		if($cfg['api']['connection'] == "module" && is_writable("modules") && is_writable("application/include/modules")) {
			$params['install'] = "1";
		}
		if($cfg['loader']['export']['enable']) {
			$params['loaderexportenable'] = "1";
		} else {
			$params['loaderexportenable'] = "0";
		}
		if($cfg['loader']['import']['enable']) {
			$params['loaderimportenable'] = "1";
		} else {
			$params['loaderimportenable'] = "0";
		}
		if($cfg['loader']['remove']['enable']) {
			$params['loaderremoveenable'] = "1";
		} else {
			$params['loaderremoveenable'] = "0";
		}
		if($cfg['loader']['upgrade']['enable']) {
			$params['loaderupgradeenable'] = "1";
		} else {
			$params['loaderupgradeenable'] = "0";
		}
		$params['loaderupgradestable'] = $cfg['loader']['upgrade']['stable'];
		$params['loaderupgradedevelopment'] = $cfg['loader']['upgrade']['development'];
		$params['loaderupgradeextra'] = $cfg['loader']['upgrade']['extra'];
		// send message to api
		xml_generator("loader","utilities","",$params,$cfg);
	}
} else {
	// unauthorised
	$errors[] = "e15";
	// response
	xml_generator("generic","error",$errors,$params,$cfg);
}
?>