<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../procure/templates/procure_status.xsl"/>

<!-- Type, page and limit -->
<xsl:param name="display" select="/response/display"/>
<xsl:param name="limit" select="/response/limit + 1"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/title"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/loghistory"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'log'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="log"/>
					<input type="hidden" name="function" value="message_log"/>
					<table border="0" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
							<td class="h t1">
								<xsl:value-of select="$lng/type"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/messageinfo"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/sendmethod"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/reference"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/attempts"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/attemptedon"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/body"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/status"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/delete"/>
							</td>
						</tr>
						<xsl:if test="message_log/id">
							<xsl:for-each select="message_log">
								<tr>
									<td><br/></td>
									<td class="h2b t2">
										<xsl:value-of select="classification"/>
									</td>
									<td class="h2c t2">
										<xsl:choose>
											<xsl:when test="send_method='email'">
												<strong><xsl:value-of select="$lng/subject"/>     :</strong><xsl:value-of select="subject"/><br/>
												<strong><xsl:value-of select="$lng/name"/>        :</strong><xsl:value-of select="name"/><br/>
												<strong><xsl:value-of select="$lng/email"/>       :</strong><xsl:value-of select="email"/><br/>
										<xsl:if test="emailcc!=''">
												<strong><xsl:value-of select="$lng/cc"/>          :</strong><xsl:value-of select="emailcc"/><br/>
										</xsl:if>
											</xsl:when>
											<xsl:when test="send_method='email_reply'">
												<strong><xsl:value-of select="$lng/subject"/>     :</strong><xsl:value-of select="subject"/><br/>
												<strong><xsl:value-of select="$lng/email"/>       :</strong><xsl:value-of select="email"/><br/>
											</xsl:when>
											<xsl:when test="send_method='sms'">
												<strong><xsl:value-of select="$lng/phonemobile"/> :</strong><xsl:value-of select="phone_mobile"/><br/>
											</xsl:when>
											<xsl:otherwise>
												<br/>
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="send_method"/><br/>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="reference"/><br/>
									</td>
									<td class="h2c t2" align="right">
										<xsl:if test="attempts &gt; 0">
											<xsl:value-of select="attempts"/>
										</xsl:if>
										<br/>
									</td>
									<td class="h2c t2">
										<xsl:if test="attempts &gt; 0">
											<xsl:value-of select="attempt_date"/><br/>
											<xsl:value-of select="attempt_time"/>
										</xsl:if>
										<br/>
									</td>
									<td class="h2c t2">
										<xsl:choose>
											<xsl:when test="body='1'">
												<xsl:value-of select="$lng/notstored"/>
											</xsl:when>
											<xsl:when test="body='2'">
												<xsl:value-of select="$lng/notstored"/>
											</xsl:when>
											<xsl:otherwise>
												<a href="main.php?module=generic&amp;function=message&amp;id={id}">
													<xsl:value-of select="$lng/view"/>
												</a>
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="h2c t2">
										<xsl:choose>
											<xsl:when test="status='0'">
												<xsl:value-of select="$lng/deletedstatus"/>
											</xsl:when>
											<xsl:when test="status='1'">
												<xsl:value-of select="$lng/queued"/>
											</xsl:when>
											<xsl:when test="status='2'">
												<xsl:value-of select="$lng/sent"/>
												<br/>
												<xsl:choose>
													<xsl:when test="receipt_status='1'">
														<xsl:value-of select="$lng/messageunknown"/>
													</xsl:when>
													<xsl:when test="receipt_status='2'">
														<xsl:value-of select="$lng/messagequeue"/>
													</xsl:when>
													<xsl:when test="receipt_status='3'">
														<xsl:value-of select="$lng/deliveredgateway"/>
													</xsl:when>
													<xsl:when test="receipt_status='4'">
														<xsl:value-of select="$lng/recievedbyrecipient"/>
													</xsl:when>
													<xsl:when test="receipt_status='5'">
														<xsl:value-of select="$lng/errorwithmessage"/>
													</xsl:when>
													<xsl:when test="receipt_status='6'">
														<xsl:value-of select="$lng/usercanceledmessage"/>
													</xsl:when>
													<xsl:when test="receipt_status='7'">
														<xsl:value-of select="$lng/errordeliverymessage"/>
													</xsl:when>
													<xsl:when test="receipt_status='8'">
														<xsl:value-of select="$lng/okay"/>
													</xsl:when>
													<xsl:when test="receipt_status='9'">
														<xsl:value-of select="$lng/routingerror"/>
													</xsl:when>
													<xsl:when test="receipt_status='10'">
														<xsl:value-of select="$lng/messageexpired"/>
													</xsl:when>
													<xsl:when test="receipt_status='11'">
														<xsl:value-of select="$lng/messageqgateway"/>
													</xsl:when>
													<xsl:when test="receipt_status='12'">
														<xsl:value-of select="$lng/outofcredit"/>
													</xsl:when>
												</xsl:choose>
											</xsl:when>
											<xsl:when test="status='3'">
												<xsl:value-of select="$lng/failed"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$lng/unknown"/>
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="h2c t2">
								<xsl:if test="status='1'">
										<input type="checkbox" class="t2" name="messageselect[{id}]"/>
								</xsl:if>
									<br/>
									</td>					
							</tr>
							</xsl:for-each>
							<tr>
								<td><br/></td>
								<td class="h2b" colspan="8">
									<xsl:if test="$display &gt; 0">
										<a href="main.php?module=log&amp;function=message_log&amp;displaypage=0"><img src="./theme/{$theme}/icon/first.gif" border="0" alt="First" hspace="1" align="absmiddle"/></a>
										<xsl:variable name="previous" select="$display - 1"/>
										<a href="main.php?module=log&amp;function=message_log&amp;displaypage={$previous}"><img src="./theme/{$theme}/icon/left.gif" border="0" alt="Previous" hspace="1" align="absmiddle"/></a>
									</xsl:if>
									<xsl:call-template name="display_counter">
			        					<xsl:with-param name="counter" select="0"/>
			      					</xsl:call-template>
									<xsl:if test="$display &lt; $limit">
										<xsl:variable name="next" select="$display + 1"/>
										<a href="main.php?module=log&amp;function=message_log&amp;displaypage={$next}"><img src="./theme/{$theme}/icon/right.gif" border="0" alt="Next" hspace="1" align="absmiddle" /></a>
										<a href="main.php?module=log&amp;function=message_log&amp;displaypage={$limit}"><img src="./theme/{$theme}/icon/last.gif" border="0" alt="Last" hspace="1" align="absmiddle"/></a>
									</xsl:if>
								</td>

								<td class = "h2c t2" align = "right">
									<input type="submit" name="delete" class="t2">
										<xsl:attribute name="value">
									  		<xsl:value-of select="$lng/delete"/> 
									  	</xsl:attribute>
									</input>
								</td>
							</tr>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

<xsl:template name="display_counter">
	<xsl:param name="counter"/>
	<xsl:if test="$counter &lt; $limit">
		<xsl:choose>
			<xsl:when test="$counter = $display">
				<xsl:value-of select="$counter"/>
			</xsl:when>
			<xsl:otherwise>
				<a href="main.php?module=log&amp;function=message_log&amp;displaypage={$counter}"><b><xsl:value-of select="$counter"/></b></a>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="display_counter">
			<xsl:with-param name="counter" select="$counter + 1"/>
		</xsl:call-template>
		<xsl:value-of select='" "'/>
	</xsl:if>
</xsl:template>

</xsl:stylesheet>
