<?php
/**
* Menu frame settings
* @package TenderSystem
* @subpackage menu
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license TenderSystem Commercial License
* @version 
*/

// set the laguage folder
$xml = file_get_contents("modules/menu/language/".$language."/default.xml");

if ($menu == "top") {
	if ($_SESSION['ts_id']) {
		/**
		* Generate top top menu
		*/
		// calculator
		$name = event_parser('<calculator>','</calculator>',$xml);
		$menu_item['top'][] = array(
			'name'		=> $name,
			'module'	=> "calculator",
			'image'		=> "calculator",
			'frame'		=> "left"
		);
		// control panel
		$name = event_parser('<control>','</control>',$xml);
		$menu_item['top'][] = array(
			'name'		=> $name,
			'module'	=> "session",
			'function'	=> "login",
			'image'		=> "control",
			'frame'		=> "main"
		);
		// password
		$name = event_parser('<password>','</password>',$xml);
		$menu_item['top'][] = array(
			'name'		=> $name,
			'module'	=> "password",
			'function'	=> "change",
			'image'		=> "password",
			'frame'		=> "main"
		);
		// profile
		$name = event_parser('<profile>','</profile>',$xml);
		$menu_item['top'][] = array(
			'name'		=> $name,
			'module'	=> "user",
			'function'	=> "profile",
			'image'		=> "profile",
			'frame'		=> "main"
		);
		// help
		if ($cfg['help']) {
			$name = event_parser('<help>','</help>',$xml);
			$menu_item['top'][] = array(
				'name'		=> $name,
				'url'		=> $cfg['help'],
				'image'		=> "help",
				'frame'		=> "main"
			);
		}
		// faq
		if ($cfg['faq']) {
			$name = event_parser('<faq>','</faq>',$xml);
			$menu_item['top'][] = array(
				'name'		=> $name,
				'url'		=> $cfg['faq'],
				'image'		=> "faq",
				'frame'		=> "main"
			);
		}
		// logout
		$name = event_parser('<logout>','</logout>',$xml);
		$menu_item['top'][100] = array(
			'name'		=> $name,
			'module'	=> "session",
			'function'	=> "logout",
			'image'		=> "logout",
			'frame'		=> "main"
		);
		/**
		* Generate top middle menu
		*/
		if ($_SESSION['ts_classification'] == "1") {
			// administrator
			if ($_SESSION['ts_permission'] > "1") {
				// company admin
				$name = event_parser('<supplieradmin>','</supplieradmin>',$xml);
				$menu_item['middle'][] = array(
					'name'		=> $name,
					'module'	=> "organisation",
					'function'	=> "supplier",
					'frame'		=> "left"
				);
			}
			// report
			$name = event_parser('<report>','</report>',$xml);
			$menu_item['middle'][] = array(
				'name'		=> $name,
				'module'	=> "report",
				'function'	=> "supplier",
				'frame'		=> "main"
			);
		} elseif ($_SESSION['ts_classification'] == "2") { // subscriber
			// reports
			$name = event_parser('<reports>','</reports>',$xml);
			$menu_item['middle'][] = array(
				'name'		=> $name,
				'module'	=> "report",
				'function'	=> "company",
				'frame'		=> "main"
			);
			// administrator
			if ($_SESSION['ts_permission'] > "1") {
				// company admin
				$name = event_parser('<companyadmin>','</companyadmin>',$xml);
				$menu_item['second'][] = array(
					'name'		=> $name,
					'module'	=> "organisation",
					'function'	=> "company",
					'frame'		=> "left"
				);
			}
		} elseif ($_SESSION['ts_classification'] == "3") {
			// administrator
			// super
			if ($_SESSION['ts_permission'] == "2") {
				// settings
				$name = event_parser('<settings>','</settings>',$xml);
				$menu_item['second'][-100] = array(
					'name'		=> $name,
					'module'	=> "settings",
					'frame'		=> "left"
				);
			}
			// tender admin
			$name = event_parser('<tenderadmin>','</tenderadmin>',$xml);
			$menu_item['middle'][-99] = array(
				'name'		=> $name,
				'module'	=> "procure",
				'frame'		=> "left"
			);
			// company admin
			$name = event_parser('<companyadmin>','</companyadmin>',$xml);
			$menu_item['middle'][-98] = array(
				'name'		=> $name,
				'module'	=> "organisation",
				'function'	=> "company",
				'frame'		=> "left"
			);
			// supplier admin
			$name = event_parser('<supplieradmin>','</supplieradmin>',$xml);
			$menu_item['middle'][-97] = array(
				'name'		=> $name,
				'module'	=> "organisation",
				'function'	=> "supplier",
				'frame'		=> "left"
			);
			// category admin
			$name = event_parser('<categoryadmin>','</categoryadmin>',$xml);
			$menu_item['middle'][-96] = array(
				'name'		=> $name,
				'module'	=> "category",
				'frame'		=> "left"
			);
			// area admin
			$name = event_parser('<areaadmin>','</areaadmin>',$xml);
			$menu_item['middle'][-95] = array(
				'name'		=> $name,
				'module'	=> "area",
				'frame'		=> "left"
			);
			// utilities
			$name = event_parser('<utilities>','</utilities>',$xml);
			$menu_item['second'][-94] = array(
				'name'		=> $name,
				'module'	=> "utilities",
				'frame'		=> "left"
			);
		}
	} else {
		// login
		$name = event_parser('<login>','</login>',$xml);
		$menu_item['top'][100] = array(
			'name'		=> $name,
			'module'	=> "session",
			'function'	=> "login",
			'image'		=> "login",
			'frame'		=> "main"
		);
	}
}
?>