<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/clearcache"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'menu'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report" >
					<input type="hidden" name="module" value="languageeditor"/>
					<input type="hidden" name="function" value="create"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF" id="sitediv">
					<xsl:if test="files">
							<tr>
								<td class="h t1">
									<xsl:value-of select="$lng/removed"/>
								</td>
							</tr>
						<xsl:for-each select="files">
							<tr>
								<td class="t2">
									<xsl:value-of select="."/>
								</td>
							</tr>
						</xsl:for-each>
					</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<script type="text/javascript">
		function change(name) {
			document.report.name.value = name;
		}

		function select_change() {
			document.report.name.value = document.report.select.value;
		}
	</script>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
