<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer_left.xsl"/>

<!-- Template -->
<xsl:template match="/response">
	<html>
		<head>
			<title><xsl:value-of select="$lng/title"/></title>
			<link rel="stylesheet" type="text/css" href="./theme/{$theme}/menu.css"/>
			<style type="text/css">
				html, body {height: 98%; margin: 0; border: none; text-align: left; font-family: arial, helvetica, sans-serif;  font-size: 11px; color: #000066; white-space: nowrap;}
				#wrapper {height: 78%; background-color: #FFFFFF;}
			</style>
		</head>
		<body>
			<table id="wrapper" border="0" align="center" cellpadding="2" cellspacing="0" width="100">
				<tr>
					<td align="left" valign="top" width="100"><img align="top" src="./theme/{$theme}/img/left.gif" alt="TenderSystem"/></td>
				</tr>
				<xsl:value-of disable-output-escaping="yes" select="code"/>
			</table>
			<xsl:call-template name="footer_left"/>
		</body>
	</html>
</xsl:template>
</xsl:stylesheet>