<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer_left.xsl"/>

<!-- Template -->
<xsl:template match="/response">
	<html>
		<head>
			<title><xsl:value-of select="$lng/title"/></title>
			<link rel="stylesheet" type="text/css" href="./theme/{$theme}/menu.css"/>
			<style type="text/css">
				html, body {height: 98%; margin: 0; border: none; text-align: left; font-family: arial, helvetica, sans-serif;  font-size: 11px; color: #000066; white-space: nowrap;}
				#wrapper {height: 78%; background-color: #FFFFFF; align: left;}
			</style>
		</head>
		<body>
			<br/>
			<table id="wrapper" border="0" align="center" cellpadding="1" cellspacing="0" width="80">
				<tr>
					<td align="left" valign="top" width="80">
						<form enctype="multipart/form-data"    name="Keypad" action="">
							<table border="1" cellpadding="1" cellspacing="1">
								<tr>
									<td colspan="2" align="middle">
										<input name="ReadOut" type="Text" size="9" value="0" class="t1"/>
									</td>
									<td align="center">
										<input name="btnClear" type="Button" value=" C  " onclick="Clear()" class="t1"/>
									</td>
								</tr>
								<tr>
									<td align="center">
										<input name="btnSeven" type="Button" value="  7  " onclick="NumPressed(7)" class="t1"/>
									</td>
									<td align="center">
										<input name="btnEight" type="Button" value="  8  " onclick="NumPressed(8)" class="t1"/>
									</td>
									<td align="center">
										<input name="btnNine" type="Button" value="  9  " onclick="NumPressed(9)" class="t1"/>
									</td>
								</tr>
								<tr>
									<td align="center">
										<input name="btnFour" type="Button" value="  4  " onclick="NumPressed(4)" class="t1"/>
									</td>
									<td align="center">
										<input name="btnFive" type="Button" value="  5  " onclick="NumPressed(5)" class="t1"/>
									</td>
									<td align="center">
										<input name="btnSix" type="Button" value="  6  " onclick="NumPressed(6)" class="t1"/>
									</td>
								</tr>
								<tr>
									<td align="center">
										<input name="btnOne" type="Button" value="  1  " onclick="NumPressed(1)" class="t1"/>
									</td>
									<td align="center">
										<input name="btnTwo" type="Button" value="  2  " onclick="NumPressed(2)" class="t1"/>
									</td>
									<td align="center">
										<input name="btnThree" type="Button" value="  3  " onclick="NumPressed(3)" class="t1"/>
									</td>
								</tr>
								<tr>
									<td align="center">
										<input name="btnDecimal" type="Button" value="  .  " onclick="Decimal()" class="t1"/>
									</td>
									<td align="center">
										<input name="btnZero" type="Button" value="  0  " onclick="NumPressed(0)" class="t1"/>
									</td>
									<td align="center">
										<input name="btnEquals" type="Button" value="  =  " onclick="Operation('=')" class="t1"/>
									</td>
								</tr>
								<tr>
									<td align="center">
										<input name="btnPlus" type="Button" value="  +  " onclick="Operation('+')" class="t1"/>
									</td>
									<td align="center">
										<input name="btnMinus" type="Button" value="  -  " onclick="Operation('-')" class="t1"/>
									</td>
									<td align="center">
										<input name="btnMultiply" type="Button" value="  *  " onclick="Operation('*')" class="t1"/>
									</td>
								</tr>
								<tr>
									<td align="center">
										<input name="btnPercent" type="Button" value="  %  " onclick="Percent()" class="t1"/>
									</td>
									<td align="center">
										<input name="btnNeg" type="Button" value=" +/- " onclick="Neg()" class="t1"/>
									</td>
									<td align="center">
										<input name="btnDivide" type="Button" value="  /  " onclick="Operation('/')" class="t1"/>
									</td>
								</tr>
							</table>
							<!-- <a HREF="http://javascriptsource.com">Thc JavaScript Source</a> -->
						</form>
					</td>
				</tr>
			</table>
			<xsl:call-template name="footer_left"/>
<!--  Original:  http://www.dummyproof.com/javascripts -->
<!-- This script and many more are available free online at -->
<!-- Thc JavaScript Source!! http://javascript.internet.com -->
<SCRIPT LANGUAGE="JavaScript">
var FKeyPad = document.Keypad;
var Accum = 0;
var FlagNewNum = false;
var PendingOp = "";
function NumPressed (Num) {
if (FlagNewNum) {
FKeyPad.ReadOut.value  = Num;
FlagNewNum = false;
   }
else {
if (FKeyPad.ReadOut.value == "0")
FKeyPad.ReadOut.value = Num;
else
FKeyPad.ReadOut.value += Num;
   }
}
function Operation (Op) {
var Readout = FKeyPad.ReadOut.value;
if (FlagNewNum &amp;&amp; PendingOp != "=");
else
{
FlagNewNum = true;
if ( '+' == PendingOp )
Accum += parseFloat(Readout);
else if ( '-' == PendingOp )
Accum -= parseFloat(Readout);
else if ( '/' == PendingOp )
Accum /= parseFloat(Readout);
else if ( '*' == PendingOp )
Accum *= parseFloat(Readout);
else
Accum = parseFloat(Readout);
FKeyPad.ReadOut.value = Accum;
PendingOp = Op;
   }
}
function Decimal () {
var curReadOut = FKeyPad.ReadOut.value;
if (FlagNewNum) {
curReadOut = "0.";
FlagNewNum = false;
   }
else
{
if (curReadOut.indexOf(".") == -1)
curReadOut += ".";
   }
FKeyPad.ReadOut.value = curReadOut;
}
function ClearEntry () {
FKeyPad.ReadOut.value = "0";
FlagNewNum = true;
}
function Clear () {
Accum = 0;
PendingOp = "";
ClearEntry();
}
function Neg () {
FKeyPad.ReadOut.value = parseFloat(FKeyPad.ReadOut.value) * -1;
}
function Percent () {
FKeyPad.ReadOut.value = (parseFloat(FKeyPad.ReadOut.value) / 100) * parseFloat(Accum);
}
</SCRIPT>
		</body>
	</html>
</xsl:template>
</xsl:stylesheet>