<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>

<!-- Template -->
<xsl:template match="/response">
<html>
	<head>
		<META http-equiv="Pragma" content="no-cache"/>
		<title><xsl:value-of select="$lng/menu"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/menu.css"/>
	</head>
<body>
	
	<div id="menu">
		<h1><a href="main.php?module=session&amp;function=login" title="TenderSystem" target="main"><img src="./theme/{$theme}/img/logo.gif" alt="Insert Logo" border="0"/></a></h1>
		<div>
			<sub>
	<xsl:if test="top">
		<!-- top -->
		<xsl:for-each select="top">
			<xsl:if test="module">
				<a href="./{frame}.php?module={module}&amp;function={function}" target="{frame}">
					<img src="./theme/{$theme}/icon/{image}.gif" hspace="8" align="absmiddle" border="0"/>
					<xsl:value-of select="name"/>
				</a>
			</xsl:if>
			<xsl:if test="url">
				<a href="{url}" target="{frame}">
					<img src="./theme/{$theme}/icon/{image}.gif" hspace="8" align="absmiddle" border="0"/>
				<xsl:value-of select="name"/>
			</a>
			</xsl:if>
		</xsl:for-each>
	</xsl:if>
			</sub>
		</div>
<xsl:if test="second">
	<!-- second -->
	<div style="width: 100%; position: absolute; top: 64px; right: 0; margin: 0; padding: 0 15px 0 0; list-style: none;">
		<ul>
		<xsl:for-each select="second">
			<xsl:if test="frame and module">
				<li>
					<a href="./{frame}.php?module={module}&amp;function={function}" target="{frame}">
						<xsl:value-of select="name"/>
					</a>
				</li>
			</xsl:if>
		</xsl:for-each>
		</ul>
	</div>
</xsl:if>
		<ul>
	<xsl:if test="middle">
		<!-- middle -->
		<xsl:for-each select="middle">
			<xsl:if test="frame and module">
				<li>
					<a href="./{frame}.php?module={module}&amp;function={function}" target="{frame}">
						<xsl:value-of select="name"/>
					</a>
				</li>
			</xsl:if>
		</xsl:for-each>
	</xsl:if>
		</ul>
	</div>
	<div id="h2">
		<div id="submenu">
	<xsl:if test="bottom">
		<!-- bottom -->
		<xsl:for-each select="bottom">
				<a href="./{frame}.php?module={module}&amp;function={function}" target="{frame}">
					<xsl:value-of select="name"/>
				</a>
				<xsl:value-of select="' '"/>|<xsl:value-of select="' '"/>
		</xsl:for-each>
	</xsl:if>
		</div>
	</div>
</body>
</html>
</xsl:template>
</xsl:stylesheet>