<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/messenger"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'messenger'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="messenger"/>
					<input type="hidden" name="function" value="message"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="users">
							<tr>
								<td align="left" class="h t1" colspan="4">
									<xsl:value-of select="$lng/messageinfo"/>
								</td>
							</tr>
							<tr>
								<td align="left" class="h1b t1">
									<xsl:value-of select="$lng/fullname"/>
								</td>
								<td align="left" class="h1c t1">
									<xsl:value-of select="$lng/exclude"/>
								</td>
								<td align="left" class="h1c t1">
									<xsl:value-of select="$lng/fullname"/>
								</td>
								<td align="left" class="h1c t1">
									<xsl:value-of select="$lng/exclude"/>
								</td>
							</tr>
							<xsl:for-each select="users[position() mod 2 = 1]">
								<tr>
									<xsl:for-each select=".|following-sibling::users[position() &lt; 2]">
										<td align="left">
											<xsl:choose>
												<xsl:when test="position()=1">
													<xsl:attribute name="class">h2b t2</xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="class">h2c t2</xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
											<a target="main">
												<xsl:attribute name="href">
													<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',usersid)"/>
												</xsl:attribute>
												<xsl:value-of select="name"/>
												<xsl:value-of select="' '"/>
												<xsl:value-of select="surname"/>
											</a>
											<input type="hidden" name="users[]" value="{usersid}"/>
										</td>
										<td align="left" class="h2c t2">
											<input type="checkbox" name="exclude[]" value="{usersid}"/>
										</td>
										<xsl:if test="position() = last() and last() != 2">
											<td align="left" class="h2c t2"><br/></td>
											<td align="left" class="h2c t2"><br/></td>
										</xsl:if>
									</xsl:for-each>
								</tr>
							</xsl:for-each>
							<tr>
								<td align="left" class="h1b t1">
									<xsl:value-of select="$lng/subject"/>
								</td>
								<td align="left" class="h1c t2" colspan="3">
									<input type="text" class="t2" name="subject" size="50" value="{$lng/subject}"/>
								</td>
							</tr>
							<tr>
								<td align="left" class="h1b t1" rowspan="4" valign="top">
									<xsl:value-of select="$lng/message"/>
								</td>
								<td align="left" class="h1c t1" colspan="3">
									<a href="#" onclick="add_tag('name')"><xsl:value-of select="$lng/name"/></a>
									<xsl:value-of select="' '"/>
									<a href="#" onclick="add_tag('surname')"><xsl:value-of select="$lng/surname"/></a>
									<xsl:value-of select="' '"/>
									<a href="#" onclick="add_tag('company')"><xsl:value-of select="$lng/company"/></a>
									<xsl:value-of select="' '"/>
									<a href="#" onclick="add_tag('branch')"><xsl:value-of select="$lng/branch"/></a>
									<xsl:value-of select="' '"/>
									<a href="#" onclick="add_tag('phonework')"><xsl:value-of select="$lng/phonework"/></a>
									<xsl:value-of select="' '"/>
									<a href="#" onclick="add_tag('phonefax')"><xsl:value-of select="$lng/phonefax"/></a>
									<xsl:value-of select="' '"/>
									<a href="#" onclick="add_tag('phonemobile')"><xsl:value-of select="$lng/phonemobile"/></a>
									<xsl:value-of select="' '"/>
									<a href="#" onclick="add_tag('email')"><xsl:value-of select="$lng/email"/></a>
								</td>
							</tr>
							<tr>
								<td align="left" class="h1c t1" colspan="3">
									<xsl:value-of select="$lng/text"/>
									<input type="text" name="special" class="t2"/><br/>
									<input type="checkbox" name="bold"/>
									<xsl:value-of select="$lng/bold"/>
									<input type="checkbox" name="italics"/>
									<xsl:value-of select="$lng/italics"/>
									<input type="checkbox" name="underline"/>
									<xsl:value-of select="$lng/underline"/>
									<input type="checkbox" name="br"/>
									<xsl:value-of select="'BR'"/>
									<xsl:value-of select="' '"/>
									<a href="#" onclick="add_special(type)"><xsl:value-of select="$lng/add"/></a>
								</td>
							</tr>
							<tr>
								<td align="left" class="h1c t1" colspan="3">
									<xsl:value-of select="'http://'"/>
									<input type="url" name="url" class="t2"/>
									<a href="#" onclick="add_special('addurl')"><xsl:value-of select="$lng/addurl"/></a>
								</td>
							</tr>
							<tr>
								<td align="left" class="h1c t1" colspan="3">
									<textarea name="body" rows="10" cols="45" class="t2">
									</textarea>
								</td>
							</tr>
							<tr>
								<td align="right" colspan="4">
									<input type="submit" name="action[email]" class="t2">
										<xsl:attribute name="value">
											<xsl:value-of select="$lng/sendemail"/>
										</xsl:attribute>
									</input>
									<input type="submit" name="action[sms]" class="t2">
										<xsl:attribute name="value">
											<xsl:value-of select="$lng/sendsms"/>
										</xsl:attribute>
									</input>
									<input type="submit" name="action[prefer]" class="t2">
										<xsl:attribute name="value">
											<xsl:value-of select="$lng/sendprefer"/>
										</xsl:attribute>
									</input>
								</td>
							</tr>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
		<div id="right">
			<div id="right_header">
				<xsl:value-of select="$lng/sendmessage"/>
			</div>
			<div id="right_content">
				<xsl:for-each select="$lng/messinst">
					<xsl:value-of select="."/><br/>
				</xsl:for-each>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function add_tag(tag) {
			document.report.body.value = document.report.body.value + "[" + tag + "/]";
		}

		function add_special(type) {
			var text = document.report.special.value;
			var url = document.report.url.value;
			if(document.report.bold.checked) {
				text = "[b]" + text + "[/b]";
			}
			if(document.report.italics.checked) {
				text = "[i]" + text + "[/i]";
			}
			if(document.report.underline.checked) {
				text = "[u]" + text + "[/u]";
			}
			if(document.report.br.checked) {
				text = "[br/]";
			}
			if(type == "addurl") {
				text = "[a href=|http://"+url+"|]" + text + "[/a]";
			}
			document.report.body.value = document.report.body.value + text;
		}
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
