<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/messenger"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'messenger'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="messenger"/>
					<input type="hidden" name="function" value="utilities"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="sent">
							<tr>
								<td align="left" class="h t1" colspan="4">
									<xsl:value-of select="$lng/messagesent"/>
								</td>
							</tr>
							<tr>
								<td align="left" class="t1"><xsl:value-of select="$lng/name"/></td>
								<td align="left" class="t1"><xsl:value-of select="$lng/method"/></td>
								<td align="left" class="t1"><xsl:value-of select="$lng/address"/></td>
								<td align="left" class="t1"><xsl:value-of select="$lng/status"/></td>
							</tr>
							<xsl:for-each select="sent">
								<tr>
									<td align="left" class="t">
										<xsl:value-of select="name"/>
									</td>
									<td align="left" class="t">
										<xsl:if test="method='email'">
											<xsl:value-of select="$lng/email"/>
										</xsl:if>
										<xsl:if test="method='sms'">
											<xsl:value-of select="$lng/sms"/>
										</xsl:if>
									</td>
									<td align="left" class="t">
										<xsl:value-of select="address"/>
									</td>
								<xsl:choose>
									<xsl:when test="status='2'">
										<td align="left" class="t">
											<xsl:value-of select="$lng/success"/>
										</td>
									</xsl:when>
									<xsl:when test="status='1'">
										<td align="left" class="t">
											<xsl:value-of select="$lng/scheduled"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td align="left" class="t">
											<xsl:value-of select="$lng/error"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
								</tr>
							</xsl:for-each>
								<tr>
									<td colspan="4"><br/></td>
								</tr>
						</xsl:if>
						<xsl:if test="organisation/organisationid">
							<tr>
								<td align="left" class="h t1" colspan="4">
									<xsl:value-of select="$lng/messageget"/>
								</td>
							</tr>
							<tr>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/organisation"/>
								</td>
								<td align="left" class="t2" colspan="3">
									<select name="organisation" class="t2" onchange="update_branch()">
										<option value="all"><xsl:value-of select="$lng/all"/></option>
										<xsl:for-each select="organisation">
											<option value="{organisationid}"><xsl:value-of select="organisationname"/></option>
										</xsl:for-each>
									</select>
								</td>
							</tr>
							<tr>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/branch"/>
								</td>
								<td align="left" class="t2" colspan="3">
									<select name="branch" class="t2">
										<option value="all"><xsl:value-of select="$lng/all"/></option>
										<xsl:for-each select="branch">
											<option value="{branchid}"><xsl:value-of select="branchname"/></option>
										</xsl:for-each>
									</select>
								</td>
							</tr>
							<tr>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/usertype"/>
								</td>
								<td align="left" class="t2" colspan="3">
									<input type="radio" name="classification" value="all" checked=""/>
									<xsl:value-of select="$lng/all"/>
									<input type="radio" name="classification" value="1"/>
									<xsl:value-of select="$lng/agent"/>
									<input type="radio" name="classification" value="2"/>
									<xsl:value-of select="$lng/subscriber"/>
									<input type="radio" name="classification" value="3"/>
									<xsl:value-of select="$lng/admin"/>
								</td>
							</tr>
							<tr>
								<td align="right" colspan="4">
									<input type="submit" name="action" class="t2">
										<xsl:attribute name="value">
											<xsl:value-of select="$lng/sendmessage"/>
										</xsl:attribute>
									</input>
								</td>
							</tr>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
		<div id="right">
			<div id="right_header">
				<xsl:value-of select="$lng/sendmessage"/>
			</div>
			<div id="right_content">
				<xsl:for-each select="$lng/inst">
					<xsl:value-of select="."/><br/>
				</xsl:for-each>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script language="javascript">
		<xsl:if test="branch/branchid">
			function update_branch() {	
					var orgvalue = document.report.organisation.value;
					var branchselect = document.report.branch;
					var branchoptions = branchselect.options;
					var counter = 0;
					
					branchselect.length = 0;
					branchoptions[counter++] = new Option("<xsl:value-of select="$lng/all"/>","all");
					<xsl:for-each select="branch">
						if (orgvalue == "<xsl:value-of select="branchid"/>" || orgvalue == "all") {
							branchoptions[counter++] = new Option("<xsl:value-of select="branchname"/>","<xsl:value-of select="branchid"/>");
						}
					</xsl:for-each>
					if(counter == 1) {
						branchselect.disabled=1;
					} else {
						branchselect.disabled=0;
					}
				
			}
		</xsl:if>
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
