<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Create organisation
* @package TenderSystem
* @subpackage organisation
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type 
$fields_request = array (
	'createorg'	=> array()		
);
get_request($fields_request,$action,$error,$cfg);
if($action['createorg']) {
	// field request errors and type 
	$fields_request = array (
		'organisationname'			=> array("e8",	REQUEST_ANY,		FORMAT_NONE),
		'registered_name'			=> array("e7",	REQUEST_ANY,		FORMAT_NONE),
		'classification'			=> array("e9",	REQUEST_NUMBER,		FORMAT_NONE,		"e40"),
		'transaction_fee'			=> array("e1",	REQUEST_PERCENTAGE,	FORMAT_NONE,		"e41"),
		'transaction_min'			=> array("e2",	REQUEST_MONEY,		FORMAT_MONEY,		"e42"),
		'vat_number'				=> array("e5"),
		'registration_number'		=> array("e6"),
		'user_fee'					=> array("e4",	REQUEST_MONEY,		FORMAT_MONEY,		"e43"),
		'sms_fee'					=> array("e3",	REQUEST_MONEY,		FORMAT_MONEY,		"e44"),
		'repusername'				=> array("e10",	REQUEST_USERNAME,	FORMAT_USERNAME,	"e45"),
		'repname'					=> array("e11",	REQUEST_ANY,		FORMAT_UCWORDS),
		'repsurname'				=> array("e12",	REQUEST_ANY,		FORMAT_UCWORDS),
		'repphone_work'				=> array("e13",	REQUEST_PHONE,		FORMAT_PHONE,		"e46"),
		'repphone_prefix'			=> array("e14",	REQUEST_NUMBER,		FORMAT_NONE,		"e47"),
		'repphone_fax'				=> array("e15",	REQUEST_PHONE,		FORMAT_PHONE,		"e48"),
		'repphone_mobile'			=> array("e16",	REQUEST_PHONE,		FORMAT_PHONE,		"e49"),
		'repemail'					=> array("e17",	REQUEST_EMAIL,		FORMAT_NONE,		"e50"),
		'reppreference'				=> array("e18",	REQUEST_CHAR,		FORMAT_NONE,		"e51"),
		'reppermission'				=> array("e20",	REQUEST_NUMBER,		FORMAT_NONE,		"e52"),
		'reptheme'					=> array("e21",	REQUEST_THEME,		FORMAT_NONE,		"e53"),
		'replang'					=> array("e22",	REQUEST_LANG,		FORMAT_NONE,		"e54"),
		'repposition'				=> array("e23",	REQUEST_ANY,		FORMAT_UCWORDS),
		'repmandate'				=> array(),
		'repdate_of_birth'			=> array(),
		'repskype'					=> array(),
		'repinstant_messager'		=> array(),
		'repim_contact'				=> array(),
		'branchname'				=> array("e24"),
		'branchphone_work'			=> array("e25",	REQUEST_PHONE,		FORMAT_PHONE,		"e55"),
		'branchphone_fax'			=> array("e27",	REQUEST_PHONE,		FORMAT_PHONE,		"e57"),
		'branchphone_prefix'		=> array("e26",	REQUEST_NUMBER,		FORMAT_NONE,		"e56"),
		'branchemail'				=> array("e28",	REQUEST_EMAIL,		FORMAT_NONE,		"e58"),
		'branchcomment'				=> array(""),
		'primary_address_street'	=> array("e30"),
		'primary_address_city'		=> array("e31",	REQUEST_ANY,		FORMAT_UCWORDS),
		'primary_address_state'		=> array("e32",	REQUEST_ANY,		FORMAT_UCWORDS),
		'primary_address_postalcode'=> array("e33"),
		'address_country'			=> array("e34",	REQUEST_ANY,		FORMAT_UCWORDS),
		'alt_address_street'		=> array("e35"),
		'alt_address_city'			=> array("e36",	REQUEST_ANY,		FORMAT_UCWORDS),
		'alt_address_state'			=> array("e37",	REQUEST_ANY,		FORMAT_UCWORDS),
		'alt_address_postalcode'	=> array("e38"),
		'rating'					=> array("e39",	REQUEST_CHAR,		FORMAT_UCWORDS,		"e59")
	);
	// get the themes
	$params['theme'] = get_themes();
	// get the languages
	$params['language'] = get_languages();
	// get data
	if(get_request($fields_request,$currentinfo[0],$error,$cfg)) {
		$params['module'] = "organisation";
		$params['function'] = "create";
		$params['currentinfo'] = $currentinfo;
		$params['classification'] = $currentinfo[0]['classification'];
		// send the message to app
		send_message($params,$cfg);
	} else {
		$params['currentinfo'] = $currentinfo;
		$params['classification'] = $currentinfo[0]['classification'];
		xml_generator("organisation","create",$error,$params,$cfg);	
	}
} else {
	$type = sanitise($_REQUEST['classification']);
	$info[] = array (
		'transaction_fee'	=> "0.00",
		'transaction_min'	=> "0.00",
		'user_fee'			=> "0.00",
		'sms_fee'			=> "0.00",
		'repmandate'		=> "0.00",
		'repposition'		=> "Admin",
		'rating'			=> "E",
		'reptheme'			=> $cfg['theme'],
		'replanguage'		=> $cfg['language']
	);
	$params = array(
		'classification'	=> $type,
		'currentinfo'		=> $info
	);
	// get the themes
	$params['theme'] = get_themes();
	// get the languages
	$params['language'] = get_languages();
	xml_generator("organisation","create","",$params,$cfg);
}
?>