<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/companypanel"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'organisation'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="organisation"/>
					<input type="hidden" name="function" value="company_link"/>
					<input type="hidden" name="organisationid" value="{organisationid}"/>
					<input type="hidden" name="organisationcount" value="{organisationcount}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF" id="sitediv">
						<tr>
							<td colspan="3" class="t1">
								<xsl:if test="updated='1'">
									<xsl:value-of select="$lng/updated"/>
								</xsl:if>
							</td>
						</tr>
					<xsl:if test="needarea='1'">
						<tr>
							<td colspan="4" class="e">
								<xsl:value-of select="$lng/remember"/> : 
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=organisation&amp;function=show_area&amp;organisationid=',organisationid)"/>
									</xsl:attribute>
									<xsl:value-of select="$lng/needarea"/>
								</a>
							</td>
						</tr>
					</xsl:if>
				<xsl:if test="reminder">
					<xsl:for-each select="reminder">
						<tr>
							<td colspan="4" class="e">
								<xsl:value-of select="prename"/> : 
								<a target="main" href="{frame}.php?module={module}&amp;function={function}&amp;organisationid={../organisationinfo/organisationid}">
									<xsl:value-of select="name"/>
								</a>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:if>
						<tr>
							<td class="h t1">
								<xsl:value-of select="$lng/organisationname"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/status"/>
							</td>
							<td class="ha t1">
								<input type="checkbox" class="t2" id="site" name="checkall" onchange="CheckAll(this)"/>
								<xsl:value-of select="$lng/check"/>
							</td>
						</tr>
						<xsl:for-each select="organisation">
								<xsl:variable name="currentid" select="organisationid"/>
								<tr>
									<td class="h2b t2">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',organisationid)"/>
											</xsl:attribute>
											<xsl:value-of select="organisationname"/>
										</a>
									</td>
									<td class="h2c t2">
										<xsl:choose>
											<xsl:when test="status='1'">
												<xsl:value-of select="$lng/active"/>
											</xsl:when>
											<xsl:when test="status='0'">
												<xsl:value-of select="$lng/deleted"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$lng/unknown"/>
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="h2c t1">
										<input type="checkbox" class="t2" name="link[{organisationid}]">
											<xsl:for-each select="../selectedorganisation">
												<xsl:if test="organisationid=$currentid">
													<xsl:attribute name="checked">checked</xsl:attribute>
												</xsl:if>
											</xsl:for-each> 
										</input>
									</td>
								</tr>
							</xsl:for-each>
							<tr>
								<td class="t1" align="right" colspan="3">
									<input type="submit" name="change" class="t2">
										<xsl:attribute name="value"><xsl:value-of select="$lng/changeorgs"/></xsl:attribute>
									</input>
									<xsl:value-of select="' '"/>
									<input type="submit" name="reset" class="t2">
										<xsl:attribute name="value">
											<xsl:value-of select="$lng/reset"/>
										</xsl:attribute>
									</input>
								</td>
							</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/tenderorgtitle"/>
				</div>
				<div id="right_content">
					<xsl:value-of select="$lng/tenderorginst"/>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function CheckAll(parent) {
			var allChildren = document.getElementById(parent.id+'div').getElementsByTagName("input");
			for (var i = 0; i &lt; allChildren.length; i++) {
				allChildren[i].checked = parent.checked;
			}
		}
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
