<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../generic/templates/countries.xsl"/>
<xsl:include href="../../generic/templates/languages.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/createorg"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
		<link rel="stylesheet" type="text/css" media="all" href="./theme/{$theme}/style_calendar.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:choose>
				<xsl:when test="classifcation='3'">
					<xsl:value-of select="$lng/createadminorg"/>
				</xsl:when>
				<xsl:when test="classifcation='2'">
					<xsl:value-of select="$lng/createcompany"/>
				</xsl:when>
				<xsl:when test="classifcation='1'">
					<xsl:value-of select="$lng/createsupplier"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$lng/createorg"/>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'organisation'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="organisation"/>
					<input type="hidden" name="function" value="create"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td colspan="4" class="h t1">
								<xsl:choose>
									<xsl:when test="classification='1'">
										<xsl:value-of select="$lng/supplierinfo"/>
									</xsl:when>
									<xsl:when test="classification='2'">
										<xsl:value-of select="$lng/companyinfo"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/orginfo"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/name"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/tradingas"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="organisationname" class="t2" value="{currentinfo/organisationname}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/registeredname"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="registered_name" class="t2" value="{currentinfo/registered_name}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/type"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:choose>
									<xsl:when test="classification='3'">
										<xsl:value-of select="$lng/admin"/>
										<input type="hidden" name="classification" value="3"/>
									</xsl:when>
									<xsl:when test="classification='1'">
										<xsl:value-of select="$lng/supplier"/>
										<input type="hidden" name="classification" value="1"/>
									</xsl:when>
									<xsl:when test="classification='2'">
										<xsl:value-of select="$lng/user"/>
										<input type="hidden" name="classification" value="2"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/unknown"/>
										<input type="hidden" name="classification" value="2"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/transaction_fee"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="transaction_fee" class="t2" value="{currentinfo/transaction_fee}" size="8"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/transaction_min"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="localprecurrency"/><input type="text" name="transaction_min" class="t2" value="{currentinfo/transaction_min}" size="7"/><xsl:value-of select="localpostcurrency"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/user_fee"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="localprecurrency"/><input type="text" name="user_fee" class="t2" value="{currentinfo/user_fee}" size="7"/><xsl:value-of select="localpostcurrency"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/sms_fee"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="localprecurrency"/><input type="text" name="sms_fee" class="t2" value="{currentinfo/sms_fee}" size="7"/><xsl:value-of select="localpostcurrency"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/vat_number"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="vat_number" class="t2" value="{currentinfo/vat_number}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/registration_number"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="registration_number" class="t2" value="{currentinfo/registration_number}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/rating"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<select name="rating" class="t2">
									<option value="A">
										<xsl:value-of select="$lng/rating_a"/>
									</option>
									<option value="B">
										<xsl:if test="currentinfo/rating='B'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/rating_b"/>
									</option>
									<option value="C">
										<xsl:if test="currentinfo/rating='C'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/rating_c"/>
									</option>
									<option value="D">
										<xsl:if test="currentinfo/rating='D'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/rating_d"/>
									</option>
									<option value="E">
										<xsl:if test="currentinfo/rating='E'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/rating_e"/>
									</option>
								</select>
							</td>
						</tr>
						<tr>
							<td colspan="4" class="h t1">
								<xsl:value-of select="$lng/rep"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="$lng/info"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/name"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="repname" class="t2" value="{currentinfo/repname}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/surname"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="repsurname" class="t2" value="{currentinfo/repsurname}" onchange="update_username()"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/username"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="repusername" class="t2" value="{currentinfo/repusername}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/phoneprefix"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:call-template name="countries">
									<xsl:with-param name="selectname" select="'repphone_prefix'"/>
									<xsl:with-param name="message" select="$lng/dialcode"/>
									<xsl:with-param name="optionvalue" select="'dialcode'"/>
									<xsl:with-param name="optioncontent" select="'all'"/>
									<xsl:with-param name="optionselected" select="currentinfo/repphone_prefix"/>
									<xsl:with-param name="onchange" select="'change_selected(address_country,branchphone_prefix,repphone_prefix)'"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/phonework"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="repphone_work" class="t2" value="{currentinfo/repphone_work}" onchange="change_other(branchphone_work,repphone_work)"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/phonefax"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="repphone_fax" class="t2" value="{currentinfo/repphone_fax}" onchange="change_other(branchphone_fax,repphone_fax)"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/phonemobile"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="repphone_mobile" class="t2" value="{currentinfo/repphone_mobile}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/email"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="repemail" class="t2" value="{currentinfo/repemail}" onchange="change_other(branchemail,repemail)"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/notification"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<select name="reppreference" class="t2">
									<option value="m">
										<xsl:value-of select="$lng/emailn"/>
									</option>
									<option value="n">
										<xsl:if test="currentinfo/reppreference='n'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/email_sms"/>
									</option>
									<option value="0">
										<xsl:if test="currentinfo/reppreference='0'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/none"/>
									</option>
								</select>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/permlevel"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<select name="reppermission" class="t2">
						<xsl:choose>
							<xsl:when test="classification='2'">
									<option value="4">
										<xsl:value-of select="$lng/orglevel"/>
									</option>
									<option value="2">
										<xsl:if test="currentinfo/reppermission='2'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/branchlevel"/>
									</option>
									<option value="1">
										<xsl:if test="currentinfo/reppermission='1'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/normallevel"/>
									</option>
							</xsl:when>
							<xsl:otherwise>
									<option value="2">
										<xsl:if test="currentinfo/reppermission='2'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/superlevel"/>
									</option>
									<option value="1">
										<xsl:if test="currentinfo/reppermission='1'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/normallevel"/>
									</option>
							</xsl:otherwise>
						</xsl:choose>				
								</select>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/dateofbirth"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="repdate_of_birth" id="date_of_birth" class="t2" value="{currentinfo/repdate_of_birth}" size="10"/>
							</td>
							<td align="right" class="t2">
								<img src="./theme/{$theme}/icon/calendar.gif" id="trigger_date_of_birth" style="cursor: pointer; border: 0px;" alt="Date selector" />
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/skype"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="repskype" class="t2" value="{currentinfo/repskype}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/instantmessager"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<select name="repinstant_messager" class="t2">
									<option value="YAHOO">
										<xsl:if test="currentinfo/repinstant_messager='YAHOO'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/yahoomessager"/>
									</option>
									<option value="ICQ">
										<xsl:if test="currentinfo/repinstant_messager='ICQ'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/icqmessager"/>
									</option>
									<option value="MSN">
										<xsl:if test="currentinfo/repinstant_messager='MSN'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/msnmessager"/>
									</option>
									<option value="GOOGLE">
										<xsl:if test="currentinfo/repinstant_messager='GOOGLE'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/googletalk"/>
									</option>
								</select>
								<input type="text" name="repim_contact" class="t2" value="{currentinfo/repim_contact}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/theme"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<select name="reptheme" class="t2">
							<xsl:for-each select="theme">
								<xsl:variable name="theme" select="."/>
									<option value="{$theme}">
										<xsl:if test="$theme=../currentinfo/reptheme">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$theme"/>
									</option>
								</xsl:for-each>
								</select>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/language"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<select name="replang" class="t2">
								<xsl:for-each select="language">
									<xsl:variable name="selectlang" select="."/>
									<option value="{$selectlang}">
										<xsl:if test="$selectlang=../currentinfo/replang">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:call-template name="language_value">
											<xsl:with-param name="iso" select="$selectlang"/>
										</xsl:call-template>
									</option>
								</xsl:for-each>
								</select>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/rep"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="$lng/position"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="repposition" class="t2" value="{currentinfo/repposition}" />
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/mandate"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="localprecurrency"/><input type="text" name="repmandate" class="t2" value="{currentinfo/repmandate}" size="7"/><xsl:value-of select="localpostcurrency"/>
							</td>
						</tr>
						<tr>
							<td colspan="4" class="h t1">
								<xsl:value-of select="$lng/branchinfo"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/name"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="branchname" class="t2" value="{currentinfo/branchname}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/phoneprefix"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:call-template name="countries">
									<xsl:with-param name="selectname" select="'branchphone_prefix'"/>
									<xsl:with-param name="message" select="$lng/dialcode"/>
									<xsl:with-param name="optionvalue" select="'dialcode'"/>
									<xsl:with-param name="optioncontent" select="'all'"/>
									<xsl:with-param name="optionselected" select="currentinfo/branchphone_prefix"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/phonework"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="branchphone_work" class="t2" value="{currentinfo/branchphone_work}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/phonefax"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="branchphone_fax" class="t2" value="{currentinfo/branchphone_fax}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/email"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="branchemail" class="t2" value="{currentinfo/branchemail}"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/comment"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<textarea class="t2" name="branchcomment">
									<xsl:value-of select="$lng/none"/>
								</textarea>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/country"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:call-template name="countries">
									<xsl:with-param name="selectname" select="'address_country'"/>
									<xsl:with-param name="message" select="$lng/selectcountry"/>
									<xsl:with-param name="optionvalue" select="'name'"/>
									<xsl:with-param name="optioncontent" select="'name'"/>
									<xsl:with-param name="optionselected" select="currentinfo/address_country"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td colspan="3" class="h1 t1">
								<xsl:value-of select="$lng/primaryaddress"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/street"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="primary_address_street" class="t2" value="{currentinfo/primary_address_street}" onchange="change_other(alt_address_street,primary_address_street)"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/city"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="primary_address_city" class="t2" value="{currentinfo/primary_address_city}" onchange="change_other(alt_address_city,primary_address_city)"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/state"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="primary_address_state" class="t2" value="{currentinfo/primary_address_state}" onchange="change_other(alt_address_state,primary_address_state)"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/postalcode"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="primary_address_postalcode" class="t2" value="{currentinfo/primary_address_postalcode}" onchange="change_other(alt_address_postalcode,primary_address_postalcode)"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td colspan="3" class="h1 t1">
								<xsl:value-of select="$lng/alternativeaddress"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/street"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="alt_address_street" class="t2" value="{currentinfo/alt_address_street}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/city"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="alt_address_city" class="t2" value="{currentinfo/alt_address_city}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/state"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="alt_address_state" class="t2" value="{currentinfo/alt_address_state}"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/postalcode"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="alt_address_postalcode" class="t2" value="{currentinfo/alt_address_postalcode}"/>
							</td>
						</tr>
						<tr>
							<td class="t1" align="right" colspan="4">
								<input type="submit" name="createorg" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/createorg"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/creatingorg"/>
				</div>
				<div id="right_content">
					<xsl:value-of select="$lng/fillinfo"/>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript" src="./modules/external/javascript/calendar/calendar.js"></script>
	<script type="text/javascript" src="./modules/external/language/{$language}/calendar.js"></script>
	<script type="text/javascript" src="./modules/external/javascript/calendar/calendar-setup.js"></script>
	
	<script type="text/javascript">
		function change_other(first,second) {
			first.value = second.value;
		}

		function change_selected(first,second,third) {
			first.selectedIndex = third.selectedIndex;
			second.selectedIndex = third.selectedIndex;
		}
		
		function update_username() {
			document.report.repusername.value = document.report.repname.value.toLowerCase() + document.report.repsurname.value[0].toLowerCase();
		}
		
		Calendar.setup({inputField:"date_of_birth",ifFormat:"%Y-%m-%d",button:"trigger_date_of_birth",singleClick:true});
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
