<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer_left.xsl"/>

<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/title"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/menu.css"/>
		<style type="text/css">
			html, body {height: 98%; margin: 0; border: none; text-align: left; font-family: arial, helvetica, sans-serif;  font-size: 11px; color: #000066; white-space: nowrap;}
			#wrapper {height: 78%; background-color: #FFFFFF; align: left; padding-left: 2px; padding-top: 2px;}
		</style>
	</head>
<body>
	<table id="wrapper" height="100%" border="0" align="center" cellpadding="2" cellspacing="0" width="100">
		<tr>
			<td align="left" valign="top" width="100">
				<div id="left">
					<form enctype="multipart/form-data" action="left.php?module=organisation&amp;function=supplier" method="post" name="report">
						<table border="0" align="left" cellpadding="0" cellspacing="1" width="100%" bgcolor="FFFFFF">
							<tr>
								<td class="t1"><a href="main.php?module=organisation&amp;function=left_supplier&amp;display=main" target="main"><xsl:value-of select="$lng/viewmain"/></a></td>
							</tr>
						<xsl:if test="user/classification='3'">
							<tr>
								<td class="t1">
									<a href="main.php?module=organisation&amp;function=create&amp;classification=1" target="main"><xsl:value-of select="$lng/createsupplier"/></a>
								</td>
							</tr>
						</xsl:if>
							<xsl:if test="organisation/organisationid">
							<xsl:if test="user/classification='3'">
								<tr>
									<td class="t2">
										<input type="text" name="searchvalue" value="" size="10" />
										<input type="submit" name="search" class="t">
											<xsl:attribute name="value">
												<xsl:value-of select="$lng/search"/>
											</xsl:attribute>
										</input>
									</td>
								</tr>
							</xsl:if>
								<tr>
									<td class="t2">
										<select name="organisation" class="t1" onchange="update_org()">
											<option value="0"><xsl:value-of select="$lng/selectsupplier"/></option>
											<xsl:variable name="orgmatchid" select="organisationid"/>
											<xsl:for-each select="organisation">
												<option>
													<xsl:attribute name="value"><xsl:value-of select="./organisationid"/></xsl:attribute>
													<xsl:if test="./organisationid=$orgmatchid">
														<xsl:attribute name="selected"/>
													</xsl:if>
													<xsl:value-of select="organisationname"/>
												</option>
											</xsl:for-each>
										</select>
									</td>
								</tr>
								<tr>
									<td class="t2">
									<xsl:value-of select="$lng/supplieradmin"/>
										<ul>
											<li><a href="#" onclick="display_org()"><xsl:value-of select="$lng/edit"/></a></li>
											<li><a href="#" onclick="orglink('show_area')"><xsl:value-of select="$lng/supplierarea"/></a></li>
											<xsl:if test="user/classification='3'">
												<li><a href="#" onclick="orglink('company_link')"><xsl:value-of select="$lng/companypanel"/></a></li>
											</xsl:if>
											<xsl:for-each select="supplieradmin">
												<li>
													<a href="#" onclick="module_org_link('{frame}','{module}','{function}')">
														<xsl:value-of select="name"/>
													</a>
												</li>
											</xsl:for-each>
										</ul>
									</td>
								</tr>
								<tr>
									<td class="t1">
										<a href="#" onclick="create('branch')"><xsl:value-of select="$lng/createbranch"/></a>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="branch/branchid">
								<tr>
									<td class="t2">
										<select name="branch" class="t1" onchange="update_branch()">
											<option value="0"><xsl:value-of select="$lng/selectbranch"/></option>
											<xsl:variable name="branchid" select="branchid" />
											<xsl:for-each select="branch">
												<option>
													<xsl:attribute name="value"><xsl:value-of select="branchid"/></xsl:attribute>
													<xsl:if test="branchid=$branchid">
													<xsl:attribute name="selected">selected</xsl:attribute>
													</xsl:if>
													<xsl:value-of select="branchname"/>
												</option>
											</xsl:for-each>
										</select>
									</td>
								</tr>
								<tr>
									<td class="t2">
										<xsl:value-of select="$lng/branchadmin"/>
										<ul>
											<li><a href="#" onclick="display_branch()"><xsl:value-of select="$lng/edit"/></a></li>
											<xsl:for-each select="branchadmin">
												<li>
													<a href="#" onclick="module_branch_link('{frame}','{module}','{function}')">
														<xsl:value-of select="name"/>
													</a>
												</li>
											</xsl:for-each>
										</ul>
									</td>
								</tr>
								<tr>
									<td class="t1">
										<a href="#" onclick="create('agent')"><xsl:value-of select="$lng/createagent"/></a>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="users/usersid">
								<tr>
									<td class="t2">
										<select name="users" class="t1">
											<option value="0"><xsl:value-of select="$lng/selectagent"/></option>
											<xsl:for-each select="users">
												<option>
													<xsl:attribute name="value"><xsl:value-of select="usersid"/></xsl:attribute>
													<xsl:value-of select="name"/> <xsl:value-of select="' '"/><xsl:value-of select="surname"/>
												</option>
											</xsl:for-each>
										</select>
									</td>
								</tr>
								<tr>
									<td class="t2">
										<xsl:value-of select="$lng/agentadmin"/>
										<ul>
											<li><a href="#" onclick="display_agent()"><xsl:value-of select="$lng/edit"/></a></li>
											<li><a href="#" onclick="password_reset()"><xsl:value-of select="$lng/passwordreset"/></a></li>
											<xsl:for-each select="agentadmin">
												<li>
													<a href="#" onclick="module_user_link('{frame}','{module}','{function}')">
														<xsl:value-of select="name"/>
													</a>
												</li>
											</xsl:for-each>
										</ul>
									</td>
								</tr>
							</xsl:if>
						</table>
					</form>
					<script language="javascript">

						function display_org() {
							var value = document.report.organisation.value;
							if (value != 0) {
								parent.main.location.href = "main.php?module=organisation&amp;function=profile&amp;id="+value;
							} else {
								alert("<xsl:value-of select="$lng/selectsupplier"/>"); 
							}
						} 

					<xsl:if test="branch/branchid">
						function display_branch() {	
							var value = document.report.branch.value;
							if (value != 0) {
								parent.main.location.href = "main.php?module=branch&amp;function=profile&amp;id="+value;
							} else {
								alert("<xsl:value-of select="$lng/selectbranch"/>"); 
							}
						}

						function display_agent() {	
							var value = document.report.users.value;
							if (value != 0) {
								parent.main.location.href = "main.php?module=user&amp;function=profile&amp;id="+value;
							} else {
								alert("<xsl:value-of select="$lng/selectagent"/>"); 
							}
						}
					</xsl:if>

					<xsl:if test="branch/branchid">
						function password_reset() {
							var usersvalue = document.report.users.value;
							var myIndex = document.report.users.selectedIndex;
							if (usersvalue != "0") {
								if(confirm("<xsl:value-of select="$lng/passwordconfirm"/> "+document.report.users.options[myIndex].text)) {
							<xsl:for-each select="users">
									if (usersvalue == "<xsl:value-of select="usersid"/>") {
										parent.main.location.href = "main.php?module=password&amp;function=reset&amp;username=<xsl:value-of select="username"/>&amp;email=<xsl:value-of select="email"/>";
									}
							</xsl:for-each>				
								}
							} else {
							<xsl:if test="module='useradmin'">
								alert("<xsl:value-of select="$lng/selectuser"/>"); 
							</xsl:if>
							<xsl:if test="module='supplieradmin'">
								alert("<xsl:value-of select="$lng/selectagent"/>");
							</xsl:if>
							}
						}
					</xsl:if>
						function update_org() {	
							var value = document.report.organisation.value;
							parent.left.location.href = "left.php?module=organisation&amp;function=supplier&amp;organisationid="+value;
						}

						<xsl:if test="branch/branchid">
							function update_branch() {	
									var branchvalue = document.report.branch.value;
									var usersselect = document.report.users;
									var usersoptions = usersselect.options;
									var counter = 0;
									
									usersselect.length = 0;
									usersoptions[counter++] = new Option("<xsl:value-of select="$lng/selectagent"/>","");
									<xsl:for-each select="users">
										if (branchvalue == "<xsl:value-of select="branchid"/>" || branchvalue == "0") {
											usersoptions[counter++] = new Option("<xsl:value-of select="name"/> <xsl:value-of select="' '"/><xsl:value-of select="surname"/>","<xsl:value-of select="usersid"/>");
										}
									</xsl:for-each>
									if(counter == 1) {
										usersselect.disabled=1;
									} else {
										usersselect.disabled=0;
									}
								
							}
						</xsl:if>
						
						function create(updateType) {	
							var orgIndex = document.report.organisation.selectedIndex;
							if(updateType == "branch") {
								if (orgIndex) {
									parent.main.location.href = "main.php?module=branch&amp;function=create&amp;organisationid="+document.report.organisation.options[orgIndex].value+"";
								}  else {
									alert("<xsl:value-of select="$lng/selectsupplier"/>");
								}
							}
					<xsl:if test="branch">
							if(updateType == "agent") {
								var branchIndex = document.report.branch.selectedIndex;
								if (orgIndex &amp;&amp; branchIndex) {
									parent.main.location.href = "main.php?classification=1&amp;module=user&amp;function=create&amp;organisationid="+document.report.organisation.options[orgIndex].value+"&amp;branchid="+document.report.branch.options[branchIndex].value+"";
								} else {
									alert("<xsl:value-of select="$lng/selectbranch"/>");
								}
							}
					</xsl:if>
						}
					
						function orglink(myFunction) {
							var orgIndex = document.report.organisation.selectedIndex;
							if (orgIndex) {
								parent.main.location.href = "main.php?module=organisation&amp;function="+myFunction+"&amp;organisationid="+document.report.organisation.value+"";
							}  else {
								alert("<xsl:value-of select="$lng/selectsupplier"/>");
							}
						}
						
						function module_org_link(myFrame,myModule,myFunction) {
							<xsl:if test="/response/user/classification='3'">
								var orgValue = document.report.organisation.value;						
							</xsl:if>
							<xsl:if test="/response/user/classification!='3'">
								var orgValue = <xsl:value-of select="/response/user/organisationid"/>;						
							</xsl:if>
							if (orgValue &amp;&amp; orgValue != 0) {
								parent.main.location.href = myFrame+".php?module="+myModule+"&amp;function="+myFunction+"&amp;organisationid="+orgValue;
							}  else {
								alert("<xsl:value-of select="$lng/selectsupplier"/>");
							}
						}
						
						function module_branch_link(myFrame,myModule,myFunction) {
							var branchValue = document.report.users.value;
							if (branchValue &amp;&amp; branchValue != 0) {
								parent.main.location.href = myFrame+".php?module="+myModule+"&amp;function="+myFunction+"&amp;branchid="+branchValue;
							}  else {
								alert("<xsl:value-of select="$lng/selectbranch"/>");
							}
						}
						
						function module_user_link(myFrame,myModule,myFunction) {
							var usersValue = document.report.users.value;
							if (usersValue &amp;&amp; usersValue != 0) {
								parent.main.location.href = myFrame+".php?module="+myModule+"&amp;function="+myFunction+"&amp;usersid="+usersValue;
							}  else {
								alert("<xsl:value-of select="$lng/selectagent"/>");
							}
						}
					</script>
				</div>
			</td>
		</tr>
	</table>
	<xsl:call-template name="footer_left"/>
</body>
</html>
</xsl:template>
</xsl:stylesheet>