<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<xsl:template match="/response">
	
<html>
	<head>
		<title><xsl:value-of select="$lng/menu"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/menu.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/companyadmin"/>
		</div>
		<div id="content">
			<div id="main">
				<form enctype="multipart/form-data" action="left.php?module=organisation&amp;function=company" method="post" name="report">
					<input type="hidden" name="display" value="main"/>
					<table id="left" border="0" align="left" cellpadding="0" cellspacing="1" width="100%" bgcolor="FFFFFF">
					<xsl:if test="/response/user/classification='3'">
						<tr>
							<td class="t1"><a href="main.php?module=organisation&amp;function=create&amp;classification=2" target="main"><xsl:value-of select="$lng/createcompany"/></a></td>
						</tr>
					</xsl:if>
				<xsl:if test="organisation/organisationid">
					<xsl:if test="/response/user/classification='3'">
						<tr>
							<td class="t2">
								<input type="text" name="searchvalue" value="" size="10"/>
								<input type="submit" name="search" class="t">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/search"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="/response/user/classification='3'">
						<tr>
							<td class="t2">
  								 	<select name="organisation" class="t1" onchange="update_org()">
									<option value=""><xsl:value-of select="$lng/selectcompany"/></option>
									<xsl:variable name="orgmatchid" select="organisationid"/>
								<xsl:for-each select="organisation">
									<option>
										<xsl:attribute name="value"><xsl:value-of select="organisationid"/></xsl:attribute>
										<xsl:if test="organisationid=$orgmatchid">
											<xsl:attribute name="selected">selected</xsl:attribute> 
										</xsl:if>
										<xsl:value-of select="organisationname"/>
									</option>		
								</xsl:for-each> 
   									</select>
							</td>
						</tr>
					</xsl:if>
						<tr>
							<td class="t2">
								<xsl:value-of select="$lng/companyadmin"/>
								<ul>
									<li>
										<a href="#" onclick="orglink('profile')"><xsl:value-of select="$lng/edit"/></a>
									</li>
									<li>
										<a href="#" onclick="orglink('show_supplier')"><xsl:value-of select="$lng/suppliersearch"/></a>
									<xsl:for-each select="suppliersearch">
										<br/>* <a href="#" onclick="module_org_link('{frame}','{module}','{function}')">
											<xsl:value-of select="name"/>
										</a>
									</xsl:for-each>
									</li>
								<xsl:if test="/response/user/classification='3' or /response/user/permission='4'">
									<li>
										<a href="#" onclick="orglink('supplier_link')"><xsl:value-of select="$lng/tendersuppliertitle"/></a>
									</li>
								</xsl:if>
								<xsl:for-each select="companyadmin">
									<li>
										<a href="#" onclick="module_org_link('{frame}','{module}','{function}')">
											<xsl:value-of select="name"/>
										</a>
									</li>
								</xsl:for-each>
								</ul>
							</td>
						</tr>
					<xsl:if test="/response/user/classification='3' or /response/user/permission &gt; 2">
						<tr>
							<td class="t1">
								<a href="#" onclick="create('branch')"><xsl:value-of select="$lng/createbranch"/></a>
							</td>
						</tr>
					</xsl:if>
				</xsl:if>
					<xsl:if test="branch/branchid">
						<tr>
							<td class="t2">
								<select name="branch" class="t1" onchange="update('','','users')">
									<option value="0"><xsl:value-of select="$lng/selectbranch"/></option>
								<xsl:for-each select="branch">
									<option>
										<xsl:attribute name="value"><xsl:value-of select="branchid"/></xsl:attribute>
										<xsl:value-of select="branchname"/>
									</option>		
								</xsl:for-each>
								</select>
							</td>
						</tr>
						<tr>
							<td class="t2">
								<xsl:value-of select="$lng/branchadmin"/>
								<ul>
									<li>
										<a href="#" onclick="display_branch()"><xsl:value-of select="$lng/edit"/></a>
									</li>
								<xsl:for-each select="branchadmin">
									<li>
										<a href="#" onclick="module_branch_link('{frame}','{module}','{function}')">
											<xsl:value-of select="name"/>
										</a>
									</li>
								</xsl:for-each>
								</ul>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<a href="#" onclick="create('subscriber')"><xsl:value-of select="$lng/createsubscriber"/></a>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="users/usersid">
						<tr>
							<td class="t2">
								<select name="users" class="t1">
									<option value="0"><xsl:value-of select="$lng/selectsubscriber"/></option>
									<xsl:for-each select="users">
										<option>
											<xsl:attribute name="value"><xsl:value-of select="usersid"/></xsl:attribute>
											<xsl:value-of select="name"/> <xsl:value-of select="' '"/><xsl:value-of select="surname"/>
										</option>
									</xsl:for-each>
								</select>
							</td>
						</tr>
						<tr>
							<td class="t2">
								<xsl:value-of select="$lng/subscriberadmin"/>
								<ul>
									<li><a href="#" onclick="display_subscriber()"><xsl:value-of select="$lng/edit"/></a></li>
								<xsl:for-each select="subscriberadmin">
									<li>
										<a href="#" onclick="module_user_link('{frame}','{module}','{function}')">
											<xsl:value-of select="name"/>
										</a>
									</li>
								</xsl:for-each>
									<li><a href="#" onclick="password_reset()"><xsl:value-of select="$lng/passwordreset"/></a></li>
								</ul>
							</td>
						</tr>
					</xsl:if> 
				</table>
				</form>
			</div>
			<div id="right">
			</div>
		</div>
	</div>
	<!-- <xsl:call-template name="footer"/> -->
	
	<script language="javascript">
	
	<xsl:if test="/response/user/classification='3'">
		function update_org() {
			var value = document.report.organisation.value;
			parent.main.location.href = "left.php?module=organisation&amp;function=company&amp;display=main&amp;organisationid="+value;
		}
	</xsl:if>	

	<xsl:if test="branch/branchid">
		function display_branch() {	
			var value = document.report.branch.value;
			if (value != 0) {
				parent.main.location.href = "main.php?module=branch&amp;function=profile&amp;id="+value;
			} else {
				alert("<xsl:value-of select="$lng/selectbranch"/>"); 
			}
		}

		function display_subscriber() {	
			var value = document.report.users.value;
			if (value != 0) {
				parent.main.location.href = "main.php?module=user&amp;function=profile&amp;id="+value;
			} else {
				alert("<xsl:value-of select="$lng/selectsubscriber"/>"); 
			}
		}
	</xsl:if>
	
	<xsl:if test="branch">
		function password_reset() {
			var usersvalue = document.report.users.value;
			
			var myIndex = document.report.users.selectedIndex;
			if (usersvalue != "0") {
				if(confirm("<xsl:value-of select="$lng/passwordconfirm"/>  "+document.report.users.options[myIndex].text)) {
			<xsl:for-each select="users">
					if (usersvalue == "<xsl:value-of select="usersid"/>") {
						parent.main.location.href = "main.php?module=password&amp;function=reset&amp;username=<xsl:value-of select="username"/>&amp;email=<xsl:value-of select="email"/>";
					}
			</xsl:for-each>				
				}
			} else {
				alert("<xsl:value-of select="$lng/selectsubscriber"/>"); 
			}
		}
	</xsl:if>

		function update(myModule,myFunction,updateType) {
			<xsl:if test="/response/user/classification='3'">
				var orgValue = document.report.organisation.value;						
			</xsl:if>
			<xsl:if test="/response/user/classification!='3'">
				var orgValue = <xsl:value-of select="/response/user/organisationid"/>;						
			</xsl:if>	
			if(updateType == "organisation") {
				parent.main.location.href = "left.php?module="+myModule+"&amp;function="+myFunction+"&amp;organisationid="+orgValue;
			}
		<xsl:if test="organisation/organisationid">
			if(updateType == "users") {
				var branchvalue = document.report.branch.value;
				var usersselect = document.report.users;
				var usersoptions = usersselect.options;
				var counter = 0;
				usersselect.length = 0;
				usersoptions[counter++] = new Option("<xsl:value-of select="$lng/selectsubscriber"/>","");
			<xsl:for-each select="users">
				if (branchvalue == "<xsl:value-of select="branchid"/>" || branchvalue == "0") {
					usersoptions[counter++] = new Option("<xsl:value-of select="name"/> <xsl:value-of select="' '"/><xsl:value-of select="surname"/>","<xsl:value-of select="usersid"/>");
				}
			</xsl:for-each>
				if(counter == 1) {
					usersselect.disabled=1;
				} else {
					usersselect.disabled=0;
				}
			}
		</xsl:if>
		}
		
		function create(updateType) {
			<xsl:if test="/response/user/classification='3'">
				var orgValue = document.report.organisation.value;						
			</xsl:if>
			<xsl:if test="/response/user/classification!='3'">
				var orgValue = <xsl:value-of select="/response/user/organisationid"/>;						
			</xsl:if>	
			if(updateType == "branch") {
				if (orgValue) {
					parent.main.location.href = "main.php?module=branch&amp;function=create&amp;organisationid="+orgValue;
				}  else {
					alert("<xsl:value-of select="$lng/selectcompany"/>");
				}
			}
		<xsl:if test="branch">
			if(updateType == "subscriber") {
				var branchIndex = document.report.branch.selectedIndex;
				if (orgValue &amp;&amp; branchIndex) {
					parent.main.location.href = "main.php?classification=2&amp;module=user&amp;function=create&amp;organisationid="+orgValue+"&amp;branchid="+document.report.branch.options[branchIndex].value+"";
				} else {
					alert("<xsl:value-of select="$lng/selectbranch"/>");
				}
			}
		</xsl:if>
		}
	
		function orglink(myFunction) {
			<xsl:if test="/response/user/classification='3'">
				var orgValue = document.report.organisation.value;						
			</xsl:if>
			<xsl:if test="/response/user/classification!='3'">
				var orgValue = <xsl:value-of select="/response/user/organisationid"/>;						
			</xsl:if>
			if (orgValue) {
				if(myFunction == "profile") {
					parent.main.location.href = "main.php?module=organisation&amp;function=profile&amp;id="+orgValue;
				} else {
					parent.main.location.href = "main.php?module=organisation&amp;function="+myFunction+"&amp;organisationid="+orgValue;
				}
			}  else {
				alert("<xsl:value-of select="$lng/selectcompany"/>");
			}
		}
		
		function module_org_link(myFrame,myModule,myFunction) {
			<xsl:if test="/response/user/classification='3'">
				var orgValue = document.report.organisation.value;						
			</xsl:if>
			<xsl:if test="/response/user/classification!='3'">
				var orgValue = <xsl:value-of select="/response/user/organisationid"/>;						
			</xsl:if>
			if (orgValue &amp;&amp; orgValue != 0) {
				parent.main.location.href = myFrame+".php?module="+myModule+"&amp;function="+myFunction+"&amp;organisationid="+orgValue;
			}  else {
				alert("<xsl:value-of select="$lng/selectcompany"/>");
			}
		}
		
		function module_branch_link(myFrame,myModule,myFunction) {
			var branchValue = document.report.users.value;
			if (branchValue &amp;&amp; branchValue != 0) {
				parent.main.location.href = myFrame+".php?module="+myModule+"&amp;function="+myFunction+"&amp;branchid="+branchValue;
			}  else {
				alert("<xsl:value-of select="$lng/selectbranch"/>");
			}
		}
		
		function module_user_link(myFrame,myModule,myFunction) {
			var usersValue = document.report.users.value;
			if (usersValue &amp;&amp; usersValue != 0) {
				parent.main.location.href = myFrame+".php?module="+myModule+"&amp;function="+myFunction+"&amp;usersid="+usersValue;
			}  else {
				alert("<xsl:value-of select="$lng/selectsubscriber"/>");
			}
		}
	</script>
</body>
</html>
</xsl:template>
</xsl:stylesheet>