<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/organisationprofile"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:choose>
				<xsl:when test="organisationinfo/classification='2'">
					<xsl:value-of select="$lng/companyprofile"/>
				</xsl:when>
				<xsl:when test="organisationinfo/classification='1'">
					<xsl:value-of select="$lng/supplierprofile"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$lng/organisationprofile"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:value-of select="' ('"/>
			<xsl:value-of select="organisationinfo/organisationname"/>
			<xsl:value-of select="')'"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'organisation'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="organisation"/>
					<input type="hidden" name="function" value="profile"/>
					<input type="hidden" name="id">
						<xsl:attribute name="value"><xsl:value-of select="organisationinfo/organisationid"/></xsl:attribute>
					</input>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="created='1'">
							<tr>
								<td colspan="4" class="t1">
									<xsl:value-of select="$lng/created_org"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="deleted='1'">
							<tr>
								<td colspan="4" class="e">
									<xsl:value-of select="$lng/deleted"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="updated='1'">
							<tr>
								<td colspan="4" class="t1">
									<xsl:value-of select="$lng/updated"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="needarea='1'">
							<tr>
								<td colspan="4" class="e">
									<xsl:value-of select="$lng/remember"/> : 
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=organisation&amp;function=show_area&amp;organisationid=',organisationinfo/organisationid)"/>
										</xsl:attribute>
										<xsl:value-of select="$lng/needarea"/>
									</a>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="needcompany='1'">
							<tr>
								<td colspan="4" class="e">
									<xsl:value-of select="$lng/remember"/> : 
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=organisation&amp;function=company_link&amp;organisationid=',organisationinfo/organisationid)"/>
										</xsl:attribute>
										<xsl:value-of select="$lng/needcompany"/>
									</a>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="needsupplier='1'">
							<tr>
								<td colspan="4" class="e">
									<xsl:value-of select="$lng/remember"/> : 
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=organisation&amp;function=supplier_link&amp;organisationid=',organisationinfo/organisationid)"/>
										</xsl:attribute>
										<xsl:value-of select="$lng/needsupplier"/>
									</a>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="reminder">
							<xsl:for-each select="reminder">
								<tr>
									<td colspan="4" class="e">
										<xsl:value-of select="prename"/> : 
										<a target="main" href="{frame}.php?module={module}&amp;function={function}&amp;organisationid={../organisationinfo/organisationid}">
											<xsl:value-of select="name"/>
										</a>
									</td>
								</tr>
							</xsl:for-each>
						</xsl:if>
						<tr>
							<td colspan="4" class="h t1">
								<xsl:choose>
									<xsl:when test="organisationinfo/classification='1'">
										<xsl:value-of select="$lng/supplierinfo"/>
									</xsl:when>
									<xsl:when test="organisationinfo/classification='2'">
										<xsl:value-of select="$lng/companyinfo"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/orginfo"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:value-of select="' : '"/>
								<xsl:value-of select="organisationinfo/organisationname"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"   class="t1">
								<xsl:value-of select="$lng/name"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="organisationname" class="t2" value="{organisationinfo/organisationname}">
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">disabled t2</xsl:attribute>
									</xsl:if>
								</input>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"   class="t1">
								<xsl:value-of select="$lng/registeredname"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="registered_name" class="t2" value="{organisationinfo/registered_name}">
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">disabled t2</xsl:attribute>
									</xsl:if>
								</input>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"   class="t1">
								<xsl:value-of select="$lng/classification"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:choose>
									<xsl:when test="organisationinfo/classification='3'">
										<xsl:value-of select="$lng/admin"/>
									</xsl:when>
									<xsl:when test="organisationinfo/classification='1'">
										<xsl:value-of select="$lng/supplier"/>
									</xsl:when>
									<xsl:when test="organisationinfo/classification='2'">
										<xsl:value-of select="$lng/company"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/unknown"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
					<xsl:if test="organisationinfo/transaction_fee">	
						<tr>
							<td ><br/></td>
							<td align="left"   class="t1">
								<xsl:value-of select="$lng/transaction_fee"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="transaction_fee" class="t2" value="{organisationinfo/transaction_fee}" size="6">
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">disabled t2</xsl:attribute>
									</xsl:if>
								</input><xsl:value-of select="'%'"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="organisationinfo/transaction_min">
						<tr>
							<td ><br/></td>
							<td align="left"   class="t1">
								<xsl:value-of select="$lng/transaction_min"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="localprecurrency"/>
								<input type="text" name="transaction_min" class="t2" value="{organisationinfo/transaction_min}" size="6">
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">disabled t2</xsl:attribute>
									</xsl:if>
								</input>
								<xsl:value-of select="localpostcurrency"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="organisationinfo/user_fee">
						<tr>
							<td ><br/></td>
							<td align="left"   class="t1">
								<xsl:value-of select="$lng/user_fee"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="localprecurrency"/>
								<input type="text" name="user_fee" class="t2" value="{organisationinfo/user_fee}" size="6">
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">disabled t2</xsl:attribute>
									</xsl:if>
								</input>
								<xsl:value-of select="localpostcurrency"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="organisationinfo/sms_fee">
						<tr>
							<td ><br/></td>
							<td align="left"   class="t1">
								<xsl:value-of select="$lng/sms_fee"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="localprecurrency"/>
								<input type="text" name="sms_fee" class="t2" value="{organisationinfo/sms_fee}" size="6">
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">disabled t2</xsl:attribute>
									</xsl:if>
								</input>
								<xsl:value-of select="localpostcurrency"/>
							</td>
						</tr>
					</xsl:if>
						<tr>
							<td ><br/></td>
							<td align="left"   class="t1">
								<xsl:value-of select="$lng/registration_number"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="registration_number" class="t2" value="{organisationinfo/registration_number}">
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">disabled t2</xsl:attribute>
									</xsl:if>
								</input>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"   class="t1">
								<xsl:value-of select="$lng/vat_number"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="vat_number" class="t2" value="{organisationinfo/vat_number}">
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">disabled t2</xsl:attribute>
									</xsl:if>
								</input>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/rating"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:if test="editable='1'">
									<select name="rating" class="t2">
										<option value="A">
											<xsl:value-of select="$lng/rating_a"/>
										</option>
										<option value="B">
											<xsl:if test="organisationinfo/rating='B'">
												<xsl:attribute name="selected"/>
											</xsl:if>
											<xsl:value-of select="$lng/rating_b"/>
										</option>
										<option value="C">
											<xsl:if test="organisationinfo/rating='C'">
												<xsl:attribute name="selected"/>
											</xsl:if>
											<xsl:value-of select="$lng/rating_c"/>
										</option>
										<option value="D">
											<xsl:if test="organisationinfo/rating='D'">
												<xsl:attribute name="selected"/>
											</xsl:if>
											<xsl:value-of select="$lng/rating_d"/>
										</option>
										<option value="E">
											<xsl:if test="organisationinfo/rating='E'">
												<xsl:attribute name="selected"/>
											</xsl:if>
											<xsl:value-of select="$lng/rating_e"/>
										</option>
									</select>
								</xsl:if>
								<xsl:if test="editable='0'">
									<xsl:value-of select="organisationinfo/rating"/>
								</xsl:if>
							</td>
						</tr>
						<xsl:call-template name="additional"/>
						<xsl:if test="editable='1'">
						<tr>
							<td><br/></td>
							<td align="left"   class="t1">
								<xsl:value-of select="$lng/logo"/>
								(<xsl:value-of select="$lng/pngorjpeg"/>)
							</td>
							<td align="left" class="t2">
								<input type="file" name="logo" class="t2" accept="image/jpeg,image/png"/>
							</td>
							<td class="t1">
								<xsl:if test="organisationinfo/attachment!=''">
									<a href="main.php?module=generic&amp;function=attachment&amp;user_id={user/usersid}&amp;language={user/language}&amp;id={organisationinfo/attachment}&amp;authentication={organisationinfo/authentication}">
										<xsl:value-of select="organisationinfo/picname"/>
									</a>
								</xsl:if>
							</td>
						</tr>
						</xsl:if>
						<tr>
							<td ><br/></td>
							<td align="left"   class="t1">
								<xsl:value-of select="$lng/createdon"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="organisationinfo/created_date"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="organisationinfo/created_time"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="localdisplay"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"   class="t1">
								<xsl:value-of select="$lng/createdby"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',organisationinfo/creatorid)"/>
									</xsl:attribute>
									<xsl:value-of select="organisationinfo/creatorname"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="organisationinfo/creatorsurname"/>
								</a>
							</td>
						</tr>
						<!-- Organisation Status -->
						<tr>
							<td ><br/></td>
							<td align="left"   class="t1">
								<xsl:value-of select="$lng/status"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:choose>
									<xsl:when test="organisationinfo/status='2'">
										<xsl:value-of select="$lng/approvalneeded"/>
									</xsl:when>
									<xsl:when test="organisationinfo/status='1'">
										<xsl:value-of select="$lng/active"/>
									</xsl:when>
									<xsl:when test="organisationinfo/status='0'">
										<xsl:value-of select="$lng/deleted"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/unknown"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td colspan="2"><br/></td>
						</tr>
						<tr>
							<td colspan="4" class="h t1">
								<xsl:value-of select="$lng/repinfo"/>:
								<xsl:if test="editable='1'">
									<select name="rep_user_id" class="t2" onchange="update_repinfo()">
										<xsl:for-each select="organisationinfo/users">
											<option value="{usersid}">
												<xsl:if test="../repid = usersid">
													<xsl:attribute name="selected"/>
												</xsl:if>		
												<xsl:value-of select="name"/>
												<xsl:value-of select="' '"/>
												<xsl:value-of select="surname"/>
											</option>											
										</xsl:for-each>
									</select>		
								</xsl:if>
								<xsl:if test="editable='0'">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',organisationinfo/repid)"/>
										</xsl:attribute>
										<xsl:value-of select="organisationinfo/repname"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="organisationinfo/repsurname"/>
									</a>
								</xsl:if>	
								
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"   class="t1">
								<xsl:value-of select="$lng/name"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:if test="editable='1'">
									<input name="repname" type="text" size="20" maxlength="30" readonly="1">
										<xsl:attribute name="value">
											<xsl:value-of select="organisationinfo/repname"/>
										</xsl:attribute>	
									</input>
								</xsl:if>	
								<xsl:if test="editable='0'">									
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',organisationinfo/repid)"/>
										</xsl:attribute>
										<xsl:value-of select="organisationinfo/repname"/>
									</a>
								</xsl:if>	
							</td>
						</tr>
						 <tr>
							<td ><br/></td>
							<td align="left"   class="t1">
								<xsl:value-of select="$lng/surname"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:if test="editable='1'">
									<input name="repsurname" type="text" size="20" maxlength="30" readonly="1">
										<xsl:attribute name="value">
											<xsl:value-of select="organisationinfo/repsurname"/>
										</xsl:attribute>	
									</input>	
								</xsl:if>	
								<xsl:if test="editable='0'">
									<xsl:value-of select="organisationinfo/repsurname"/>
								</xsl:if>	
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"   class="t1">
								<xsl:value-of select="$lng/phonework"/>
							</td>
							<td align="left" class="t2">
								<xsl:if test="editable='1'">								
									<input name="repphone_work" type="text" size="15" maxlength="30" readonly="1">
										<xsl:attribute name="value">
											<xsl:value-of select="organisationinfo/repphone_work"/>
										</xsl:attribute>	
									</input>	
								</xsl:if>
								<xsl:if test="editable='0'">									
									<xsl:value-of select="organisationinfo/repphone_work"/>
								</xsl:if>
							</td>
							<td align="right"  class="t1">
								<a id="phone_link">
									<xsl:attribute name="href">
										<xsl:value-of select="'callto://+'"/>
										<xsl:for-each select="organisationinfo/users">
											<xsl:if test="../repid = usersid">
												<xsl:value-of select="phone_prefix"/>
												<xsl:number value="phone_work" format="1"/>
											</xsl:if>	
										</xsl:for-each>
									</xsl:attribute>
									<img src="./theme/{$theme}/icon/call.gif" border="0">
										<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/call"/></xsl:attribute>
									</img>
								</a>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/email"/>
							</td>
							<td align="left" class="t2">
								<xsl:if test="editable='1'">
									<input name="repemail" type="text" size="25" maxlength="30" readonly="1">
										<xsl:attribute name="value">
											<xsl:value-of select="organisationinfo/repemail"/>											
										</xsl:attribute>	
									</input>
								</xsl:if>
								<xsl:if test="editable='0'">	
									<xsl:value-of select="organisationinfo/repemail"/>
								</xsl:if>	
							</td>
							<td align="right" class="t1">
								<a id="email_link">
									<xsl:attribute name="href">
										<xsl:value-of select="'mailto:'"/>
										<xsl:for-each select="organisationinfo/users">
											<xsl:if test="../repid = usersid">
												<xsl:value-of select="email"/>
											</xsl:if>	
										</xsl:for-each>										
									</xsl:attribute>
									<img src="./theme/{$theme}/icon/mail_replay.gif" border="0">
										<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/call"/></xsl:attribute>
									</img>
								</a>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"   class="t1">
								<xsl:value-of select="$lng/status"/>
							</td>
								<td align="left" colspan="2" class="t2">
									<xsl:if test="editable='1'">
										<input name="repstatus" type="text" size="15" maxlength="30" readonly="1">
											<xsl:attribute name="value">
												<xsl:choose>
													<xsl:when test="organisationinfo/repstatus='2'">
														<xsl:value-of select="$lng/inactive"/>
													</xsl:when>
													<xsl:when test="organisationinfo/repstatus='1'">
														<xsl:value-of select="$lng/active"/>
													</xsl:when>
													<xsl:when test="organisationinfo/repstatus='0'">
														<xsl:value-of select="$lng/deleted"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="$lng/unknown"/>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:attribute>	
										</input>	
									</xsl:if>	
									<xsl:if test="editable='0'">																		
										<xsl:choose>
											<xsl:when test="organisationinfo/repstatus='2'">
												<xsl:value-of select="$lng/inactive"/>
											</xsl:when>
											<xsl:when test="organisationinfo/repstatus='1'">
												<xsl:value-of select="$lng/active"/>
											</xsl:when>
											<xsl:when test="organisationinfo/repstatus='0'">
												<xsl:value-of select="$lng/deleted"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$lng/unknown"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:if>	
							</td>
						</tr>
						<xsl:if test="editable='1'">
							<tr>
								<td align="right" width="270" colspan="4">
									<input type="submit" name="changeorg" class="t2">
										<xsl:attribute name="value">
											<xsl:value-of select="$lng/changeorg"/>
										</xsl:attribute>
									</input>
									<xsl:if test="organisationinfo/organisationid!=user/organisationid">
										<input type="checkbox" name="deleteorg" class="t2" onchange="alertremove()"/>
										<xsl:value-of select="$lng/delete"/>
									</xsl:if>
									<xsl:if test="organisationinfo/status='2' and /response/user/permission='2'">
										<input type="checkbox" name="status" value='1' class="t2"/>
										<xsl:value-of select="$lng/approve"/>
									</xsl:if>
								</td>
							</tr>
					</xsl:if>
				<xsl:if test="link">
						<tr>
							<td colspan="2"><br/></td>
						</tr>
						<tr>
							<td colspan="4" class="h t1">
								<xsl:value-of select="$lng/otherinfo"/>
							</td>
						</tr>
					<xsl:for-each select="link">
						<tr>
							<td><br/></td>
							<td class="t1" align="left">
								<a href="./{frame}.php?module={module}&amp;function={function}" target="{frame}">
									<xsl:value-of select="name"/>
								</a>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:if>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/editinfo"/>
				</div>
				<div id="right_content">
					<xsl:if test="editable='1'">
						<xsl:value-of select="$lng/freetoedit"/>
					</xsl:if>
					<xsl:if test="editable='0'">
						<xsl:value-of select="$lng/notfreetoedit"/>
					</xsl:if>
				</div>
			</div>
		</div>
	</div>
	<script language="javascript">
		function alertremove() {	
			var del = document.report.deleteorg.checked;
			if(del) {
				if(!confirm("<xsl:value-of select="$lng/alertdelete"/>")) {
					document.report.deleteorg.checked = false;
				}
			}
		}
		<xsl:if test="created='1' or deleted='1'">
			parent.left.location.reload();
		</xsl:if>
				
		function update_repinfo() {	
			var box = document.report.rep_user_id;
			var sel = box.options[box.selectedIndex].value;
			<xsl:for-each select="organisationinfo/users">
				if(sel == "<xsl:value-of select="usersid"/>") {
					document.report.repname.value = "<xsl:value-of select="name"/>";
					document.report.repsurname.value = "<xsl:value-of select="surname"/>";
					document.report.repphone_work.value = "<xsl:value-of select="phone_work"/>";
					document.report.repemail.value = "<xsl:value-of select="email"/>";
					document.links[1].href = "callto://+"+"<xsl:value-of select="phone_prefix"/>"+"<xsl:number value="phone_work" format="1"/>";
					document.links[2].href = "mailto:"+"<xsl:value-of select="email"/>";
					<xsl:choose>
						<xsl:when test="status='2'">
							document.report.repstatus.value = "<xsl:value-of select="$lng/inactive"/>";
						</xsl:when>
						<xsl:when test="status='1'">
							document.report.repstatus.value = "<xsl:value-of select="$lng/active"/>";
						</xsl:when>
						<xsl:when test="status='0'">
							document.report.repstatus.value = "<xsl:value-of select="$lng/deleted"/>";
						</xsl:when>
						<xsl:otherwise>
							document.report.repstatus.value = "<xsl:value-of select="$lng/unknown"/>";
						</xsl:otherwise>
					</xsl:choose>	
				}
			</xsl:for-each>
		}		
	</script>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>
	
<xsl:template name="additional">
 <xsl:if test="organisationinfo/additional">
	 	<xsl:variable name="editable" select="editable"/>
		<xsl:for-each select="organisationinfo/additional">
			<xsl:variable name="current" select="current"/>
			<tr>
				<td ><br/></td>
				<td align="left" class="t1">
					<xsl:value-of select="name"/>
				</td>
				<td align="left" colspan="2" class="t2">
	<xsl:choose>
		<xsl:when test="type='view_text'">
			<xsl:value-of select="current"/>
		</xsl:when>						
		<xsl:when test="type='select' or type='Select' or type='SELECT'">
			<xsl:if test="$editable='0'">
				<xsl:for-each select="option">
					<xsl:if test="value=$current">
						<xsl:value-of select="name"/>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
			<xsl:if test="$editable='1'">
				<select name="additional[{column}]" class="t2">
					<xsl:for-each select="option">
						<option value="{value}">
							<xsl:if test="$current=value">
								<xsl:attribute name="selected"/>
							</xsl:if>
							<xsl:value-of select="name"/>
						</option>
					</xsl:for-each>
				</select>
			</xsl:if>
		</xsl:when>								
		<xsl:otherwise>
			<xsl:if test="$editable='0'">
				<xsl:value-of select="$current"/>
			</xsl:if>
			<xsl:if test="$editable='1'">
				<input name="additional[{column}]" value="{$current}" class="t2">
					<xsl:if test="size">
						<xsl:attribute name="size"><xsl:value-of select="size"/></xsl:attribute>
					</xsl:if>
				</input>
			</xsl:if>
		</xsl:otherwise>
	</xsl:choose>
				</td> 
			</tr>
		</xsl:for-each>  
	</xsl:if>
</xsl:template> 

</xsl:stylesheet>
