<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/searchresults"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/searchresults"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'organisation'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="organisation"/>
					<input type="hidden" name="function" value="search"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							 <td><br/></td>
							<td class="h t1">
								<xsl:value-of select="$lng/supplier"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/status"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/rep"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/email"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/phonework"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/phonemobile"/>
							</td>
						</tr>
						<xsl:for-each select="organisation">
							<tr>
								 <td><br/></td>
								<td class="h2b t2" nowrap="nowrap">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',./organisationid)"/>
										</xsl:attribute>
										<xsl:value-of select="organisationname"/>
									</a>
								</td>
								<td class="h2c t2">
									<xsl:choose>
										<xsl:when test="./status='1'">
											<xsl:value-of select="$lng/active"/>
										</xsl:when>
										<xsl:when test="./status='0'">
											<xsl:value-of select="$lng/deleted"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$lng/unknown"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="h2c t2" nowrap="nowrap">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./rep_user_id)"/>
										</xsl:attribute>
										<xsl:value-of select="repname"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="repsurname"/>
									</a>
								</td>
								<td class="h2c t2">
									<a href="mailto:{repemail}">
										<xsl:value-of select="repemail"/>
									</a>
								</td>
								<td class="h2c t2">
									<a>
										<xsl:attribute name="href">
											<xsl:value-of select="'callto://+'"/>
											<xsl:value-of select="repphone_prefix"/>
											<xsl:number value="repphone_work" format="1"/>
										</xsl:attribute>
										<xsl:value-of select="repphone_work"/>
									</a>
								</td>
								<td class="h2c t2">
									<a>
										<xsl:attribute name="href">
											<xsl:value-of select="'callto://+'"/>
											<xsl:value-of select="repphone_prefix"/>
											<xsl:number value="repphone_mobile" format="1"/>
										</xsl:attribute>
										<xsl:value-of select="repphone_mobile"/>
									</a>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
