<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/suppliersearch"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/suppliersearch"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'organisation'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="organisation"/>
					<input type="hidden" name="function" value="search"/>
					<input type="hidden" name="organisationid" value="{organisationid}"/>
					<input type="hidden" name="organisationcount" value="{organisationcount}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF" id="sitediv">
						<tr>
							<td class="h t1" colspan="3">
								<xsl:value-of select="$lng/supplier"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/search"/>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/supplier"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/name"/>
							</td>
							<td class="t1">
								<input type="text" size="12" maxlenght="32" class="t2" name="name"/>
							</td>
							<td class="t1">
								(<xsl:value-of select="$lng/optional"/>)
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/state"/>
							</td>
							<td class="t1">
								<select name="state" class="t2" onchange="changearea()">
									<option value="">--</option>
									<xsl:for-each select="state">
										<option>
											<xsl:attribute name="value"><xsl:value-of select="stateid"/></xsl:attribute>
											<xsl:value-of select="statename"/>
										</option>
									</xsl:for-each>
								</select>
							</td>
							<td class="t1">
								(<xsl:value-of select="$lng/optional"/>)
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/area"/>
							</td>
							<td class="t1">
								<select name="area" class="t2">
									<option value="">--</option>
									<xsl:for-each select="area">
										<option>
											<xsl:attribute name="value"><xsl:value-of select="areaid"/></xsl:attribute>
											<xsl:value-of select="areaname"/>
										</option>
									</xsl:for-each>
								</select>
							</td>
							<td class="t1">
								(<xsl:value-of select="$lng/optional"/>)
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/panel"/>
							</td>
							<td class="t1">
								<select name="panel" class="t2">
									<option value="panel"><xsl:value-of select="$lng/supplierpanel"/></option>
									<option value="all"><xsl:value-of select="$lng/supplierall"/></option>
								</select>
							</td>
							<td class="t1">
								(<xsl:value-of select="$lng/optional"/>)
							</td>
						</tr>
						<tr>
							<td class="t1" align="right">
								<input type="submit" name="search" class="t2">
									<xsl:attribute name="value"><xsl:value-of select="$lng/search"/></xsl:attribute>
								</input>
							</td>
							<td class="t1">
								<input type="submit" name="cancel" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/cancel"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/tenderorgtitle"/>
				</div>
				<div id="right_content">
					<xsl:value-of select="$lng/tenderorginst"/>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function changesubcategory() {
			var categoryvalue = document.report.category.value;
			var category_subselect = document.report.category_sub;
			var category_suboptions = category_subselect.options;
			var counter = 0;
			
			category_subselect.length = 0;
			category_suboptions[counter++] = new Option("--","");
			<xsl:for-each select="subcategory">
				if (categoryvalue == "<xsl:value-of select="categoryid"/>" || categoryvalue == "") {
					category_suboptions[counter++] = new Option("<xsl:value-of select="subcategoryname"/> ","<xsl:value-of select="subcategoryid"/>");
				}
			</xsl:for-each>
		}
		
		function changearea() {
			var statevalue = document.report.state.value;
			var areaselect = document.report.area;
			var areaoptions = areaselect.options;
			var counter = 0;
			
			areaselect.length = 0;
			areaoptions[counter++] = new Option("--","");
			<xsl:for-each select="area">
				if (statevalue == "<xsl:value-of select="stateid"/>" || statevalue == "") {
					areaoptions[counter++] = new Option("<xsl:value-of select="areaname"/> ","<xsl:value-of select="areaid"/>");
				}
			</xsl:for-each>
		}
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
