<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* install test class
* @package TenderSystem
* @subpackage Install
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global varibales are off or API is hosted on a non-public server
if (eregi("settings.class.php",$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// test generic functions
Class organisation_tester extends module_tester {
	
	function organisation_tester() {
		// what module it tests
		$this->module = "organisation";
		// the dependency of the module
		$this->dependency[] = "session_login_tester";
		// description what all the tester tests
		$this->description = "Test if a supplier can be created. Test if a company can be created." .
		"Test if a organisation can be updated. Test if a organisation can be deleted.";
		// level of testing
		$this->level = "1";
	}
	
	function do_testing() {
		// login as admin
		$this->login("admin");
		// do tests
		$this->test_create_company();
		$this->test_create_supplier();
		$this->test_update_organisation();
		$this->test_delete_organisation();
		// logout as admin
		$this->logout();
		$this->get_password_from_email("get_user_passwords");
		$this->done = TRUE;
	}
	
	function test_create_company() {
		$unit = "test_create_company";
		// create company
		$organisation['status']= "1";
		$params['organisationname'] = $organisation['name'] = "Company";
		$params['registered_name'] = $organisation['registered_name'] = "Company_Reg";
		$params['classification'] = $organisation['classification'] = "2";
		$params['transaction_fee'] = $organisation['transaction_fee'] = "10";
		$params['transaction_min'] = $organisation['transaction_min'] = "10";
		$params['vat_number'] = $organisation['vat_number'] = "10";
		$params['registration_number'] = $organisation['registration_number'] = "10";
		$params['user_fee'] = $organisation['user_fee'] = "10";
		$params['sms_fee'] = $organisation['sms_fee'] = "10";
		$params['rating'] = $organisation['rating'] = "A";
		$params['repposition'] = $organisation['rep_position'] = "Admin";
		$organisation['rep_user_id'] = $this->get_next_id("users");
		// subscriber info
		$user['status'] = "2";
		$params['repusername'] = $user['username'] = "Subscriber";
		$params['repname'] = $user['name'] = "Subscriber";
		$params['repsurname'] = $user['surname'] = "Company";
		$params['repphone_work'] = $user['phone_work'] = "123123123";
		$params['repphone_prefix'] = $user['phone_prefix'] = "27";
		$params['repphone_fax'] = $user['phone_fax'] = "123123123";
		$params['repphone_mobile'] = $user['phone_mobile'] = $this->cfg['unit']['phone_mobile'];
		$params['repemail'] = $user['email'] = $this->cfg['unit']['email'];
		$params['reppreference'] = $user['preference'] = "n";
		$params['reppermission'] = $user['permission'] = "4";
		$params['reptheme'] = $user['theme'] = $this->cfg['theme'];
		$params['replang'] = $user['language'] = $this->cfg['language'];
		$params['repmandate'] = $user['mandate'] = "1000";
		$user['classification'] = "2";
		$user['branch'] = $this->get_next_id("organisation_branch");
		$user['organisation'] = $this->get_next_id("organisation");
		// branch info
		$branch['status'] = "1";
		$params['branchname'] = $branch['name'] = "1000";
		$params['branchphone_work'] = $branch['phone_work'] = "123123123";
		$params['branchphone_fax'] = $branch['phone_fax'] = "123123123";
		$params['branchphone_prefix'] = $branch['phone_prefix'] = "27";
		$params['branchemail'] = $branch['email'] = $this->cfg['unit']['email'];
		$params['branchcomment'] = $branch['comment'] = "comment";
		$params['primary_address_street'] = $branch['primary_address_street'] = "1000";
		$params['primary_address_city'] = $branch['primary_address_city'] = "1000";
		$params['primary_address_state'] = $branch['primary_address_state'] = "1000";
		$params['primary_address_postalcode'] = $branch['primary_address_postalcode'] = "1000";
		$params['alt_address_street'] = $branch['alt_address_street'] = "1000";
		$params['alt_address_city'] = $branch['alt_address_city'] = "1000";
		$params['alt_address_state'] = $branch['alt_address_state'] = "1000";
		$params['alt_address_postalcode'] = $branch['alt_address_postalcode'] = "1000";
		$params['address_country'] =$branch['alt_address_country'] = $branch['primary_address_country'] = "1000";
		$branch['organisation'] = $user['organisation'];
		$params['createorg'] = "TRUE";
		$html = $this->do_post("organisation","create","main",$params);
		$phrase = array("created_org");
		$phrase = $this->get_default_phrases($phrase);
		$pos = 0;
		foreach($phrase as $value) {
			$pos = strpos($html,$value,$pos);
			if($pos === FALSE) {
				// add failure result
				$this->add_result(	$unit,
									"failed",
									"Could not find word : ".$value
				);
				return FALSE;
			}
		}
		// add info to make database variable
		$this->add_database("organisation",$organisation);
		$this->add_database("organisation_branch",$branch);
		$this->add_database("users",$user);
		// add successful result
		$this->add_result($unit,"passed");
		return TRUE;		
	}
	
	function test_create_supplier() {
		$unit = "test_create_supplier";
		global $database;
		// create supplier
		$organisation['status']= "1";
		$params['organisationname'] = $organisation['name'] = "Supplier";
		$params['registered_name'] = $organisation['registered_name'] = "Supplier_Reg";
		$params['classification'] = $organisation['classification'] = "1";
		$params['transaction_fee'] = $organisation['transaction_fee'] = "10";
		$params['transaction_min'] = $organisation['transaction_min'] = "10";
		$params['vat_number'] = $organisation['vat_number'] = "10";
		$params['registration_number'] = $organisation['registration_number'] = "10";
		$params['user_fee'] = $organisation['user_fee'] = "10";
		$params['sms_fee'] = $organisation['sms_fee'] = "10";
		$params['rating'] = $organisation['rating'] = "A";
		$params['repposition'] = $organisation['rep_position'] = "Admin";
		$organisation['rep_user_id'] = $this->get_next_id("users");
		// agent info
		$user['status'] = "2";
		$params['repusername'] = $user['username'] = "Agent";
		$params['repname'] = $user['name'] = "Agent";
		$params['repsurname'] = $user['surname'] = "Supplier";
		$params['repphone_work'] = $user['phone_work'] = "123123123";
		$params['repphone_prefix'] = $user['phone_prefix'] = "27";
		$params['repphone_fax'] = $user['phone_fax'] = "123123123";
		$params['repphone_mobile'] = $user['phone_mobile'] = $this->cfg['unit']['phone_mobile'];
		$params['repemail'] = $user['email'] = $this->cfg['unit']['email'];
		$params['reppreference'] = $user['preference'] = "n";
		$params['reppermission'] = $user['permission'] = "2";
		$params['reptheme'] = $user['theme'] = $this->cfg['theme'];
		$params['replang'] = $user['language'] = $this->cfg['language'];
		$params['repmandate'] = $user['mandate'] = "1000";
		$user['classification'] = "1";
		$user['branch'] = $this->get_next_id("organisation_branch");
		$user['organisation'] = $this->get_next_id("organisation");
		// branch info
		$branch['status'] = "1";
		$params['branchname'] = $branch['name'] = "1000";
		$params['branchphone_work'] = $branch['phone_work'] = "123123123";
		$params['branchphone_fax'] = $branch['phone_fax'] = "123123123";
		$params['branchphone_prefix'] = $branch['phone_prefix'] = "27";
		$params['branchemail'] = $branch['email'] = $this->cfg['unit']['email'];
		$params['branchcomment'] = $branch['comment'] = "comment";
		$params['primary_address_street'] = $branch['primary_address_street'] = "1000";
		$params['primary_address_city'] = $branch['primary_address_city'] = "1000";
		$params['primary_address_state'] = $branch['primary_address_state'] = "1000";
		$params['primary_address_postalcode'] = $branch['primary_address_postalcode'] = "1000";
		$params['alt_address_street'] = $branch['alt_address_street'] = "1000";
		$params['alt_address_city'] = $branch['alt_address_city'] = "1000";
		$params['alt_address_state'] = $branch['alt_address_state'] = "1000";
		$params['alt_address_postalcode'] = $branch['alt_address_postalcode'] = "1000";
		$params['address_country'] =$branch['alt_address_country'] = $branch['primary_address_country'] = "1000";
		$branch['organisation'] = $user['organisation'];
		$params['createorg'] = "TRUE";
		$html = $this->do_post("organisation","create","main",$params);
		$phrase = array("created_org");
		$phrase = $this->get_default_phrases($phrase);
		$pos = 0;
		foreach($phrase as $value) {
			$pos = strpos($html,$value,$pos);
			if($pos === FALSE) {
				$this->add_result(	$unit,
									"failed",
									"Could not find word : ".$value
				);
				return FALSE;
			}
		}
		// add info to database variable
		$this->add_database("organisation",$organisation);
		$this->add_database("organisation_branch",$branch);
		$this->add_database("users",$user);
		// add succesfull result
		$this->add_result($unit,"passed");
		return TRUE;		
	}
	
	function test_delete_organisation() {
		$unit = "test_delete_organisation";
		// create company
		$organisation['status']="0";
		$params['organisationname'] = $organisation['name'] = "Remove";
		$params['registered_name'] = $organisation['registered_name'] = "Remove_Reg";
		$params['classification'] = $organisation['classification'] = "2";
		$params['transaction_fee'] = $organisation['transaction_fee'] = "10";
		$params['transaction_min'] = $organisation['transaction_min'] = "10";
		$params['vat_number'] = $organisation['vat_number'] = "10";
		$params['registration_number'] = $organisation['registration_number'] = "10";
		$params['user_fee'] = $organisation['user_fee'] = "10";
		$params['sms_fee'] = $organisation['sms_fee'] = "10";
		$params['rating'] = $organisation['rating'] = "A";
		$params['repposition'] = $organisation['rep_position'] = "Admin";
		// subscriber info
		$user['status'] = "2";
		$params['repusername'] = $user['username'] = "Remove";
		$params['repname'] = $user['name'] = "Remove";
		$params['repsurname'] = $user['surname'] = "Me";
		$params['repphone_work'] = $user['phone_work'] = "123123123";
		$params['repphone_prefix'] = $user['phone_prefix'] = "27";
		$params['repphone_fax'] = $user['phone_fax'] = "123123123";
		$params['repphone_mobile'] = $user['phone_mobile'] = $this->cfg['unit']['phone_mobile'];
		$params['repemail'] = $user['email'] = $this->cfg['unit']['email'];
		$params['reppreference'] = $user['preference'] = "n";
		$params['reppermission'] = $user['permission'] = "4";
		$params['reptheme'] = $user['theme'] = $this->cfg['theme'];
		$params['replang'] = $user['language'] = $this->cfg['language'];
		$params['repmandate'] = $user['mandate'] = "1000";
		// branch info
		$branch['status'] = "1";
		$params['branchname'] = $branch['name'] = "Remove";
		$params['branchphone_work'] = $branch['phone_work'] = "123123123";
		$params['branchphone_fax'] = $branch['phone_fax'] = "123123123";
		$params['branchphone_prefix'] = $branch['phone_prefix'] = "27";
		$params['branchemail'] = $branch['email'] = $this->cfg['unit']['email'];
		$params['branchcomment'] = $branch['comment'] = "comment";
		$params['primary_address_street'] = $branch['primary_address_street'] = "1000";
		$params['primary_address_city'] = $branch['primary_address_city'] = "1000";
		$params['primary_address_state'] = $branch['primary_address_state'] = "1000";
		$params['primary_address_postalcode'] = $branch['primary_address_postalcode'] = "1000";
		$params['alt_address_street'] = $branch['alt_address_street'] = "1000";
		$params['alt_address_city'] = $branch['alt_address_city'] = "1000";
		$params['alt_address_state'] = $branch['alt_address_state'] = "1000";
		$params['alt_address_postalcode'] = $branch['alt_address_postalcode'] = "1000";
		$params['address_country'] =$branch['alt_address_country'] = $branch['primary_address_country'] = "1000"; 
		$params['createorg'] = "TRUE";
		$html = $this->do_post("organisation","create","main",$params);
		$phrase = array("created_org");
		$phrase = $this->get_default_phrases($phrase);
		$pos = 0;
		foreach($phrase as $value) {
			$pos = strpos($html,$value,$pos);
			if($pos === FALSE) {
				$this->add_result(	$unit,
									"failed",
									"Could not find word : ".$value
				);
				return FALSE;
			}
		}
		// add info to database variable
		$id = $this->add_database("organisation",$organisation);
		$this->add_database("organisation_branch",$branch);
		$this->add_database("users",$user);
		// delete organisation
		$params['id'] = $id;
		$params['deleteorg'] = "TRUE";
		$html = $this->do_post("organisation","profile","main",$params);
		$phrase = array("deleted","deleted");
		$phrase = $this->get_default_phrases($phrase);
		$pos = 0;
		foreach($phrase as $value) {
			$pos = strpos($html,$value,$pos);
			if($pos === FALSE) {
				$this->add_result(	$unit,
									"failed",
									"Could not find word : ".$value
				);
				return FALSE;
			}
		}
		// add succesfull result
		$this->add_result($unit,"passed");
		return TRUE;		
	}
	
	function test_update_organisation() {
		$unit = "test_update_organisation";
		// create company
		$params['organisationname'] = $organisation['name'] = "Test Update";
		$params['registered_name'] = $organisation['registered_name'] = "Another_Reg";
		$params['classification'] = $organisation['classification'] = "2";
		$params['transaction_fee'] = $organisation['transaction_fee'] = "10";
		$params['transaction_min'] = $organisation['transaction_min'] = "10";
		$params['vat_number'] = $organisation['vat_number'] = "10";
		$params['registration_number'] = $organisation['registration_number'] = "10";
		$params['user_fee'] = $organisation['user_fee'] = "10";
		$params['sms_fee'] = $organisation['sms_fee'] = "10";
		$params['rating'] = $organisation['rating'] = "B";
		$params['repposition'] = $organisation['rep_position'] = "Admin";
		// subscriber info
		$params['repusername'] = $user['username'] = "another";
		$params['repname'] = $user['name'] = "Sanother";
		$params['repsurname'] = $user['surname'] = "Canother";
		$params['repphone_work'] = $user['phone_work'] = "123123123";
		$params['repphone_prefix'] = $user['phone_prefix'] = "27";
		$params['repphone_fax'] = $user['phone_fax'] = "123123123";
		$params['repphone_mobile'] = $user['phone_mobile'] = $this->cfg['unit']['phone_mobile'];
		$params['repemail'] = $user['email'] = $this->cfg['unit']['email'];
		$params['reppreference'] = $user['preference'] = "n";
		$params['reppermission'] = $user['permission'] = "4";
		$params['reptheme'] = $user['theme'] = $this->cfg['theme'];
		$params['replang'] = $user['language'] = $this->cfg['language'];
		$params['repmandate'] = $user['mandate'] = "1000";
		// branch info
		$params['branchname'] = $branch['name'] = "Banother";
		$params['branchphone_work'] = $branch['phone_work'] = "123123123";
		$params['branchphone_fax'] = $branch['phone_fax'] = "123123123";
		$params['branchphone_prefix'] = $branch['phone_prefix'] = "27";
		$params['branchemail'] = $branch['email'] = $this->cfg['unit']['email'];
		$params['branchcomment'] = $branch['comment'] = "comment";
		$params['primary_address_street'] = $branch['primary_address_street'] = "1000";
		$params['primary_address_city'] = $branch['primary_address_city'] = "1000";
		$params['primary_address_state'] = $branch['primary_address_state'] = "1000";
		$params['primary_address_postalcode'] = $branch['primary_address_postalcode'] = "1000";
		$params['alt_address_street'] = $branch['alt_address_street'] = "1000";
		$params['alt_address_city'] = $branch['alt_address_city'] = "1000";
		$params['alt_address_state'] = $branch['alt_address_state'] = "1000";
		$params['alt_address_postalcode'] = $branch['alt_address_postalcode'] = "1000";
		$params['address_country'] =$branch['alt_address_country'] = $branch['primary_address_country'] = "1000";
		// store info
		$organisation['status']= $branch['status'] = "1"; 
		$user['status'] = "2";
		$params['createorg'] = "TRUE";
		$html = $this->do_post("organisation","create","main",$params);
		$phrase = array("created_org");
		$phrase = $this->get_default_phrases($phrase);
		$pos = 0;
		foreach($phrase as $value) {
			$pos = strpos($html,$value,$pos);
			if($pos === FALSE) {
				$this->add_result(	$unit,
									"failed",
									"Could not find word : ".$value
				);
				return FALSE;
			}
		}
		// add info to database variable
		$id = $this->add_database("organisation",$organisation);
		$this->add_database("organisation_branch",$branch);
		$this->add_database("users",$user);
		// update organisation
		unset($params);
		$params['id'] = $id;
		$params['transaction_fee'] = "10";
		$params['transaction_min'] = "10";
		$params['sms_fee'] = "10";
		$params['user_fee'] = "10";
		$params['vat_number'] = "XXX";
		$params['registered_name'] = "XXX";
		$params['organisationname'] = "Another";
		$params['registration_number'] = "Another";
		$params['rating'] = "B";
		$params['changeorg'] = "TRUE";
		$html = $this->do_post("organisation","profile","main",$params);
		$phrase = array("updated");
		$phrase = $this->get_default_phrases($phrase);
		$pos = 0;
		foreach($phrase as $value) {
			$pos = strpos($html,$value,$pos);
			if($pos === FALSE) {
				$this->add_result(	$unit,
									"failed",
									"Could not find word : ".$value
				);
				return FALSE;
			}
		}
		$this->add_result($unit,"passed");
		return TRUE;		
	}
}

// test generic functions
Class supplier_linking_tester extends module_tester {
	
	function supplier_linking_tester() {
		// what module it tests
		$this->module = "organisation";
		// the dependency of the module
		$this->dependency[] = "organisation_tester";
		$this->dependency[] = "area_tester";
		$this->dependency[] = "category_tester";
		// description what all the tester tests
		$this->description = "Supplier can be linked to a Area. Supplier can be linked to a Category.".
		"Supplier can be linked to a Company.";
		// level of testing
		$this->level = "1";
	}
	
	function do_testing() {
		// login as admin
		$this->login("admin");
		// do tests
		$this->test_area_supplier();
		$this->test_category_supplier();
		$this->test_supplier_company();
		// logout as admin
		$this->logout();
		$this->done = TRUE;
	}
	
	function test_area_supplier() {
		$unit = "area_supplier";
		global $database;
		// get a supplier id
		foreach($database['organisation'] as $key => $value) {
			if($value['classification'] == "1") {
				$params['organisationid'] = $key;
				break;
			}
		}
		// if could not find supplier
		if(!$params['organisationid']) {
			$this->add_result(	$unit,
								"failed",
								"Could not find a supplier "
			);
			return FALSE;
		}
		// get areas
		foreach($database['area'] as $key => $value) {
			$params['areaselect'][$key] = $key;
		}
		// if could not find areas
		if(!$params['areaselect']) {
			$this->add_result(	$unit,
								"failed",
								"Could not find a area "
			);
			return FALSE;
		}
		$params['change'] = "TRUE";
		$html = $this->do_post("organisation","show_area","main",$params);
		$phrase = array("areatitle","updated");
		$phrase = $this->get_default_phrases($phrase);
		$pos = 0;
		foreach($phrase as $value) {
			$pos = strpos($html,$value,$pos);
			if($pos === FALSE) {
				$this->add_result(	$unit,
									"failed",
									"Could not find word : ".$value
				);
				return FALSE;
			}
		}
		// add information in database variable
		$area_supplier['supplier'] = $params['organisationid'];
		$area_supplier['status'] = "1";
		foreach($params['areaselect'] as $value) {
			$database['area_suppliercounter']++;
			$area_supplier['area'] = $value;
			$database['area_supplier'][$database['area_suppliercounter']] = $area_supplier;
		}
		$this->add_result(	$unit,
							"passed"
		);
		return TRUE;		
	}
	
	function test_category_supplier() {
		$unit = "category_supplier";
		global $database;
		// get a supplier id
		foreach($database['organisation'] as $key => $value) {
			if($value['classification'] == "1") {
				$params['organisationid'] = $key;
				break;
			}
		}
		// if could not find supplier
		if(!$params['organisationid']) {
			$this->add_result(	$unit,
								"failed",
								"Could not find a supplier "
			);
			return FALSE;
		}
		// get category_sub
		foreach($database['category_sub'] as $key => $value) {
			$params['category_sub'][$key] = $key;
		}
		// if could not find areas
		if(!$params['category_sub']) {
			$this->add_result(	$unit,
								"failed",
								"Could not find a sub category "
			);
			return FALSE;
		}
		$params['change'] = "TRUE";
		$html = $this->do_post("organisation","show_category","main",$params);
		$phrase = array("categorytitle","updated");
		$phrase = $this->get_default_phrases($phrase);
		$pos = 0;
		foreach($phrase as $value) {
			$pos = strpos($html,$value,$pos);
			if($pos === FALSE) {
				$this->add_result(	$unit,
									"failed",
									"Could not find word : ".$value
				);
				return FALSE;
			}
		}
		// add information in database variable
		$category_supplier['supplier'] = $params['organisationid'];
		$category_supplier['status'] = "1";
		foreach($params['category_sub'] as $value) {
			$database['category_suppliercounter']++;
			$category_supplier['category_sub'] = $value;
			$database['category_supplier'][$database['category_suppliercounter']] = $category_supplier;
		}
		$this->add_result(	$unit,
							"passed"
		);
		return TRUE;		
	}
	
	function test_supplier_company() {
		$unit = "supplier_company";
		global $database;
		// get a supplier id
		foreach($database['organisation'] as $key => $value) {
			if($value['classification'] == "1") {
				$params['organisationid'] = $key;
				break;
			}
		}
		// if could not find supplier
		if(!$params['organisationid']) {
			$this->add_result(	$unit,
								"failed",
								"Could not find a supplier "
			);
			return FALSE;
		}
		// get areas
		foreach($database['organisation'] as $key => $value) {
			if($value['classification'] == "2") {
				$params['link'][$key] = $key;
			}
		}
		// if could not find companies
		if(!$params['link']) {
			$this->add_result(	$unit,
								"failed",
								"Could not find a company "
			);
			return FALSE;
		}
		$params['change'] = "TRUE";
		$html = $this->do_post("organisation","company_link","main",$params);
		$phrase = array("companypanel","updated");
		$phrase = $this->get_default_phrases($phrase);
		$pos = 0;
		foreach($phrase as $value) {
			$pos = strpos($html,$value,$pos);
			if($pos === FALSE) {
				$this->add_result(	$unit,
									"failed",
									"Could not find word : ".$value
				);
				return FALSE;
			}
		}
		// add information in database variable
		$organisation_supplier['supplier'] = $params['organisationid'];
		$organisation_supplier['status'] = "1";
		foreach($params['link'] as $value) {
			$database['organisation_suppliercounter']++;
			$organisation_supplier['organisation'] = $value;
			$database['organisation_supplier'][$database['organisation_suppliercounter']] = $organisation_supplier;
		}
		$this->add_result(	$unit,
							"passed"
		);
		return TRUE;		
	}
}

// register with tendersystem tester
if($new_tendersystem_tester) {
	$new_tendersystem_tester->reg_tester("organisation_tester");
	$new_tendersystem_tester->reg_tester("supplier_linking_tester");
}
?>