<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../procure/templates/procure_generic.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
		<link rel="stylesheet" type="text/css" media="all" href="./theme/{$theme}/style_calendar.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'overview'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="overview"/>
					<input type="hidden" name="function" value="show_supplier_overview"/>
					<input type="hidden" name="organisationid" value="{organisation/subscriber_organisationid}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="600" bgcolor="FFFFFF">
						<tr>
							<td class="h t1" colspan="4">
								<xsl:value-of select="$lng/overviewinfo"/>
							</td>
						</tr>
						<tr>
							<td class="t2">
								<b><xsl:value-of select="$lng/startdate"/></b>
								<input type="text" name="startdate" id="startdate" value="{daysago3}" class="t2" size="10" maxlength="10"/>
								<xsl:value-of select="' '"/>
								<img src="./theme/{$theme}/icon/calendar.gif" id="trigger_startdate" style="cursor: pointer; border: 0px;" alt="Date selector" />
							</td>
							<td class="t2">
								<b><xsl:value-of select="$lng/enddate"/></b>
								<input type="text" name="enddate" id="enddate" value="{today}" class="t2" size="10" maxlength="10"/>
								<xsl:value-of select="' '"/>
								<img src="./theme/{$theme}/icon/calendar.gif" id="trigger_enddate" style="cursor: pointer; border: 0px;" alt="Date selector" />
							</td>
							<td class="t2">
								<xsl:call-template name="submit_button">
									<xsl:with-param name="submit" select="'yes'"/>
									<xsl:with-param name="showaddproduct" select="'no'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>	
					<table border="0" align="center" cellpadding="1" cellspacing="1" width="100%" bgcolor="FFFFFF">
						<xsl:for-each select="organisation">
							<tr>
								<td class="h t3" colspan="16">
									<xsl:value-of select="$lng/overview"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="$lng/of"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="organisationname"/>
									<xsl:value-of select="' ('"/>
									<xsl:value-of select="//startdate"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="$lng/to"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="//enddate"/>
									<xsl:value-of select="')'"/>
								</td>
							</tr>
							<tr>
								<td colspan="16">
									<br/>
								</td>	
							</tr>
						<xsl:for-each select="branch">
							<tr>
								<td	class="h1 t1" colspan="16">
									<b><xsl:value-of select="$lng/branch"/><xsl:value-of select="' '"/><xsl:value-of select="name"/></b>						
								</td>
							</tr>	
							<tr>
								<td class="h1b t1" align="left" valign="bottom">
									<xsl:value-of select="$lng/id"/>
								</td>
								<td class="h1c t1" align="left" valign="bottom">
									<xsl:value-of select="$lng/name"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="$lng/rfqs"/><br/>
									<xsl:value-of select="$lng/received"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="$lng/quotes"/><br/>
									<xsl:value-of select="$lng/sent"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="$lng/quote"/><br/>
									<xsl:value-of select="$lng/value"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="$lng/quote"/><br/>
									<xsl:value-of select="$lng/ratio"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="$lng/items"/><br/>
									<xsl:value-of select="$lng/awarded"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="$lng/awarded"/><br/>
									<xsl:value-of select="$lng/value"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="$lng/purchase"/><br/>
									<xsl:value-of select="$lng/orders"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="$lng/cancelled"/><br/>
									<xsl:value-of select="$lng/po"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="$lng/conversion"/><br/>
									<xsl:value-of select="$lng/rate"/>
								</td>
								<td class="h1c t1" align="center">										
									<xsl:value-of select="$lng/uncompleted"/><br/>
									<xsl:value-of select="$lng/rfqs"/>
								</td>			
								<td class="h1c t1" align="center">
									<xsl:value-of select="$lng/feedback"/><br/>
									<xsl:value-of select="$lng/requests"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="$lng/feedback"/><br/>
									<xsl:value-of select="$lng/responses"/>
								</td>
							</tr>
							<xsl:for-each select="users">
								<tr>
									<td class="h2b t" align="left">
										<xsl:value-of select="id"/>
									</td>
									<td class="h2c t" align="left">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',id)"/>
											</xsl:attribute>
											<xsl:value-of select="name"/>
										</a>
									</td>
									<td class="h2c t" align="center">
										<xsl:value-of select="count"/>
									</td>														
									<td class="h2c t" align="center">
										<xsl:value-of select="quotes"/>
									</td>
									<td class="h2c t" align="left">
										<xsl:value-of select="//localprecurrency"/><xsl:value-of select="quotes_value"/><xsl:value-of select="//localpostcurrency"/>
									</td>										
									<td class="h2c t" align="center">
										<xsl:value-of select="quote_ratio"/>
									</td>
									<td class="h2c t" align="center">
										<xsl:value-of select="total_items_awarded"/>
									</td>										
									<td class="h2c t" align="left">
										<xsl:value-of select="//localprecurrency"/><xsl:value-of select="total_items_awarded_value"/><xsl:value-of select="//localpostcurrency"/>
									</td>
									<td class="h2c t" align="center">
										<xsl:value-of select="total_orders"/>
									</td>	
									<td class="h2c t" align="center">
										<xsl:value-of select="cancelled_orders"/>
									</td>	
									<td class="h2c t" align="center">
										<xsl:value-of select="conversion_rate"/><xsl:value-of select="'%'"/>
									</td>	
									<td class="h2c t" align="center">
										<xsl:value-of select="uncompleted_rfqs"/>				
									</td>													
									<td class="h2c t" align="center">
										<xsl:value-of select="feedback_requests"/>
									</td>	
									<td class="h2c t" align="center">
										<xsl:value-of select="feedback_responses"/>
									</td>													
								</tr>
							</xsl:for-each>										
							<tr>
								<td class="h1b t1" align="left" colspan="2">
									<xsl:value-of select="$lng/totals"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="total_rfqs_received"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="total_quotes"/>
								</td>
								<td class="h1c t1" align="left">
									<xsl:value-of select="//localprecurrency"/><xsl:value-of select="total_quote_value"/><xsl:value-of select="//localpostcurrency"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="total_quote_ratio"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="total_items_awarded"/>
								</td>
								<td class="h1c t1" align="left">
									<xsl:value-of select="//localprecurrency"/><xsl:value-of select="total_items_awarded_value"/><xsl:value-of select="//localpostcurrency"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="total_orders"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="total_cancelled_orders"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="total_conversion_rate"/><xsl:value-of select="'%'"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="total_uncompleted"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="total_feedback_requests"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="total_feedback_responses"/>
								</td>
							</tr>
							<tr>
								<td colspan="16">	
									<br/>							
								</td>	
							</tr>	
						</xsl:for-each>
							<tr>
								<td class="h t1" align="left" colspan="2">
									<xsl:value-of select="$lng/totals"/>
								</td>
								<td class="ha t1" align="center" colspan="1">
									<xsl:value-of select="total_rfqs_received"/>
								</td>											
								<td class="ha t1" align="center">
									<xsl:value-of select="total_quotes"/>
								</td>
								<td class="ha t1" align="left">
									<xsl:value-of select="//localprecurrency"/><xsl:value-of select="total_quote_value"/><xsl:value-of select="//localpostcurrency"/>
								</td>
								<td class="ha t1" align="center">
									<xsl:value-of select="total_quote_ratio"/>
								</td>
								<td class="ha t1" align="center">
									<xsl:value-of select="total_items_awarded"/>
								</td>
								<td class="ha t1" align="left">
									<xsl:value-of select="//localprecurrency"/><xsl:value-of select="total_items_awarded_value"/><xsl:value-of select="//localpostcurrency"/>
								</td>
								<td class="ha t1" align="center">
									<xsl:value-of select="total_orders"/>
								</td>
								<td class="ha t1" align="center">
									<xsl:value-of select="total_cancelled_orders"/>
								</td>
								<td class="ha t1" align="center">
									<xsl:value-of select="total_conversion_rate"/><xsl:value-of select="'%'"/>
								</td>
								<td class="ha t1" align="center">
									<xsl:value-of select="total_uncompleted"/>
								</td>
								<td class="ha t1" align="center">
									<xsl:value-of select="total_feedback_requests"/>
								</td>
								<td class="ha t1" align="center">
									<xsl:value-of select="total_feedback_responses"/>
								</td>	
							</tr>
							<xsl:if test="../total_uncompleted or ../total_uncompleted_value or ../total_items_awarded or ../total_items_awarded_value or ../total_rfqs_closed or ../total_rfqs_open or ../total_items or ../total_items_value or ../total_orders or ../cancelled_orders or ../conversion_rate or ../average">
								<tr>
									<td colspan="16">
										<br/>
									</td>	
								</tr>	
							</xsl:if>	
						</xsl:for-each>
						<xsl:if test="total_uncompleted or total_uncompleted_value or total_items_awarded or total_items_awarded_value or total_rfqs_closed or total_rfqs_open or total_items or total_items_value or total_orders or cancelled_orders or conversion_rate or average">
							<tr>
								<td class="h t1" align="left" colspan="2">
									<xsl:value-of select="$lng/grandtotals"/>
								</td>
								<td class="ha t1" align="center">
									<xsl:value-of select="total_rfqs_received"/>
								</td>
								<td class="ha t1" align="center">
									<xsl:value-of select="total_quotes"/>
								</td>
								<td class="ha t1" align="left">
									<xsl:value-of select="//localprecurrency"/><xsl:value-of select="total_quote_value"/><xsl:value-of select="//localpostcurrency"/>
								</td>	
								<td class="ha t1" align="center">
									<xsl:value-of select="total_quote_ratio"/>
								</td>								
								<td class="ha t1" align="center">
									<xsl:value-of select="total_items_awarded"/>
								</td>	
								<td class="ha t1" align="left">
									<xsl:value-of select="//localprecurrency"/><xsl:value-of select="total_items_awarded_value"/><xsl:value-of select="//localpostcurrency"/>
								</td>	
								<td class="ha t1" align="center">
									<xsl:value-of select="total_orders"/>
								</td>
								<td class="ha t1" align="center">
									<xsl:value-of select="total_cancelled_orders"/>
								</td>								
								<td class="ha t1" align="center">
									<xsl:value-of select="total_conversion_rate"/><xsl:value-of select="'%'"/>
								</td>
								<td class="ha t1" align="center">
									<xsl:value-of select="total_uncompleted"/>
								</td>
								<td class="ha t1" align="center">
									<xsl:value-of select="total_feedback_requests"/>
								</td>
								<td class="ha t1" align="center">
									<xsl:value-of select="total_feedback_responses"/>
								</td>	
							</tr>	
						</xsl:if>					
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript" src="./modules/external/javascript/calendar/calendar.js"></script>
	<script type="text/javascript" src="./modules/external/language/{$language}/calendar.js"></script>
	<script type="text/javascript" src="./modules/external/javascript/calendar/calendar-setup.js"></script>

	<script type="text/javascript">
		Calendar.setup({inputField:"startdate",ifFormat:"%Y-%m-%d",button:"trigger_startdate",singleClick:true});
		Calendar.setup({inputField:"enddate",ifFormat:"%Y-%m-%d",button:"trigger_enddate",singleClick:true});
		function setDate() {
			var variables = "&amp;startdate="+document.report.startdate.value;
			variables += "&amp;enddate="+document.report.enddate.value;
			parent.main.location = 'main.php?module=overview&amp;function=show_supplier_overview&amp;organisationid=<xsl:value-of select="organisation/subscriber_organisationid"/>' + variables;
		}
	</script>		
	
</body>
</html>	
</xsl:template>

</xsl:stylesheet>